/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import java.util.AbstractMap;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CaseInsensitiveMap<K, V>
implements Map<K, V> {
    private Map<K, V> map;

    public CaseInsensitiveMap() {
        this.map = new LinkedHashMap();
    }

    public CaseInsensitiveMap(int initialCapacity) {
        this.map = new LinkedHashMap(initialCapacity);
    }

    public CaseInsensitiveMap(Map<? extends K, ? extends V> map) {
        this(map.size());
        this.putAll(map);
    }

    public CaseInsensitiveMap(int initialCapacity, float loadFactor) {
        this.map = new LinkedHashMap(initialCapacity, loadFactor);
    }

    @Override
    public V get(Object key) {
        if (key instanceof String) {
            String keyString = (String)key;
            return this.map.get(new CaseInsensitiveString(keyString));
        }
        return this.map.get(key);
    }

    @Override
    public V put(K key, V value) {
        if (key instanceof String) {
            CaseInsensitiveString newKey = new CaseInsensitiveString((String)key);
            if (this.map.containsKey(newKey)) {
                this.map.remove(newKey);
            }
            return this.map.put(newKey, value);
        }
        return this.map.put(key, value);
    }

    @Override
    public boolean containsKey(Object key) {
        if (key instanceof String) {
            String keyString = (String)key;
            return this.map.containsKey(new CaseInsensitiveString(keyString));
        }
        return this.map.containsKey(key);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        if (m == null) {
            return;
        }
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(Object key) {
        if (key instanceof String) {
            String keyString = (String)key;
            return this.map.remove(new CaseInsensitiveString(keyString));
        }
        return this.map.remove(key);
    }

    @Override
    public Set<K> keySet() {
        LinkedHashSet<K> temp = new LinkedHashSet<K>();
        for (K key : this.map.keySet()) {
            temp.add(key instanceof CaseInsensitiveString ? key.toString() : key);
        }
        return new LocalSet(temp, this);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        Set<Map.Entry<K, V>> insensitiveEntrySet = this.map.entrySet();
        LinkedHashSet<Map.Entry<K, V>> returnEntrySet = new LinkedHashSet<Map.Entry<K, V>>();
        for (Map.Entry<K, V> entry : insensitiveEntrySet) {
            if (entry.getKey() instanceof CaseInsensitiveString) {
                CaseInsensitiveString key = (CaseInsensitiveString)entry.getKey();
                entry = new AbstractMap.SimpleImmutableEntry<String, V>(key.toString(), entry.getValue());
            }
            returnEntrySet.add(entry);
        }
        return returnEntrySet;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Map)) {
            return false;
        }
        Map that = (Map)other;
        if (that.size() != this.size()) {
            return false;
        }
        for (Map.Entry entry : that.entrySet()) {
            Object thatKey = entry.getKey();
            if (!this.containsKey(thatKey)) {
                return false;
            }
            Object thatValue = entry.getValue();
            V thisValue = this.get(thatKey);
            if (!(thatValue == null || thisValue == null ? thatValue != thisValue : !thisValue.equals(thatValue))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int h = 0;
        for (Map.Entry<K, V> entry : this.entrySet()) {
            V value;
            K key = entry.getKey();
            if (key != null) {
                h = key instanceof String ? (h += ((String)key).toLowerCase().hashCode()) : (h += key.hashCode());
            }
            if ((value = entry.getValue()) == null) continue;
            h += value.hashCode();
        }
        return h;
    }

    public String toString() {
        return this.map.toString();
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public Collection<V> values() {
        return this.map.values();
    }

    private static class CaseInsensitiveString {
        private final String caseInsensitiveString;

        private CaseInsensitiveString(String string) {
            this.caseInsensitiveString = string;
        }

        public String toString() {
            return this.caseInsensitiveString;
        }

        public int hashCode() {
            if (this.caseInsensitiveString == null) {
                return 0;
            }
            return this.caseInsensitiveString.toLowerCase().hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof CaseInsensitiveString)) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            CaseInsensitiveString other = (CaseInsensitiveString)obj;
            if (this.caseInsensitiveString == null) {
                return other.caseInsensitiveString == null;
            }
            return this.caseInsensitiveString.equalsIgnoreCase(other.caseInsensitiveString);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LocalSet
    extends LinkedHashSet<K> {
        private static final long serialVersionUID = -4681165782204849813L;
        Set<K> localSet;
        Map<K, V> localMap;

        public LocalSet(Set<K> s, Map<K, V> m) {
            super(s);
            this.localSet = s;
            this.localMap = m;
        }

        @Override
        public Iterator<K> iterator() {
            return new Iterator<K>(){
                Iterator<K> iter;
                K lastRetured;
                {
                    this.iter = LocalSet.this.localSet.iterator();
                    this.lastRetured = null;
                }

                @Override
                public boolean hasNext() {
                    return this.iter.hasNext();
                }

                @Override
                public K next() {
                    this.lastRetured = this.iter.next();
                    return this.lastRetured;
                }

                @Override
                public void remove() {
                    this.iter.remove();
                    LocalSet.this.localMap.remove(this.lastRetured);
                }
            };
        }
    }
}

