/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import com.cedarsoftware.util.IOUtilities;
import com.cedarsoftware.util.SafeSimpleDateFormat;
import com.cedarsoftware.util.StringUtilities;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class UrlUtilities {
    private static String globalUserAgent = null;
    private static String globalReferrer = null;
    public static final ThreadLocal<String> userAgent = new ThreadLocal();
    public static final ThreadLocal<String> referrer = new ThreadLocal();
    public static final String SET_COOKIE = "Set-Cookie";
    public static final String SET_COOKIE_SEPARATOR = "; ";
    public static final String COOKIE = "Cookie";
    public static final String COOKIE_VALUE_DELIMITER = ";";
    public static final String PATH = "path";
    public static final String EXPIRES = "expires";
    public static final SafeSimpleDateFormat DATE_FORMAT = new SafeSimpleDateFormat("EEE, dd-MMM-yyyy hh:mm:ss z");
    public static final char NAME_VALUE_SEPARATOR = '=';
    public static final char DOT = '.';
    private static final Pattern resPattern = Pattern.compile("^res\\:\\/\\/", 2);
    private static final Logger LOG = LogManager.getLogger(UrlUtilities.class);
    public static final TrustManager[] NAIVE_TRUST_MANAGER = new TrustManager[]{new X509TrustManager(){

        @Override
        public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }};
    public static final HostnameVerifier NAIVE_VERIFIER = new HostnameVerifier(){

        @Override
        public boolean verify(String s, SSLSession sslSession) {
            return true;
        }
    };
    protected static SSLSocketFactory naiveSSLSocketFactory;

    private UrlUtilities() {
    }

    public static void clearGlobalUserAgent() {
        globalUserAgent = null;
    }

    public static void clearGlobalReferrer() {
        globalReferrer = null;
    }

    public static void setReferrer(String referer) {
        if (StringUtilities.isEmpty(globalReferrer)) {
            globalReferrer = referer;
        }
        referrer.set(referer);
    }

    public static String getReferrer() {
        String localReferrer = referrer.get();
        if (StringUtilities.hasContent(localReferrer)) {
            return localReferrer;
        }
        return globalReferrer;
    }

    public static void setUserAgent(String agent) {
        if (StringUtilities.isEmpty(globalUserAgent)) {
            globalUserAgent = agent;
        }
        userAgent.set(agent);
    }

    public static String getUserAgent() {
        String localAgent = userAgent.get();
        if (StringUtilities.hasContent(localAgent)) {
            return localAgent;
        }
        return globalUserAgent;
    }

    /*
     * Exception decompiling
     */
    public static void readErrorResponse(URLConnection c) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void disconnect(HttpURLConnection c) {
        if (c != null) {
            try {
                c.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void getCookies(URLConnection conn, Map store) {
        String headerName;
        Map domainStore;
        String domain = UrlUtilities.getCookieDomainFromHost(conn.getURL().getHost());
        if (store.containsKey(domain)) {
            domainStore = (Map)store.get(domain);
        } else {
            domainStore = new ConcurrentHashMap();
            store.put(domain, domainStore);
        }
        if (domainStore.containsKey("JSESSIONID")) {
            return;
        }
        int i = 1;
        while ((headerName = conn.getHeaderFieldKey(i)) != null) {
            if (headerName.equalsIgnoreCase(SET_COOKIE)) {
                String token;
                ConcurrentHashMap<String, String> cookie = new ConcurrentHashMap<String, String>();
                StringTokenizer st = new StringTokenizer(conn.getHeaderField(i), COOKIE_VALUE_DELIMITER);
                if (st.hasMoreTokens()) {
                    token = st.nextToken();
                    String key = token.substring(0, token.indexOf(61)).trim();
                    String value = token.substring(token.indexOf(61) + 1);
                    domainStore.put(key, cookie);
                    cookie.put(key, value);
                }
                while (st.hasMoreTokens()) {
                    token = st.nextToken();
                    int pos = token.indexOf(61);
                    if (pos == -1) continue;
                    String key = token.substring(0, pos).toLowerCase().trim();
                    String value = token.substring(token.indexOf(61) + 1);
                    cookie.put(key, value);
                }
            }
            ++i;
        }
    }

    public static void setCookies(URLConnection conn, Map store) throws IOException {
        URL url = conn.getURL();
        String domain = UrlUtilities.getCookieDomainFromHost(url.getHost());
        String path = url.getPath();
        Map domainStore = (Map)store.get(domain);
        if (domainStore == null) {
            return;
        }
        StringBuilder cookieStringBuffer = new StringBuilder();
        Iterator cookieNames = domainStore.keySet().iterator();
        while (cookieNames.hasNext()) {
            String cookieName = (String)cookieNames.next();
            Map cookie = (Map)domainStore.get(cookieName);
            if (!UrlUtilities.comparePaths((String)cookie.get(PATH), path) || !UrlUtilities.isNotExpired((String)cookie.get(EXPIRES))) continue;
            cookieStringBuffer.append(cookieName);
            cookieStringBuffer.append('=');
            cookieStringBuffer.append((String)cookie.get(cookieName));
            if (!cookieNames.hasNext()) continue;
            cookieStringBuffer.append(SET_COOKIE_SEPARATOR);
        }
        try {
            conn.setRequestProperty(COOKIE, cookieStringBuffer.toString());
        }
        catch (IllegalStateException e) {
            throw new IOException("Illegal State! Cookies cannot be set on a URLConnection that is already connected. Only call setCookies(java.net.URLConnection) AFTER calling java.net.URLConnection.connect().");
        }
    }

    public static String getCookieDomainFromHost(String host) {
        while (host.indexOf(46) != host.lastIndexOf(46)) {
            host = host.substring(host.indexOf(46) + 1);
        }
        return host;
    }

    static boolean isNotExpired(String cookieExpires) {
        if (cookieExpires == null) {
            return true;
        }
        try {
            return new Date().compareTo(DATE_FORMAT.parse(cookieExpires)) <= 0;
        }
        catch (ParseException e) {
            LOG.info("Parse error on cookie expires value: " + cookieExpires, (Throwable)e);
            return false;
        }
    }

    static boolean comparePaths(String cookiePath, String targetPath) {
        return cookiePath == null || "/".equals(cookiePath) || targetPath.regionMatches(0, cookiePath, 0, cookiePath.length());
    }

    public static String getContentFromUrlAsString(String url) {
        return UrlUtilities.getContentFromUrlAsString(url, null, null, true);
    }

    public static String getContentFromUrlAsString(URL url, boolean allowAllCerts) {
        return UrlUtilities.getContentFromUrlAsString(url, null, null, allowAllCerts);
    }

    public static String getContentFromUrlAsString(String url, Map inCookies, Map outCookies, boolean trustAllCerts) {
        byte[] bytes = UrlUtilities.getContentFromUrl(url, inCookies, outCookies, trustAllCerts);
        return bytes == null ? null : StringUtilities.createString(bytes, "UTF-8");
    }

    public static String getContentFromUrlAsString(URL url, Map inCookies, Map outCookies, boolean trustAllCerts) {
        byte[] bytes = UrlUtilities.getContentFromUrl(url, inCookies, outCookies, trustAllCerts);
        return bytes == null ? null : StringUtilities.createString(bytes, "UTF-8");
    }

    public static byte[] getContentFromUrl(String url) {
        return UrlUtilities.getContentFromUrl(url, null, null, true);
    }

    public static byte[] getContentFromUrl(URL url, boolean allowAllCerts) {
        return UrlUtilities.getContentFromUrl(url, null, null, allowAllCerts);
    }

    public static byte[] getContentFromUrl(String url, Map inCookies, Map outCookies, boolean allowAllCerts) {
        try {
            return UrlUtilities.getContentFromUrl(UrlUtilities.getActualUrl(url), inCookies, outCookies, allowAllCerts);
        }
        catch (Exception e) {
            LOG.warn("Exception occurred fetching content from url: " + url, (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getContentFromUrl(URL url, Map inCookies, Map outCookies, boolean allowAllCerts) {
        URLConnection c = null;
        try {
            c = UrlUtilities.getConnection(url, inCookies, true, false, false, allowAllCerts);
            ByteArrayOutputStream out = new ByteArrayOutputStream(16384);
            InputStream stream = IOUtilities.getInputStream(c);
            IOUtilities.transfer(stream, (OutputStream)out);
            stream.close();
            if (outCookies != null) {
                UrlUtilities.getCookies(c, outCookies);
            }
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        catch (SSLHandshakeException e) {
            LOG.warn("SSL Exception occurred fetching content from url: " + url, (Throwable)e);
            byte[] byArray = null;
            return byArray;
        }
        catch (Exception e) {
            UrlUtilities.readErrorResponse(c);
            LOG.warn("Exception occurred fetching content from url: " + url, (Throwable)e);
            byte[] byArray = null;
            return byArray;
        }
        finally {
            if (c instanceof HttpURLConnection) {
                UrlUtilities.disconnect((HttpURLConnection)c);
            }
        }
    }

    public static byte[] getContentFromUrl(String url, Map inCookies, Map outCookies) {
        return UrlUtilities.getContentFromUrl(url, inCookies, outCookies, true);
    }

    public static URLConnection getConnection(String url, boolean input, boolean output, boolean cache) throws IOException {
        return UrlUtilities.getConnection(UrlUtilities.getActualUrl(url), null, input, output, cache, true);
    }

    public static URLConnection getConnection(URL url, boolean input, boolean output, boolean cache) throws IOException {
        return UrlUtilities.getConnection(url, null, input, output, cache, true);
    }

    public static URLConnection getConnection(URL url, Map inCookies, boolean input, boolean output, boolean cache, boolean allowAllCerts) throws IOException {
        String agent;
        URLConnection c = url.openConnection();
        c.setRequestProperty("Accept-Encoding", "gzip, deflate");
        c.setAllowUserInteraction(false);
        c.setDoOutput(output);
        c.setDoInput(input);
        c.setUseCaches(cache);
        c.setReadTimeout(220000);
        c.setConnectTimeout(45000);
        String ref = UrlUtilities.getReferrer();
        if (StringUtilities.hasContent(ref)) {
            c.setRequestProperty("Referer", ref);
        }
        if (StringUtilities.hasContent(agent = UrlUtilities.getUserAgent())) {
            c.setRequestProperty("User-Agent", agent);
        }
        if (c instanceof HttpURLConnection) {
            HttpURLConnection.setFollowRedirects(true);
        }
        if (c instanceof HttpsURLConnection && allowAllCerts) {
            try {
                UrlUtilities.setNaiveSSLSocketFactory((HttpsURLConnection)c);
            }
            catch (Exception e) {
                LOG.warn("Could not access '" + url.toString() + "'", (Throwable)e);
            }
        }
        if (inCookies != null) {
            UrlUtilities.setCookies(c, inCookies);
        }
        return c;
    }

    private static void setNaiveSSLSocketFactory(HttpsURLConnection sc) {
        sc.setSSLSocketFactory(naiveSSLSocketFactory);
        sc.setHostnameVerifier(NAIVE_VERIFIER);
    }

    public static URL getActualUrl(String url) throws MalformedURLException {
        Matcher m = resPattern.matcher(url);
        return m.find() ? UrlUtilities.class.getClassLoader().getResource(url.substring(m.end())) : new URL(url);
    }

    static {
        try {
            HttpURLConnection.setFollowRedirects(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, NAIVE_TRUST_MANAGER, new SecureRandom());
            naiveSSLSocketFactory = sslContext.getSocketFactory();
        }
        catch (Exception e) {
            LOG.warn("Failed to build Naive SSLSocketFactory", (Throwable)e);
        }
    }
}

