/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import com.cedarsoftware.util.DateUtilities;
import com.cedarsoftware.util.SafeSimpleDateFormat;
import com.cedarsoftware.util.StringUtilities;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public final class Converter {
    private static final Byte BYTE_ZERO = 0;
    private static final Byte BYTE_ONE = 1;
    private static final Short SHORT_ZERO = 0;
    private static final Short SHORT_ONE = 1;
    private static final Integer INTEGER_ZERO = 0;
    private static final Integer INTEGER_ONE = 1;
    private static final Long LONG_ZERO = 0L;
    private static final Long LONG_ONE = 1L;
    private static final Float FLOAT_ZERO = Float.valueOf(0.0f);
    private static final Float FLOAT_ONE = Float.valueOf(1.0f);
    private static final Double DOUBLE_ZERO = 0.0;
    private static final Double DOUBLE_ONE = 1.0;

    private Converter() {
    }

    public static Object convert(Object fromInstance, Class toType) {
        if (toType == null) {
            throw new IllegalArgumentException("Type cannot be null in Converter.convert(value, type)");
        }
        if (toType == String.class) {
            if (fromInstance == null || fromInstance instanceof String) {
                return fromInstance;
            }
            if (fromInstance instanceof BigDecimal) {
                return ((BigDecimal)fromInstance).stripTrailingZeros().toPlainString();
            }
            if (fromInstance instanceof Number || fromInstance instanceof Boolean || fromInstance instanceof AtomicBoolean) {
                return fromInstance.toString();
            }
            if (fromInstance instanceof java.util.Date) {
                return SafeSimpleDateFormat.getDateFormat("yyyy-MM-dd'T'HH:mm:ss").format(fromInstance);
            }
            if (fromInstance instanceof Calendar) {
                return SafeSimpleDateFormat.getDateFormat("yyyy-MM-dd'T'HH:mm:ss").format(((Calendar)fromInstance).getTime());
            }
            if (fromInstance instanceof Character) {
                return "" + fromInstance;
            }
            if (fromInstance instanceof Enum) {
                return ((Enum)fromInstance).name();
            }
            Converter.nope(fromInstance, "String");
        } else {
            if (toType == Long.TYPE) {
                return fromInstance == null ? Long.valueOf(0L) : Converter.convertLong(fromInstance);
            }
            if (toType == Long.class) {
                return fromInstance == null ? null : Converter.convertLong(fromInstance);
            }
            if (toType == Integer.TYPE) {
                return fromInstance == null ? Integer.valueOf(0) : Converter.convertInteger(fromInstance);
            }
            if (toType == Integer.class) {
                return fromInstance == null ? null : Converter.convertInteger(fromInstance);
            }
            if (toType == java.util.Date.class) {
                if (fromInstance == null) {
                    return null;
                }
                try {
                    if (fromInstance instanceof String) {
                        return DateUtilities.parseDate(((String)fromInstance).trim());
                    }
                    if (fromInstance instanceof Date) {
                        return new java.util.Date(((Date)fromInstance).getTime());
                    }
                    if (fromInstance instanceof Timestamp) {
                        Timestamp timestamp = (Timestamp)fromInstance;
                        return new java.util.Date(timestamp.getTime());
                    }
                    if (fromInstance instanceof java.util.Date) {
                        return new java.util.Date(((java.util.Date)fromInstance).getTime());
                    }
                    if (fromInstance instanceof Calendar) {
                        return ((Calendar)fromInstance).getTime();
                    }
                    if (fromInstance instanceof Long) {
                        return new java.util.Date((Long)fromInstance);
                    }
                    if (fromInstance instanceof AtomicLong) {
                        return new java.util.Date(((AtomicLong)fromInstance).get());
                    }
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("value [" + Converter.name(fromInstance) + "] could not be converted to a 'Date'", e);
                }
                Converter.nope(fromInstance, "Date");
            } else if (toType == BigDecimal.class) {
                if (fromInstance == null) {
                    return null;
                }
                try {
                    if (fromInstance instanceof String) {
                        if (StringUtilities.isEmpty((String)fromInstance)) {
                            return BigDecimal.ZERO;
                        }
                        return new BigDecimal(((String)fromInstance).trim());
                    }
                    if (fromInstance instanceof BigDecimal) {
                        return fromInstance;
                    }
                    if (fromInstance instanceof BigInteger) {
                        return new BigDecimal((BigInteger)fromInstance);
                    }
                    if (fromInstance instanceof Number) {
                        return new BigDecimal(((Number)fromInstance).doubleValue());
                    }
                    if (fromInstance instanceof Boolean) {
                        return (Boolean)fromInstance != false ? BigDecimal.ONE : BigDecimal.ZERO;
                    }
                    if (fromInstance instanceof AtomicBoolean) {
                        return ((AtomicBoolean)fromInstance).get() ? BigDecimal.ONE : BigDecimal.ZERO;
                    }
                    if (fromInstance instanceof java.util.Date) {
                        return new BigDecimal(((java.util.Date)fromInstance).getTime());
                    }
                    if (fromInstance instanceof Calendar) {
                        return new BigDecimal(((Calendar)fromInstance).getTime().getTime());
                    }
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("value [" + Converter.name(fromInstance) + "] could not be converted to a 'BigDecimal'", e);
                }
                Converter.nope(fromInstance, "BigDecimal");
            } else if (toType == BigInteger.class) {
                if (fromInstance == null) {
                    return null;
                }
                try {
                    if (fromInstance instanceof String) {
                        if (StringUtilities.isEmpty((String)fromInstance)) {
                            return BigInteger.ZERO;
                        }
                        return new BigInteger(((String)fromInstance).trim());
                    }
                    if (fromInstance instanceof BigInteger) {
                        return fromInstance;
                    }
                    if (fromInstance instanceof BigDecimal) {
                        return ((BigDecimal)fromInstance).toBigInteger();
                    }
                    if (fromInstance instanceof Number) {
                        return new BigInteger(Long.toString(((Number)fromInstance).longValue()));
                    }
                    if (fromInstance instanceof Boolean) {
                        return (Boolean)fromInstance != false ? BigInteger.ONE : BigInteger.ZERO;
                    }
                    if (fromInstance instanceof AtomicBoolean) {
                        return ((AtomicBoolean)fromInstance).get() ? BigInteger.ONE : BigInteger.ZERO;
                    }
                    if (fromInstance instanceof java.util.Date) {
                        return new BigInteger(Long.toString(((java.util.Date)fromInstance).getTime()));
                    }
                    if (fromInstance instanceof Calendar) {
                        return new BigInteger(Long.toString(((Calendar)fromInstance).getTime().getTime()));
                    }
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("value [" + Converter.name(fromInstance) + "] could not be converted to a 'BigInteger'", e);
                }
                Converter.nope(fromInstance, "BigInteger");
            } else if (toType == Date.class) {
                if (fromInstance == null) {
                    return null;
                }
                try {
                    if (fromInstance instanceof Date) {
                        return new Date(((Date)fromInstance).getTime());
                    }
                    if (fromInstance instanceof Timestamp) {
                        Timestamp timestamp = (Timestamp)fromInstance;
                        return new Date(timestamp.getTime());
                    }
                    if (fromInstance instanceof java.util.Date) {
                        return new Date(((java.util.Date)fromInstance).getTime());
                    }
                    if (fromInstance instanceof String) {
                        java.util.Date date = DateUtilities.parseDate(((String)fromInstance).trim());
                        return new Date(date.getTime());
                    }
                    if (fromInstance instanceof Calendar) {
                        return new Date(((Calendar)fromInstance).getTime().getTime());
                    }
                    if (fromInstance instanceof Long) {
                        return new Date((Long)fromInstance);
                    }
                    if (fromInstance instanceof AtomicLong) {
                        return new Date(((AtomicLong)fromInstance).get());
                    }
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("value [" + Converter.name(fromInstance) + "] could not be converted to a 'java.sql.Date'", e);
                }
                Converter.nope(fromInstance, "java.sql.Date");
            } else if (toType == Timestamp.class) {
                if (fromInstance == null) {
                    return null;
                }
                try {
                    if (fromInstance instanceof Date) {
                        return new Timestamp(((Date)fromInstance).getTime());
                    }
                    if (fromInstance instanceof Timestamp) {
                        return new Timestamp(((Timestamp)fromInstance).getTime());
                    }
                    if (fromInstance instanceof java.util.Date) {
                        return new Timestamp(((java.util.Date)fromInstance).getTime());
                    }
                    if (fromInstance instanceof String) {
                        java.util.Date date = DateUtilities.parseDate(((String)fromInstance).trim());
                        return new Timestamp(date.getTime());
                    }
                    if (fromInstance instanceof Calendar) {
                        return new Timestamp(((Calendar)fromInstance).getTime().getTime());
                    }
                    if (fromInstance instanceof Long) {
                        return new Timestamp((Long)fromInstance);
                    }
                    if (fromInstance instanceof AtomicLong) {
                        return new Timestamp(((AtomicLong)fromInstance).get());
                    }
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("value [" + Converter.name(fromInstance) + "] could not be converted to a 'Timestamp'", e);
                }
                Converter.nope(fromInstance, "Timestamp");
            } else if (toType == AtomicInteger.class) {
                if (fromInstance == null) {
                    return null;
                }
                try {
                    if (fromInstance instanceof AtomicInteger) {
                        return new AtomicInteger(((AtomicInteger)fromInstance).get());
                    }
                    if (fromInstance instanceof String) {
                        if (StringUtilities.isEmpty((String)fromInstance)) {
                            return new AtomicInteger(0);
                        }
                        return new AtomicInteger(Integer.valueOf(((String)fromInstance).trim()));
                    }
                    if (fromInstance instanceof Number) {
                        return new AtomicInteger(((Number)fromInstance).intValue());
                    }
                    if (fromInstance instanceof Boolean) {
                        return (Boolean)fromInstance != false ? new AtomicInteger(1) : new AtomicInteger(0);
                    }
                    if (fromInstance instanceof AtomicBoolean) {
                        return ((AtomicBoolean)fromInstance).get() ? new AtomicInteger(1) : new AtomicInteger(0);
                    }
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("value [" + Converter.name(fromInstance) + "] could not be converted to an 'AtomicInteger'", e);
                }
                Converter.nope(fromInstance, "AtomicInteger");
            } else if (toType == AtomicLong.class) {
                if (fromInstance == null) {
                    return null;
                }
                try {
                    if (fromInstance instanceof String) {
                        if (StringUtilities.isEmpty((String)fromInstance)) {
                            return new AtomicLong(0L);
                        }
                        return new AtomicLong(Long.valueOf(((String)fromInstance).trim()));
                    }
                    if (fromInstance instanceof AtomicLong) {
                        return new AtomicLong(((AtomicLong)fromInstance).get());
                    }
                    if (fromInstance instanceof Number) {
                        return new AtomicLong(((Number)fromInstance).longValue());
                    }
                    if (fromInstance instanceof java.util.Date) {
                        return new AtomicLong(((java.util.Date)fromInstance).getTime());
                    }
                    if (fromInstance instanceof Boolean) {
                        return (Boolean)fromInstance != false ? new AtomicLong(1L) : new AtomicLong(0L);
                    }
                    if (fromInstance instanceof AtomicBoolean) {
                        return ((AtomicBoolean)fromInstance).get() ? new AtomicLong(1L) : new AtomicLong(0L);
                    }
                    if (fromInstance instanceof Calendar) {
                        return new AtomicLong(((Calendar)fromInstance).getTime().getTime());
                    }
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("value [" + Converter.name(fromInstance) + "] could not be converted to an 'AtomicLong'", e);
                }
                Converter.nope(fromInstance, "AtomicLong");
            } else if (toType == AtomicBoolean.class) {
                if (fromInstance == null) {
                    return null;
                }
                if (fromInstance instanceof String) {
                    if (StringUtilities.isEmpty((String)fromInstance)) {
                        return new AtomicBoolean(false);
                    }
                    String value = (String)fromInstance;
                    return new AtomicBoolean("true".equalsIgnoreCase(value));
                }
                if (fromInstance instanceof AtomicBoolean) {
                    return new AtomicBoolean(((AtomicBoolean)fromInstance).get());
                }
                if (fromInstance instanceof Boolean) {
                    return new AtomicBoolean((Boolean)fromInstance);
                }
                if (fromInstance instanceof Number) {
                    return new AtomicBoolean(((Number)fromInstance).longValue() != 0L);
                }
                Converter.nope(fromInstance, "AtomicBoolean");
            } else {
                if (toType == Boolean.TYPE) {
                    return fromInstance == null ? Boolean.FALSE : Converter.convertBoolean(fromInstance);
                }
                if (toType == Boolean.class) {
                    return fromInstance == null ? null : Converter.convertBoolean(fromInstance);
                }
                if (toType == Double.TYPE) {
                    return fromInstance == null ? DOUBLE_ZERO : Converter.convertDouble(fromInstance);
                }
                if (toType == Double.class) {
                    return fromInstance == null ? null : Converter.convertDouble(fromInstance);
                }
                if (toType == Byte.TYPE) {
                    return fromInstance == null ? BYTE_ZERO : Converter.convertByte(fromInstance);
                }
                if (toType == Byte.class) {
                    return fromInstance == null ? null : Converter.convertByte(fromInstance);
                }
                if (toType == Float.TYPE) {
                    return fromInstance == null ? FLOAT_ZERO : Converter.convertFloat(fromInstance);
                }
                if (toType == Float.class) {
                    return fromInstance == null ? null : Converter.convertFloat(fromInstance);
                }
                if (toType == Short.TYPE) {
                    return fromInstance == null ? SHORT_ZERO : Converter.convertShort(fromInstance);
                }
                if (toType == Short.class) {
                    return fromInstance == null ? null : Converter.convertShort(fromInstance);
                }
            }
        }
        throw new IllegalArgumentException("Unsupported type '" + toType.getName() + "' for conversion");
    }

    private static Object convertByte(Object fromInstance) {
        try {
            if (fromInstance instanceof String) {
                if (StringUtilities.isEmpty((String)fromInstance)) {
                    return BYTE_ZERO;
                }
                return Byte.valueOf(((String)fromInstance).trim());
            }
            if (fromInstance instanceof Byte) {
                return fromInstance;
            }
            if (fromInstance instanceof Number) {
                return ((Number)fromInstance).byteValue();
            }
            if (fromInstance instanceof Boolean) {
                return (Boolean)fromInstance != false ? BYTE_ONE : BYTE_ZERO;
            }
            if (fromInstance instanceof AtomicBoolean) {
                return ((AtomicBoolean)fromInstance).get() ? BYTE_ONE : BYTE_ZERO;
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("value [" + Converter.name(fromInstance) + "] could not be converted to a 'Byte'", e);
        }
        return Converter.nope(fromInstance, "Byte");
    }

    private static Object convertShort(Object fromInstance) {
        try {
            if (fromInstance instanceof String) {
                if (StringUtilities.isEmpty((String)fromInstance)) {
                    return SHORT_ZERO;
                }
                return Short.valueOf(((String)fromInstance).trim());
            }
            if (fromInstance instanceof Short) {
                return fromInstance;
            }
            if (fromInstance instanceof Number) {
                return ((Number)fromInstance).shortValue();
            }
            if (fromInstance instanceof Boolean) {
                return (Boolean)fromInstance != false ? SHORT_ONE : SHORT_ZERO;
            }
            if (fromInstance instanceof AtomicBoolean) {
                return ((AtomicBoolean)fromInstance).get() ? SHORT_ONE : SHORT_ZERO;
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("value [" + Converter.name(fromInstance) + "] could not be converted to a 'Short'", e);
        }
        return Converter.nope(fromInstance, "Short");
    }

    private static Object convertInteger(Object fromInstance) {
        try {
            if (fromInstance instanceof Integer) {
                return fromInstance;
            }
            if (fromInstance instanceof Number) {
                return ((Number)fromInstance).intValue();
            }
            if (fromInstance instanceof String) {
                if (StringUtilities.isEmpty((String)fromInstance)) {
                    return INTEGER_ZERO;
                }
                return Integer.valueOf(((String)fromInstance).trim());
            }
            if (fromInstance instanceof Boolean) {
                return (Boolean)fromInstance != false ? INTEGER_ONE : INTEGER_ZERO;
            }
            if (fromInstance instanceof AtomicBoolean) {
                return ((AtomicBoolean)fromInstance).get() ? INTEGER_ONE : INTEGER_ZERO;
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("value [" + Converter.name(fromInstance) + "] could not be converted to an 'Integer'", e);
        }
        return Converter.nope(fromInstance, "Integer");
    }

    private static Object convertLong(Object fromInstance) {
        try {
            if (fromInstance instanceof Long) {
                return fromInstance;
            }
            if (fromInstance instanceof Number) {
                return ((Number)fromInstance).longValue();
            }
            if (fromInstance instanceof String) {
                if (StringUtilities.isEmpty((String)fromInstance)) {
                    return LONG_ZERO;
                }
                return Long.valueOf(((String)fromInstance).trim());
            }
            if (fromInstance instanceof java.util.Date) {
                return ((java.util.Date)fromInstance).getTime();
            }
            if (fromInstance instanceof Boolean) {
                return (Boolean)fromInstance != false ? LONG_ONE : LONG_ZERO;
            }
            if (fromInstance instanceof AtomicBoolean) {
                return ((AtomicBoolean)fromInstance).get() ? LONG_ONE : LONG_ZERO;
            }
            if (fromInstance instanceof Calendar) {
                return ((Calendar)fromInstance).getTime().getTime();
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("value [" + Converter.name(fromInstance) + "] could not be converted to a 'Long'", e);
        }
        return Converter.nope(fromInstance, "Long");
    }

    private static Object convertFloat(Object fromInstance) {
        try {
            if (fromInstance instanceof String) {
                if (StringUtilities.isEmpty((String)fromInstance)) {
                    return FLOAT_ZERO;
                }
                return Float.valueOf(((String)fromInstance).trim());
            }
            if (fromInstance instanceof Float) {
                return fromInstance;
            }
            if (fromInstance instanceof Number) {
                return Float.valueOf(((Number)fromInstance).floatValue());
            }
            if (fromInstance instanceof Boolean) {
                return (Boolean)fromInstance != false ? FLOAT_ONE : FLOAT_ZERO;
            }
            if (fromInstance instanceof AtomicBoolean) {
                return ((AtomicBoolean)fromInstance).get() ? FLOAT_ONE : FLOAT_ZERO;
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("value [" + Converter.name(fromInstance) + "] could not be converted to a 'Float'", e);
        }
        return Converter.nope(fromInstance, "Float");
    }

    private static Object convertDouble(Object fromInstance) {
        try {
            if (fromInstance instanceof String) {
                if (StringUtilities.isEmpty((String)fromInstance)) {
                    return DOUBLE_ZERO;
                }
                return Double.valueOf(((String)fromInstance).trim());
            }
            if (fromInstance instanceof Double) {
                return fromInstance;
            }
            if (fromInstance instanceof Number) {
                return ((Number)fromInstance).doubleValue();
            }
            if (fromInstance instanceof Boolean) {
                return (Boolean)fromInstance != false ? DOUBLE_ONE : DOUBLE_ZERO;
            }
            if (fromInstance instanceof AtomicBoolean) {
                return ((AtomicBoolean)fromInstance).get() ? DOUBLE_ONE : DOUBLE_ZERO;
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("value [" + Converter.name(fromInstance) + "] could not be converted to a 'Double'", e);
        }
        return Converter.nope(fromInstance, "Double");
    }

    private static Object convertBoolean(Object fromInstance) {
        if (fromInstance instanceof Boolean) {
            return fromInstance;
        }
        if (fromInstance instanceof Number) {
            return ((Number)fromInstance).longValue() != 0L;
        }
        if (fromInstance instanceof String) {
            if (StringUtilities.isEmpty((String)fromInstance)) {
                return Boolean.FALSE;
            }
            String value = (String)fromInstance;
            return "true".equalsIgnoreCase(value) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (fromInstance instanceof AtomicBoolean) {
            return ((AtomicBoolean)fromInstance).get();
        }
        return Converter.nope(fromInstance, "Boolean");
    }

    private static String nope(Object fromInstance, String targetType) {
        throw new IllegalArgumentException("Unsupported value type [" + Converter.name(fromInstance) + "] attempting to convert to '" + targetType + "'");
    }

    private static String name(Object fromInstance) {
        return fromInstance.getClass().getName() + " (" + fromInstance.toString() + ")";
    }
}

