/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import com.cedarsoftware.util.DateUtilities;
import com.cedarsoftware.util.SafeSimpleDateFormat;
import com.cedarsoftware.util.StringUtilities;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public final class Converter {
    public static Object convert(Object fromInstance, Class toType) {
        if (toType == null) {
            throw new IllegalArgumentException("Type cannot be null in Converter.convert(value, type)");
        }
        switch (toType.getName()) {
            case "byte": {
                if (fromInstance == null) {
                    return (byte)0;
                }
            }
            case "java.lang.Byte": {
                try {
                    if (fromInstance == null) {
                        return null;
                    }
                    if (fromInstance instanceof Byte) {
                        return fromInstance;
                    }
                    if (fromInstance instanceof Number) {
                        return ((Number)fromInstance).byteValue();
                    }
                    if (fromInstance instanceof String) {
                        if (StringUtilities.isEmpty((String)fromInstance)) {
                            return (byte)0;
                        }
                        return Byte.valueOf(((String)fromInstance).trim());
                    }
                    if (fromInstance instanceof Boolean) {
                        return (Boolean)fromInstance != false ? (byte)1 : 0;
                    }
                    if (fromInstance instanceof AtomicBoolean) {
                        return ((AtomicBoolean)fromInstance).get() ? (byte)1 : 0;
                    }
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("value [" + Converter.name(fromInstance) + "] could not be converted to a 'Byte'", e);
                }
                Converter.nope(fromInstance, "Byte");
            }
            case "short": {
                if (fromInstance == null) {
                    return (short)0;
                }
            }
            case "java.lang.Short": {
                try {
                    if (fromInstance == null) {
                        return null;
                    }
                    if (fromInstance instanceof Short) {
                        return fromInstance;
                    }
                    if (fromInstance instanceof Number) {
                        return ((Number)fromInstance).shortValue();
                    }
                    if (fromInstance instanceof String) {
                        if (StringUtilities.isEmpty((String)fromInstance)) {
                            return (short)0;
                        }
                        return Short.valueOf(((String)fromInstance).trim());
                    }
                    if (fromInstance instanceof Boolean) {
                        return (Boolean)fromInstance != false ? (short)1 : 0;
                    }
                    if (fromInstance instanceof AtomicBoolean) {
                        return ((AtomicBoolean)fromInstance).get() ? (short)1 : 0;
                    }
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("value [" + Converter.name(fromInstance) + "] could not be converted to a 'Short'", e);
                }
                Converter.nope(fromInstance, "Short");
            }
            case "int": {
                if (fromInstance == null) {
                    return 0;
                }
            }
            case "java.lang.Integer": {
                try {
                    if (fromInstance == null) {
                        return null;
                    }
                    if (fromInstance instanceof Integer) {
                        return fromInstance;
                    }
                    if (fromInstance instanceof Number) {
                        return ((Number)fromInstance).intValue();
                    }
                    if (fromInstance instanceof String) {
                        if (StringUtilities.isEmpty((String)fromInstance)) {
                            return 0;
                        }
                        return Integer.valueOf(((String)fromInstance).trim());
                    }
                    if (fromInstance instanceof Boolean) {
                        return (Boolean)fromInstance != false ? 1 : 0;
                    }
                    if (fromInstance instanceof AtomicBoolean) {
                        return ((AtomicBoolean)fromInstance).get() ? 1 : 0;
                    }
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("value [" + Converter.name(fromInstance) + "] could not be converted to an 'Integer'", e);
                }
                Converter.nope(fromInstance, "Integer");
            }
            case "long": {
                if (fromInstance == null) {
                    return 0L;
                }
            }
            case "java.lang.Long": {
                try {
                    if (fromInstance == null) {
                        return null;
                    }
                    if (fromInstance instanceof Long) {
                        return fromInstance;
                    }
                    if (fromInstance instanceof Number) {
                        return ((Number)fromInstance).longValue();
                    }
                    if (fromInstance instanceof String) {
                        if (StringUtilities.isEmpty((String)fromInstance)) {
                            return 0L;
                        }
                        return Long.valueOf(((String)fromInstance).trim());
                    }
                    if (fromInstance instanceof java.util.Date) {
                        return ((java.util.Date)fromInstance).getTime();
                    }
                    if (fromInstance instanceof Boolean) {
                        return (Boolean)fromInstance != false ? 1L : 0L;
                    }
                    if (fromInstance instanceof AtomicBoolean) {
                        return ((AtomicBoolean)fromInstance).get() ? 1L : 0L;
                    }
                    if (fromInstance instanceof Calendar) {
                        return ((Calendar)fromInstance).getTime().getTime();
                    }
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("value [" + Converter.name(fromInstance) + "] could not be converted to a 'Long'", e);
                }
                Converter.nope(fromInstance, "Long");
            }
            case "java.lang.String": {
                if (fromInstance == null) {
                    return null;
                }
                if (fromInstance instanceof String) {
                    return fromInstance;
                }
                if (fromInstance instanceof BigDecimal) {
                    return ((BigDecimal)fromInstance).stripTrailingZeros().toPlainString();
                }
                if (fromInstance instanceof Number || fromInstance instanceof Boolean || fromInstance instanceof AtomicBoolean) {
                    return fromInstance.toString();
                }
                if (fromInstance instanceof java.util.Date) {
                    return SafeSimpleDateFormat.getDateFormat("yyyy-MM-dd'T'HH:mm:ss").format(fromInstance);
                }
                if (fromInstance instanceof Calendar) {
                    return SafeSimpleDateFormat.getDateFormat("yyyy-MM-dd'T'HH:mm:ss").format(((Calendar)fromInstance).getTime());
                }
                if (fromInstance instanceof Character) {
                    return "" + fromInstance;
                }
                Converter.nope(fromInstance, "String");
            }
            case "java.math.BigDecimal": {
                try {
                    if (fromInstance == null) {
                        return null;
                    }
                    if (fromInstance instanceof BigDecimal) {
                        return fromInstance;
                    }
                    if (fromInstance instanceof BigInteger) {
                        return new BigDecimal((BigInteger)fromInstance);
                    }
                    if (fromInstance instanceof String) {
                        if (StringUtilities.isEmpty((String)fromInstance)) {
                            return BigDecimal.ZERO;
                        }
                        return new BigDecimal(((String)fromInstance).trim());
                    }
                    if (fromInstance instanceof Number) {
                        return new BigDecimal(((Number)fromInstance).doubleValue());
                    }
                    if (fromInstance instanceof Boolean) {
                        return (Boolean)fromInstance != false ? BigDecimal.ONE : BigDecimal.ZERO;
                    }
                    if (fromInstance instanceof AtomicBoolean) {
                        return ((AtomicBoolean)fromInstance).get() ? BigDecimal.ONE : BigDecimal.ZERO;
                    }
                    if (fromInstance instanceof java.util.Date) {
                        return new BigDecimal(((java.util.Date)fromInstance).getTime());
                    }
                    if (fromInstance instanceof Calendar) {
                        return new BigDecimal(((Calendar)fromInstance).getTime().getTime());
                    }
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("value [" + Converter.name(fromInstance) + "] could not be converted to a 'BigDecimal'", e);
                }
                Converter.nope(fromInstance, "BigDecimal");
            }
            case "java.math.BigInteger": {
                try {
                    if (fromInstance == null) {
                        return null;
                    }
                    if (fromInstance instanceof BigInteger) {
                        return fromInstance;
                    }
                    if (fromInstance instanceof BigDecimal) {
                        return ((BigDecimal)fromInstance).toBigInteger();
                    }
                    if (fromInstance instanceof String) {
                        if (StringUtilities.isEmpty((String)fromInstance)) {
                            return BigInteger.ZERO;
                        }
                        return new BigInteger(((String)fromInstance).trim());
                    }
                    if (fromInstance instanceof Number) {
                        return new BigInteger(Long.toString(((Number)fromInstance).longValue()));
                    }
                    if (fromInstance instanceof Boolean) {
                        return (Boolean)fromInstance != false ? BigInteger.ONE : BigInteger.ZERO;
                    }
                    if (fromInstance instanceof AtomicBoolean) {
                        return ((AtomicBoolean)fromInstance).get() ? BigInteger.ONE : BigInteger.ZERO;
                    }
                    if (fromInstance instanceof java.util.Date) {
                        return new BigInteger(Long.toString(((java.util.Date)fromInstance).getTime()));
                    }
                    if (fromInstance instanceof Calendar) {
                        return new BigInteger(Long.toString(((Calendar)fromInstance).getTime().getTime()));
                    }
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("value [" + Converter.name(fromInstance) + "] could not be converted to a 'BigInteger'", e);
                }
                Converter.nope(fromInstance, "BigInteger");
            }
            case "java.util.Date": {
                try {
                    if (fromInstance == null) {
                        return null;
                    }
                    if (fromInstance instanceof Date) {
                        return new java.util.Date(((Date)fromInstance).getTime());
                    }
                    if (fromInstance instanceof Timestamp) {
                        Timestamp timestamp = (Timestamp)fromInstance;
                        return new java.util.Date(timestamp.getTime());
                    }
                    if (fromInstance instanceof java.util.Date) {
                        return fromInstance;
                    }
                    if (fromInstance instanceof String) {
                        return DateUtilities.parseDate(((String)fromInstance).trim());
                    }
                    if (fromInstance instanceof Calendar) {
                        return ((Calendar)fromInstance).getTime();
                    }
                    if (fromInstance instanceof Long) {
                        return new java.util.Date((Long)fromInstance);
                    }
                    if (fromInstance instanceof AtomicLong) {
                        return new java.util.Date(((AtomicLong)fromInstance).get());
                    }
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("value [" + Converter.name(fromInstance) + "] could not be converted to a 'Date'", e);
                }
                Converter.nope(fromInstance, "Date");
            }
            case "java.sql.Date": {
                try {
                    if (fromInstance == null) {
                        return null;
                    }
                    if (fromInstance instanceof Date) {
                        return fromInstance;
                    }
                    if (fromInstance instanceof Timestamp) {
                        Timestamp timestamp = (Timestamp)fromInstance;
                        return new Date(timestamp.getTime());
                    }
                    if (fromInstance instanceof java.util.Date) {
                        return new Date(((java.util.Date)fromInstance).getTime());
                    }
                    if (fromInstance instanceof String) {
                        java.util.Date date = DateUtilities.parseDate(((String)fromInstance).trim());
                        return new Date(date.getTime());
                    }
                    if (fromInstance instanceof Calendar) {
                        return new Date(((Calendar)fromInstance).getTime().getTime());
                    }
                    if (fromInstance instanceof Long) {
                        return new Date((Long)fromInstance);
                    }
                    if (fromInstance instanceof AtomicLong) {
                        return new Date(((AtomicLong)fromInstance).get());
                    }
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("value [" + Converter.name(fromInstance) + "] could not be converted to a 'java.sql.Date'", e);
                }
                Converter.nope(fromInstance, "java.sql.Date");
            }
            case "java.sql.Timestamp": {
                try {
                    if (fromInstance == null) {
                        return null;
                    }
                    if (fromInstance instanceof Date) {
                        return new Timestamp(((Date)fromInstance).getTime());
                    }
                    if (fromInstance instanceof Timestamp) {
                        return fromInstance;
                    }
                    if (fromInstance instanceof java.util.Date) {
                        return new Timestamp(((java.util.Date)fromInstance).getTime());
                    }
                    if (fromInstance instanceof String) {
                        java.util.Date date = DateUtilities.parseDate(((String)fromInstance).trim());
                        return new Timestamp(date.getTime());
                    }
                    if (fromInstance instanceof Calendar) {
                        return new Timestamp(((Calendar)fromInstance).getTime().getTime());
                    }
                    if (fromInstance instanceof Long) {
                        return new Timestamp((Long)fromInstance);
                    }
                    if (fromInstance instanceof AtomicLong) {
                        return new Timestamp(((AtomicLong)fromInstance).get());
                    }
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("value [" + Converter.name(fromInstance) + "] could not be converted to a 'Timestamp'", e);
                }
                Converter.nope(fromInstance, "Timestamp");
            }
            case "float": {
                if (fromInstance == null) {
                    return Float.valueOf(0.0f);
                }
            }
            case "java.lang.Float": {
                try {
                    if (fromInstance == null) {
                        return null;
                    }
                    if (fromInstance instanceof Float) {
                        return fromInstance;
                    }
                    if (fromInstance instanceof Number) {
                        return Float.valueOf(((Number)fromInstance).floatValue());
                    }
                    if (fromInstance instanceof String) {
                        if (StringUtilities.isEmpty((String)fromInstance)) {
                            return Float.valueOf(0.0f);
                        }
                        return Float.valueOf(((String)fromInstance).trim());
                    }
                    if (fromInstance instanceof Boolean) {
                        return Float.valueOf((Boolean)fromInstance != false ? 1.0f : 0.0f);
                    }
                    if (fromInstance instanceof AtomicBoolean) {
                        return Float.valueOf(((AtomicBoolean)fromInstance).get() ? 1.0f : 0.0f);
                    }
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("value [" + Converter.name(fromInstance) + "] could not be converted to a 'Float'", e);
                }
                Converter.nope(fromInstance, "Float");
            }
            case "double": {
                if (fromInstance == null) {
                    return 0.0;
                }
            }
            case "java.lang.Double": {
                try {
                    if (fromInstance == null) {
                        return null;
                    }
                    if (fromInstance instanceof Double) {
                        return fromInstance;
                    }
                    if (fromInstance instanceof Number) {
                        return ((Number)fromInstance).doubleValue();
                    }
                    if (fromInstance instanceof String) {
                        if (StringUtilities.isEmpty((String)fromInstance)) {
                            return 0.0;
                        }
                        return Double.valueOf(((String)fromInstance).trim());
                    }
                    if (fromInstance instanceof Boolean) {
                        return (Boolean)fromInstance != false ? 1.0 : 0.0;
                    }
                    if (fromInstance instanceof AtomicBoolean) {
                        return ((AtomicBoolean)fromInstance).get() ? 1.0 : 0.0;
                    }
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("value [" + Converter.name(fromInstance) + "] could not be converted to a 'Double'", e);
                }
                Converter.nope(fromInstance, "Double");
            }
            case "java.util.concurrent.atomic.AtomicInteger": {
                try {
                    if (fromInstance == null) {
                        return null;
                    }
                    if (fromInstance instanceof AtomicInteger) {
                        return fromInstance;
                    }
                    if (fromInstance instanceof String) {
                        if (StringUtilities.isEmpty((String)fromInstance)) {
                            return new AtomicInteger(0);
                        }
                        return new AtomicInteger(Integer.valueOf(((String)fromInstance).trim()));
                    }
                    if (fromInstance instanceof Number) {
                        return new AtomicInteger(((Number)fromInstance).intValue());
                    }
                    if (fromInstance instanceof Boolean) {
                        return (Boolean)fromInstance != false ? new AtomicInteger(1) : new AtomicInteger(0);
                    }
                    if (fromInstance instanceof AtomicBoolean) {
                        return ((AtomicBoolean)fromInstance).get() ? new AtomicInteger(1) : new AtomicInteger(0);
                    }
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("value [" + Converter.name(fromInstance) + "] could not be converted to an 'AtomicInteger'", e);
                }
                Converter.nope(fromInstance, "AtomicInteger");
            }
            case "java.util.concurrent.atomic.AtomicLong": {
                try {
                    if (fromInstance == null) {
                        return null;
                    }
                    if (fromInstance instanceof AtomicLong) {
                        return fromInstance;
                    }
                    if (fromInstance instanceof Number) {
                        return new AtomicLong(((Number)fromInstance).longValue());
                    }
                    if (fromInstance instanceof String) {
                        if (StringUtilities.isEmpty((String)fromInstance)) {
                            return new AtomicLong(0L);
                        }
                        return new AtomicLong(Long.valueOf(((String)fromInstance).trim()));
                    }
                    if (fromInstance instanceof java.util.Date) {
                        return new AtomicLong(((java.util.Date)fromInstance).getTime());
                    }
                    if (fromInstance instanceof Boolean) {
                        return (Boolean)fromInstance != false ? new AtomicLong(1L) : new AtomicLong(0L);
                    }
                    if (fromInstance instanceof AtomicBoolean) {
                        return ((AtomicBoolean)fromInstance).get() ? new AtomicLong(1L) : new AtomicLong(0L);
                    }
                    if (fromInstance instanceof Calendar) {
                        return new AtomicLong(((Calendar)fromInstance).getTime().getTime());
                    }
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("value [" + Converter.name(fromInstance) + "] could not be converted to an 'AtomicLong'", e);
                }
                Converter.nope(fromInstance, "AtomicLong");
            }
            case "boolean": {
                if (fromInstance == null) {
                    return Boolean.FALSE;
                }
            }
            case "java.lang.Boolean": {
                if (fromInstance == null) {
                    return null;
                }
                if (fromInstance instanceof Boolean) {
                    return fromInstance;
                }
                if (fromInstance instanceof Number) {
                    return ((Number)fromInstance).longValue() != 0L;
                }
                if (fromInstance instanceof String) {
                    if (StringUtilities.isEmpty((String)fromInstance)) {
                        return Boolean.FALSE;
                    }
                    String value = (String)fromInstance;
                    return "true".equalsIgnoreCase(value) ? Boolean.TRUE : Boolean.FALSE;
                }
                if (fromInstance instanceof AtomicBoolean) {
                    return ((AtomicBoolean)fromInstance).get();
                }
                Converter.nope(fromInstance, "Boolean");
            }
            case "java.util.concurrent.atomic.AtomicBoolean": {
                if (fromInstance == null) {
                    return null;
                }
                if (fromInstance instanceof AtomicBoolean) {
                    return fromInstance;
                }
                if (fromInstance instanceof String) {
                    if (StringUtilities.isEmpty((String)fromInstance)) {
                        return new AtomicBoolean(false);
                    }
                    String value = (String)fromInstance;
                    return new AtomicBoolean("true".equalsIgnoreCase(value));
                }
                if (fromInstance instanceof Number) {
                    return new AtomicBoolean(((Number)fromInstance).longValue() != 0L);
                }
                if (fromInstance instanceof Boolean) {
                    return new AtomicBoolean((Boolean)fromInstance);
                }
                Converter.nope(fromInstance, "AtomicBoolean");
            }
        }
        throw new IllegalArgumentException("Unsupported type '" + toType.getName() + "' for conversion");
    }

    private static String nope(Object fromInstance, String targetType) {
        throw new IllegalArgumentException("Unsupported value type [" + Converter.name(fromInstance) + "] attempting to convert to '" + targetType + "'");
    }

    private static String name(Object fromInstance) {
        return fromInstance.getClass().getName() + " (" + fromInstance.toString() + ")";
    }
}

