/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoft.xml;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.annotation.Nonnull;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class XmlCommons {
    private XmlCommons() {
    }

    @Nonnull
    public static String format(@Nonnull String xml) {
        if (xml.trim().isEmpty()) {
            return "";
        }
        try {
            StreamSource xmlInput = new StreamSource(new StringReader(xml));
            StringWriter stringWriter = new StringWriter();
            XmlCommons.createTransformer().transform(xmlInput, new StreamResult(stringWriter));
            return stringWriter.toString();
        }
        catch (TransformerConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (TransformerException e) {
            throw new RuntimeException(e);
        }
    }

    @Nonnull
    public static DocumentBuilder getDocumentBuilder() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            return factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public static void out(@Nonnull Document document, @Nonnull OutputStream out) {
        try {
            XmlCommons.createTransformer().transform(new DOMSource(document), new StreamResult(out));
        }
        catch (TransformerException e) {
            throw new RuntimeException(e);
        }
    }

    public static void out(@Nonnull Document document, @Nonnull Writer out) {
        try {
            XmlCommons.createTransformer().transform(new DOMSource(document), new StreamResult(out));
        }
        catch (TransformerException e) {
            throw new RuntimeException(e);
        }
    }

    @Nonnull
    public static Transformer createTransformer() throws TransformerConfigurationException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            transformerFactory.setAttribute("indent-number", 2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        try {
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return transformer;
    }

    @Nonnull
    public static Document parse(@Nonnull byte[] bytes) throws IOException, SAXException {
        return XmlCommons.parse(new ByteArrayInputStream(bytes));
    }

    @Nonnull
    public static Document parse(@Nonnull InputStream in) throws IOException, SAXException {
        return XmlCommons.getDocumentBuilder().parse(in);
    }

    @Nonnull
    public static String toString(@Nonnull Document document) {
        StringWriter stringWriter = new StringWriter();
        XmlCommons.out(document, stringWriter);
        return stringWriter.toString();
    }
}

