/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoft;

import com.cedarsoft.VersionMismatchException;
import java.io.Serializable;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Version
implements Comparable<Version>,
Serializable {
    protected static final int MAX = 99;
    protected final int major;
    protected final int minor;
    protected final int build;
    @Nullable
    @NonNls
    protected final String suffix;

    public Version(int major, int minor, int build) {
        this(major, minor, build, null);
    }

    public Version(int major, int minor, int build, @Nullable String suffix) {
        this.major = major;
        this.build = build;
        this.minor = minor;
        this.suffix = suffix;
        if (major > 99 || major < 0) {
            throw new IllegalArgumentException("Invalid major <" + major + ">");
        }
        if (minor > 99 || minor < 0) {
            throw new IllegalArgumentException("Invalid minor <" + minor + ">");
        }
        if (build > 99 || build < 0) {
            throw new IllegalArgumentException("Invalid build <" + build + ">");
        }
    }

    @Nullable
    @NonNls
    public String getSuffix() {
        return this.suffix;
    }

    public int getBuild() {
        return this.build;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    @NotNull
    @NonNls
    public String format() {
        return this.toString();
    }

    public String toString() {
        if (this.suffix != null && this.suffix.length() > 0) {
            return this.major + "." + this.minor + '.' + this.build + '-' + this.suffix;
        }
        return this.major + "." + this.minor + '.' + this.build;
    }

    @Override
    public int compareTo(Version o) {
        if (this.major != o.major) {
            return Integer.valueOf(this.major).compareTo(o.major);
        }
        if (this.minor != o.minor) {
            return Integer.valueOf(this.minor).compareTo(o.minor);
        }
        return Integer.valueOf(this.build).compareTo(o.build);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Version)) {
            return false;
        }
        if (!this.getClass().equals(o.getClass())) {
            return false;
        }
        Version version = (Version)o;
        if (this.build != version.build) {
            return false;
        }
        if (this.major != version.major) {
            return false;
        }
        if (this.minor != version.minor) {
            return false;
        }
        return !(this.suffix != null ? !this.suffix.equals(version.suffix) : version.suffix != null);
    }

    public int hashCode() {
        int result = this.major;
        result = 31 * result + this.minor;
        result = 31 * result + this.build;
        result = 31 * result + (this.suffix != null ? this.suffix.hashCode() : 0);
        return result;
    }

    public int toInt() {
        return this.major * 10000 + this.minor * 100 + this.build;
    }

    @NotNull
    public static Version parse(@NotNull @NonNls String version) throws IllegalArgumentException {
        String suffix;
        int build;
        String[] parts = version.split("\\.");
        if (parts.length != 3) {
            throw new IllegalArgumentException("Version <" + version + "> must contain exactly three parts delimited with '.'");
        }
        if (parts[2].contains("-")) {
            int firstIndex = parts[2].indexOf(45);
            String buildAsString = parts[2].substring(0, firstIndex);
            build = Integer.parseInt(buildAsString);
            suffix = parts[2].substring(firstIndex + 1, parts[2].length());
        } else {
            build = Integer.parseInt(parts[2]);
            suffix = null;
        }
        int major = Integer.parseInt(parts[0]);
        int minor = Integer.parseInt(parts[1]);
        return new Version(major, minor, build, suffix);
    }

    public static void verifyMatch(@NotNull Version expected, @NotNull Version actual) throws VersionMismatchException {
        if (!expected.equals(actual)) {
            throw new VersionMismatchException(expected, actual);
        }
    }

    public boolean sameOrSmallerThan(@NotNull Version version) {
        return this.compareTo(version) <= 0;
    }

    public boolean smallerThan(@NotNull Version version) {
        return this.compareTo(version) < 0;
    }

    public boolean sameOrGreaterThan(@NotNull Version version) {
        return this.compareTo(version) >= 0;
    }

    public boolean greaterThan(@NotNull Version version) {
        return this.compareTo(version) > 0;
    }

    @NotNull
    public static Version valueOf(int major, int minor, int build) {
        return new Version(major, minor, build);
    }
}

