/*
 * Decompiled with CFR 0.152.
 */
package com.cedarpolicy.serializer;

import com.cedarpolicy.model.exception.InvalidEUIDException;
import com.cedarpolicy.value.EntityUID;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Optional;

public class JsonEUID {
    @JsonProperty(value="type")
    public final String type;
    @JsonProperty(value="id")
    public final String id;

    public String toString() {
        try {
            ObjectMapper mapper = new ObjectMapper();
            return mapper.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Internal invariant violated, json encoding failed: " + e.toString());
        }
    }

    public JsonEUID(String type, String id) {
        this.type = type;
        this.id = id;
    }

    @SuppressFBWarnings(value={"CT_CONSTRUCTOR_THROW"})
    public JsonEUID(String src) throws InvalidEUIDException {
        Optional<EntityUID> o = EntityUID.parse(src);
        if (!o.isPresent()) {
            throw new InvalidEUIDException("Invalid EUID: `" + src + "`");
        }
        JsonEUID x = o.get().asJson();
        this.type = x.type;
        this.id = x.id;
    }

    public JsonEUID() {
        this.type = "";
        this.id = "";
    }
}

