/*
 * Decompiled with CFR 0.152.
 */
package com.cedarpolicy.model;

import com.cedarpolicy.model.policy.PolicySet;
import com.cedarpolicy.model.schema.Schema;
import com.fasterxml.jackson.annotation.JsonProperty;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Objects;

public final class ValidationRequest {
    private final Schema schema;
    private final PolicySet policies;

    @SuppressFBWarnings
    public ValidationRequest(Schema schema, PolicySet policies) {
        if (schema == null) {
            throw new NullPointerException("schema");
        }
        if (policies == null) {
            throw new NullPointerException("policies");
        }
        this.schema = schema;
        this.policies = policies;
    }

    public Schema getSchema() {
        return this.schema;
    }

    @JsonProperty(value="policies")
    public PolicySet getPolicySet() {
        return this.policies;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ValidationRequest)) {
            return false;
        }
        ValidationRequest other = (ValidationRequest)o;
        return this.schema.equals(other.schema) && this.policies.equals(other.policies);
    }

    public int hashCode() {
        return Objects.hash(this.schema, this.policies);
    }

    public String toString() {
        return "ValidationRequest(schema=" + this.schema + ", policies=" + this.policies + ")";
    }
}

