/*
 * Decompiled with CFR 0.152.
 */
package com.capgemini.mrchecker.selenium.jsoupHelper;

import com.capgemini.mrchecker.selenium.core.BasePage;
import com.capgemini.mrchecker.selenium.core.exceptions.BFElementNotFoundException;
import java.util.ArrayList;
import java.util.List;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

public class JsoupHelper {
    private JsoupHelper() {
    }

    public static List<String> findTexts(WebElement searchArea, By toSearch) {
        Document doc = JsoupHelper.initDocument(searchArea);
        return JsoupHelper.getTexts(toSearch, doc);
    }

    public static List<String> findTexts(By toSearch) {
        Document doc = JsoupHelper.initDocument();
        return JsoupHelper.getTexts(toSearch, doc);
    }

    public static List<String> findOwnTexts(WebElement searchArea, By toSearch) {
        Document doc = JsoupHelper.initDocument(searchArea);
        return JsoupHelper.getOwnTexts(toSearch, doc);
    }

    public static List<String> findOwnTexts(By toSearch) {
        Document doc = JsoupHelper.initDocument();
        return JsoupHelper.getOwnTexts(toSearch, doc);
    }

    public static List<String> findAttributes(WebElement searchArea, By toSearch, String attribute) {
        Document doc = JsoupHelper.initDocument(searchArea);
        return JsoupHelper.getAttributes(toSearch, attribute, doc);
    }

    public static boolean isContainText(WebElement searchArea, String textToFind) {
        Document doc = JsoupHelper.initDocument(searchArea);
        Element body = doc.body();
        Elements elements = body.getAllElements();
        for (Element element : elements) {
            String text = element.text();
            if (!text.contains(textToFind)) continue;
            return true;
        }
        return false;
    }

    public static List<String> findAttributes(By toSearch, String attribute) {
        Document doc = JsoupHelper.initDocument();
        return JsoupHelper.getAttributes(toSearch, attribute, doc);
    }

    public static List<String> getSelectors(By elementToReturn, String valueToCheck) {
        By elementToCheck = By.cssSelector((String)"*");
        return JsoupHelper.getSelectors(elementToReturn, elementToCheck, valueToCheck);
    }

    public static List<String> getSelectors(By elementToReturn, By elementToCheck, String valueToCheck) {
        ArrayList<String> result = new ArrayList<String>();
        Document doc = JsoupHelper.initDocument();
        String selector = JsoupHelper.createStringSelector(elementToReturn);
        Elements rowListE = doc.body().select(selector);
        for (Element row : rowListE) {
            String containsQuery;
            String selectorOfElementTocheck = JsoupHelper.createStringSelector(elementToCheck);
            String string = containsQuery = valueToCheck == null || valueToCheck.isEmpty() ? "" : ":contains(" + valueToCheck + ")";
            Elements returnCandidates = row.select(selectorOfElementTocheck + containsQuery);
            if (returnCandidates.isEmpty()) continue;
            result.add(row.cssSelector());
        }
        return result;
    }

    public static List<WebElement> findElements(By elementToReturn, By elementToCheck, String text) {
        List<String> selectors = JsoupHelper.getSelectors(elementToReturn, elementToCheck, text);
        return JsoupHelper.getElements(text, selectors);
    }

    public static List<WebElement> findElements(By elementToReturn, String text) {
        List<String> selectors = JsoupHelper.getSelectors(elementToReturn, text);
        return JsoupHelper.getElements(text, selectors);
    }

    private static List<String> getTexts(By toSearch, Document doc) {
        String selector = JsoupHelper.createStringSelector(toSearch);
        Element body = doc.body();
        Elements elements = body.select(selector);
        return JsoupHelper.getTextsFromElements(elements);
    }

    private static List<String> getTextsFromElements(Elements elements) {
        ArrayList<String> result = new ArrayList<String>();
        for (Element element : elements) {
            String text = element.text();
            result.add(text);
        }
        return result;
    }

    private static List<String> getOwnTexts(By toSearch, Document doc) {
        String selector = JsoupHelper.createStringSelector(toSearch);
        ArrayList<String> result = new ArrayList<String>();
        Element body = doc.body();
        Elements elements = body.select(selector);
        for (Element element : elements) {
            result.add(element.ownText());
        }
        return result;
    }

    private static List<WebElement> getElements(String text, List<String> selectors) {
        if (selectors.isEmpty()) {
            throw new BFElementNotFoundException("Element with text [" + text + "] not found.");
        }
        ArrayList<WebElement> elementsToReturn = new ArrayList<WebElement>();
        for (String selector : selectors) {
            By elementSelector = By.cssSelector((String)selector);
            WebElement foundElement = BasePage.getDriver().findElement(elementSelector);
            elementsToReturn.add(foundElement);
        }
        return elementsToReturn;
    }

    private static List<String> getAttributes(By toSearch, String attribute, Document doc) {
        ArrayList<String> result = new ArrayList<String>();
        String selector = JsoupHelper.createStringSelector(toSearch);
        Element body = doc.body();
        Elements rowListE = body.select(selector);
        for (Element row : rowListE) {
            String attributeResult = row.attr(attribute);
            if (!attributeResult.equals("")) {
                result.add(row.attr(attribute));
                continue;
            }
            result.add(null);
        }
        return result;
    }

    private static Document initDocument(WebElement searchArea) {
        String innerHtml = searchArea.getAttribute("innerHTML");
        if (JsoupHelper.isConversionToTableRequired(innerHtml)) {
            innerHtml = JsoupHelper.convertToTable(innerHtml);
        } else if (JsoupHelper.isConversionToListRequired(innerHtml)) {
            innerHtml = JsoupHelper.convertToList(innerHtml);
        }
        return Jsoup.parse((String)("<html><body>" + innerHtml + "</body></html>"));
    }

    private static boolean isConversionToTableRequired(String innerHtml) {
        String[] tableIdentifiers = new String[]{"<table", "<thead", "<tbody", "<tr", "<td"};
        if (innerHtml.contains(tableIdentifiers[0])) {
            return false;
        }
        for (int i = 1; i < tableIdentifiers.length; ++i) {
            if (!innerHtml.contains(tableIdentifiers[i])) continue;
            return true;
        }
        return false;
    }

    private static String convertToTable(String innerHtml) {
        return "<table>" + innerHtml + "</table>";
    }

    private static boolean isConversionToListRequired(String innerHtml) {
        if (innerHtml.contains("<ul") && innerHtml.contains("<ol")) {
            return false;
        }
        return innerHtml.contains("<li");
    }

    private static String convertToList(String innerHtml) {
        return "<ul>" + innerHtml + "</ul>";
    }

    private static Document initDocument() {
        Document doc = Jsoup.parse((String)BasePage.getDriver().getPageSource());
        return doc;
    }

    private static String createStringSelector(By from) {
        String selector = from.toString();
        int substringBegin = from.toString().indexOf(":") + 2;
        selector = selector.substring(substringBegin);
        selector = JsoupHelper.removeQuotes(selector);
        return selector;
    }

    private static String removeQuotes(String selector) {
        return selector.replaceAll("=\\s*'", "=").replaceAll("'\\s*]", "]");
    }
}

