/*
 * Decompiled with CFR 0.152.
 */
package com.capgemini.mrchecker.selenium.core.utils;

import com.capgemini.mrchecker.selenium.core.BasePage;
import com.capgemini.mrchecker.selenium.core.exceptions.BFComponentStateException;
import com.capgemini.mrchecker.selenium.core.exceptions.BFRobotInitilizationException;
import com.capgemini.mrchecker.selenium.core.exceptions.BFWaittingForBrowserWindowsException;
import com.capgemini.mrchecker.selenium.core.newDrivers.INewWebDriver;
import com.capgemini.mrchecker.selenium.core.utils.TimeUtills;
import com.capgemini.mrchecker.test.core.logger.BFLogger;
import java.awt.AWTException;
import java.awt.Robot;
import java.math.BigDecimal;
import java.time.Duration;
import java.util.Set;
import org.openqa.selenium.Alert;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.NoAlertPresentException;

public class WindowUtils {
    private WindowUtils() {
    }

    public static void switchWindow(String url, boolean switchToGivenURL) {
        for (String winHandle : BasePage.getDriver().getWindowHandles()) {
            BasePage.getDriver().switchTo().window(winHandle);
            String currentURL = BasePage.getDriver().getCurrentUrl();
            boolean isSwitchedToGivenURL = currentURL.contains(url);
            if (isSwitchedToGivenURL ^ switchToGivenURL) continue;
            return;
        }
    }

    public static void switchToWindowByTitle(String title, boolean switchToGiven) {
        for (String winHandle : BasePage.getDriver().getWindowHandles()) {
            BasePage.getDriver().switchTo().window(winHandle);
            String currentTitle = BasePage.getDriver().getTitle();
            boolean isSwitchedToGivenURL = currentTitle.contains(title);
            if (isSwitchedToGivenURL ^ switchToGiven) continue;
            BFLogger.logInfo((String)("Switching to window title:" + currentTitle));
            return;
        }
    }

    public static int getWindowsNumber() {
        return BasePage.getDriver().getWindowHandles().size();
    }

    public static boolean isWindowPresent(String url) {
        String home = BasePage.getDriver().getWindowHandle();
        boolean windowAvailable = false;
        for (String winHandle : BasePage.getDriver().getWindowHandles()) {
            BasePage.getDriver().switchTo().window(winHandle);
            String currentURL = BasePage.getDriver().getCurrentUrl();
            windowAvailable = currentURL.contains(url);
            if (!windowAvailable) continue;
            break;
        }
        BasePage.getDriver().switchTo().window(home);
        return windowAvailable;
    }

    public static boolean isWindowTitlePresent(String title) {
        String home = BasePage.getDriver().getWindowHandle();
        boolean windowAvailable = false;
        for (String winHandle : BasePage.getDriver().getWindowHandles()) {
            BasePage.getDriver().switchTo().window(winHandle);
            String currentTitle = BasePage.getDriver().getTitle();
            windowAvailable = currentTitle.contains(title);
            if (!windowAvailable) continue;
            break;
        }
        BasePage.getDriver().switchTo().window(home);
        return windowAvailable;
    }

    public static void closeAllWindowsExcept(String url) {
        String desiredWindowHandle = null;
        for (String winHandle : BasePage.getDriver().getWindowHandles()) {
            BasePage.getDriver().switchTo().window(winHandle);
            String currentURL = BasePage.getDriver().getCurrentUrl();
            if (!currentURL.equals(url)) {
                WindowUtils.closeWindow(currentURL);
                continue;
            }
            desiredWindowHandle = winHandle;
        }
        if (desiredWindowHandle == null) {
            throw new BFComponentStateException(WindowUtils.class.getSimpleName(), "closeAllWindowsExcept " + url, "window with specified url not found");
        }
        BasePage.getDriver().switchTo().window(desiredWindowHandle);
    }

    public static void closeWindow(String url) {
        if (WindowUtils.isWindowPresent(url)) {
            WindowUtils.switchWindow(url, true);
            BasePage.getDriver().close();
            WindowUtils.switchWindow(url, false);
        }
    }

    public static void resetZoom() {
        WindowUtils.sendCtrlKeyCombination(48);
    }

    public static void zoomIn() {
        WindowUtils.sendCtrlKeyCombination(107);
    }

    public static void zoomOut() {
        WindowUtils.sendCtrlKeyCombination(45);
    }

    private static void sendCtrlKeyCombination(int keyCode) {
        try {
            Robot r = new Robot();
            r.keyPress(17);
            r.keyPress(keyCode);
            r.keyRelease(17);
            r.keyRelease(keyCode);
        }
        catch (AWTException e) {
            throw new BFRobotInitilizationException(e);
        }
    }

    public static int getScreenWidth(INewWebDriver driver) {
        JavascriptExecutor jse = (JavascriptExecutor)driver;
        long wS = (Long)jse.executeScript("return document.documentElement.clientWidth;", new Object[0]);
        return new BigDecimal(wS).intValue();
    }

    public static int getScreenHeight(INewWebDriver driver) {
        JavascriptExecutor jse = (JavascriptExecutor)driver;
        long hS = (Long)jse.executeScript("return document.documentElement.clientHeight;", new Object[0]);
        return new BigDecimal(hS).intValue();
    }

    public static Set<String> waitForOpeningSecondBrowserWindow(String timeoutDescription) throws InterruptedException {
        long startTime = System.currentTimeMillis();
        Set allBrowserWindows = BasePage.getDriver().getWindowHandles();
        Duration tmp_timeout = BasePage.PROGRESS_BAR_WAIT_TIMER;
        while (allBrowserWindows.size() < 2) {
            TimeUtills.waitMiliseconds(1000);
            if (System.currentTimeMillis() - startTime > tmp_timeout.toMillis()) {
                throw new BFWaittingForBrowserWindowsException(timeoutDescription);
            }
            allBrowserWindows = BasePage.getDriver().getWindowHandles();
        }
        BFLogger.logTime((long)startTime, (String)"waitForOpeningSecondBrowserWindow");
        return allBrowserWindows;
    }

    public static boolean closeAlertIfPresent() {
        try {
            Alert alert = BasePage.getDriver().switchTo().alert();
            alert.dismiss();
            BFLogger.logDebug((String)"Alert dismissed.");
            return true;
        }
        catch (NoAlertPresentException e) {
            return false;
        }
    }
}

