/*
 * Decompiled with CFR 0.152.
 */
package com.capgemini.mrchecker.selenium.core.utils;

import com.capgemini.mrchecker.selenium.core.BasePage;
import com.capgemini.mrchecker.test.core.logger.BFLogger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

public class Utility {
    public static boolean isStringMatchingPattern(String pattern, String toCompare) {
        return Pattern.matches(pattern, toCompare);
    }

    public static boolean isStringContainingPattern(String pattern, String toCompare) {
        Pattern p = Pattern.compile(pattern);
        Matcher matcher = p.matcher(toCompare);
        return matcher.find();
    }

    public static boolean isInGivenOrder(String[] namesToCheck, String[] namesToSearchIn) {
        int[] indexAtSearchInTable = new int[namesToCheck.length];
        for (int i = 0; i < namesToCheck.length; ++i) {
            boolean found = false;
            String nameToCheck = namesToCheck[i];
            BFLogger.logDebug((String)("[isInGivenOrder()] Name to check: " + nameToCheck));
            for (int j = 0; j < namesToSearchIn.length; ++j) {
                String nameToSearch = namesToSearchIn[j];
                if (!nameToCheck.equalsIgnoreCase(nameToSearch)) continue;
                indexAtSearchInTable[i] = j;
                BFLogger.logDebug((String)("[isInGivenOrder()] Found name: " + nameToSearch));
                found = true;
                break;
            }
            if (found) continue;
            indexAtSearchInTable[i] = -1;
            BFLogger.logDebug((String)("[isInGivenOrder()] Not found name: " + nameToCheck));
        }
        int auxPrevIndex = -1;
        for (int index : indexAtSearchInTable) {
            if (index == -1) continue;
            if (index < auxPrevIndex) {
                return false;
            }
            auxPrevIndex = index;
        }
        return true;
    }

    public static String convertValueColorFromRgbToHex(String colorAsString) {
        String[] numbers = colorAsString.replace("rgba(", "").replace(")", "").split(",");
        int number1 = Integer.parseInt(numbers[0]);
        numbers[1] = numbers[1].trim();
        int number2 = Integer.parseInt(numbers[1]);
        numbers[2] = numbers[2].trim();
        int number3 = Integer.parseInt(numbers[2]);
        String colorInHex = String.format("#%02x%02x%02x", number1, number2, number3);
        return colorInHex;
    }

    public static String[] getCssClassesFromWebElement(By selector) {
        WebElement messagesPopupWindow = BasePage.getDriver().findElement(selector);
        String cssClasses = messagesPopupWindow.getAttribute("class");
        return cssClasses.split(" ");
    }

    public static enum SortOrder {
        ASCENDING(1),
        DESCENDING(-1);

        int param;

        private SortOrder(int param) {
            this.param = param;
        }
    }
}

