/*
 * Decompiled with CFR 0.152.
 */
package com.capgemini.mrchecker.selenium.core.utils;

import com.capgemini.mrchecker.selenium.core.BasePage;
import com.capgemini.mrchecker.selenium.core.exceptions.BFComponentStateException;
import com.capgemini.mrchecker.selenium.core.newDrivers.INewWebDriver;
import com.capgemini.mrchecker.test.core.exceptions.BFInputDataException;
import com.capgemini.mrchecker.test.core.logger.BFLogger;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

public class TimeUtills {
    private static final String MARKET_CLOSE = "MARKET_CLOSE";
    private static final String IS_OPEN = "IS_OPEN";
    private static String urlService = "https://www.Bank.com/service/quote/json?productid=embeddedquotes&subproductid=default&market_close=1&symbols=.DJI%2C.IXIC%2C.SPX&dojo.preventCache=1436276037737&callback=dojo.io.script.jsonp_dojoIoScript1._jsonpCallback";
    public static final int TEN_MINUTES_IN_SECONDS = 600;

    private TimeUtills() {
    }

    public static boolean isValidFormat(String format, String valueToValidate) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        try {
            sdf.parse(valueToValidate);
        }
        catch (ParseException e) {
            BFLogger.logDebug((String)("timestamp not in correct format :" + valueToValidate));
            return false;
        }
        return true;
    }

    public static void pauseOneMinute() {
        long startTime = System.currentTimeMillis();
        int pauseTimeInSec = 60;
        int periodForMessageInSec = 5;
        int loopMax = pauseTimeInSec / periodForMessageInSec;
        BFLogger.logInfo((String)"Wait One minute");
        for (int i = 0; i < loopMax; ++i) {
            try {
                Thread.sleep(periodForMessageInSec * 1000);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            BFLogger.logInfo((String)("Wait One minute. Remains : " + (pauseTimeInSec - i * periodForMessageInSec) + "s"));
        }
        BFLogger.logTime((long)startTime, (String)"pauseOneMinute");
    }

    public static void waitSeconds(int sec) {
        long startTime = System.currentTimeMillis();
        int periodForMessageInSec = 5;
        if (sec >= periodForMessageInSec) {
            int loopMax = sec / periodForMessageInSec;
            BFLogger.logInfo((String)("Wait " + sec + " sec"));
            for (int i = 0; i < loopMax; ++i) {
                BFLogger.logInfo((String)("Remains : " + (sec - i * periodForMessageInSec) + " sec"));
                TimeUtills.wait(periodForMessageInSec * 1000);
            }
        } else {
            TimeUtills.wait(sec * 1000);
        }
        BFLogger.logTime((long)startTime, (String)"waitSeconds");
    }

    public static void waitMiliseconds(int milisec) {
        long startTime = System.currentTimeMillis();
        int periodForMessageInMiliSec = 5000;
        if (milisec >= periodForMessageInMiliSec) {
            int loopMax = milisec / periodForMessageInMiliSec;
            BFLogger.logInfo((String)("Wait " + milisec + " milisec"));
            for (int i = 0; i < loopMax; ++i) {
                BFLogger.logInfo((String)("Remains : " + (milisec - i * periodForMessageInMiliSec) + " milisec"));
                TimeUtills.wait(periodForMessageInMiliSec);
            }
        } else {
            TimeUtills.wait(milisec);
        }
        BFLogger.logTime((long)startTime, (String)"waitMiliseconds");
    }

    public static boolean isNowTradingHoursinNY(INewWebDriver iNewWebDriver) {
        String orginalUrl = iNewWebDriver.getCurrentUrl();
        iNewWebDriver.get(urlService);
        String preElement = iNewWebDriver.findElementDynamic(By.cssSelector((String)"pre")).getText();
        JsonParser parser = new JsonParser();
        String jsonString = preElement.substring(preElement.indexOf("{"), preElement.length() - 1);
        JsonObject jobject = (JsonObject)parser.parse(jsonString);
        JsonObject marketClosedObject = jobject.getAsJsonObject(MARKET_CLOSE);
        String result = marketClosedObject.get(IS_OPEN).toString().replace("\"", "");
        BFLogger.logInfo((String)("isThisIsTradingHoursinNY - result: " + result));
        iNewWebDriver.get(orginalUrl);
        return !result.equals("N");
    }

    private static void wait(int milliseconds) {
        try {
            while (milliseconds > 0) {
                int waitTime = milliseconds > 1000 ? 1000 : milliseconds;
                Thread.sleep(waitTime);
                milliseconds -= waitTime;
            }
        }
        catch (InterruptedException e) {
            BFLogger.logDebug((String)"Timed out after waiting timer to finish countdown.");
        }
    }

    public static Date stringToDate(String value, String format) {
        Date date = null;
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        try {
            date = dateFormat.parse(value);
        }
        catch (ParseException e) {
            String exceptionMessage = "stringToDate failed  : value is " + value + ", format is " + format;
            BFLogger.logDebug((String)exceptionMessage);
            throw new BFInputDataException(exceptionMessage);
        }
        return date;
    }

    public static Date createDateXDaysBeforeCurrentDay(int days) {
        long DAY_IN_MS = 86400000L;
        Date date = new Date(System.currentTimeMillis() - (long)days * DAY_IN_MS);
        return date;
    }

    private static boolean isItWeekend(Calendar today) {
        int dayOfWeek = today.get(7);
        return dayOfWeek > 1 && dayOfWeek <= 6;
    }

    private static Calendar getCurrentESTDate(String format) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        dateFormat.setTimeZone(TimeZone.getTimeZone("EST"));
        Date date = TimeUtills.stringToDate(dateFormat.format(new Date()), format);
        Calendar currentDate = Calendar.getInstance(TimeZone.getTimeZone("EST"));
        currentDate.setTime(date);
        return currentDate;
    }

    public static boolean isDateOlderThanGivenPeriod(long dateTimeMiliseconds, long periodLength) {
        return System.currentTimeMillis() - dateTimeMiliseconds > periodLength;
    }

    public static boolean isMax3YearsBetweenDates(Date date1, Date date2) {
        return Math.abs(date2.getTime() - date1.getTime()) <= 94670000000L;
    }

    public static boolean isPass3YearsSinceGivenDate(long dateEpoch) {
        return TimeUtills.isPassXYearsSinceGivenDate(dateEpoch, 3);
    }

    public static boolean isTodayDate(long dateEpoch) {
        return TimeUtills.isPassXYearsSinceGivenDate(dateEpoch, 0);
    }

    private static boolean isPassXYearsSinceGivenDate(long dateEpoch, int passYears) {
        DateTime currentDate = new DateTime();
        DateTime today = new DateTime(currentDate.getYear(), currentDate.getMonthOfYear(), currentDate.getDayOfMonth(), 0, 0, 0, 0);
        DateTime date = new DateTime(dateEpoch * 1000L);
        Period period = new Period((ReadableInstant)date, (ReadableInstant)today);
        int years = period.getYears();
        int months = period.getMonths();
        int weeks = period.getWeeks();
        int days = period.getDays();
        return years == passYears && months == 0 && days == 0 && weeks == 0;
    }

    public static String getCurrentYear() {
        Calendar today = Calendar.getInstance();
        BFLogger.logInfo((String)String.valueOf(today.get(1)));
        return String.valueOf(today.get(1));
    }

    public static String getPreviousYear() {
        Calendar today = Calendar.getInstance();
        return String.valueOf(today.get(1) - 1);
    }

    public static boolean isPreTaxDay() {
        Calendar today = Calendar.getInstance();
        if (today.get(2) < 3) {
            return true;
        }
        return today.get(2) == 3 && today.get(5) < 15;
    }

    public static boolean isTimestampValueDelayed(By selectorTimestamp) {
        String currentDate;
        int timestampEndIndex;
        int timestampBeginIndex;
        WebElement timestampElement = BasePage.getDriver().findElement(selectorTimestamp);
        String timestampText = timestampElement.getText();
        String timestampValue = timestampText.substring(timestampBeginIndex = timestampText.indexOf("AS OF") + 6, timestampEndIndex = timestampText.indexOf("ET") - 1);
        return !timestampValue.equals(currentDate = TimeUtills.getCurrentESTTimestamp("MM/dd/yyyy h:mm a"));
    }

    public static boolean isTimePassedBetweenHours(String firstHour, String secondHour, long timePassedInMiliseconds) {
        Date date2;
        Date date1;
        SimpleDateFormat format = new SimpleDateFormat("HH:mm");
        try {
            date1 = format.parse(firstHour);
            date2 = format.parse(secondHour);
        }
        catch (ParseException e) {
            throw new BFComponentStateException("time difference", "calculate", "in wrong format");
        }
        long difference = date2.getTime() - date1.getTime();
        return difference >= timePassedInMiliseconds;
    }

    private static String getCurrentESTTimestamp(String format) {
        return TimeUtills.getDateTimestamp(format, new Date());
    }

    private static String getDateTimestamp(String format, Date date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        if (Calendar.getInstance().getTimeZone() != TimeZone.getTimeZone("EST")) {
            dateFormat.setTimeZone(TimeZone.getTimeZone("EST"));
        }
        return dateFormat.format(date);
    }

    private static String getOnlyDataString(String format, Calendar calendar) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        return dateFormat.format(calendar.getTime());
    }

    public static boolean isAfter(Date date) {
        Date now = new Date();
        return now.after(date);
    }
}

