/*
 * Decompiled with CFR 0.152.
 */
package com.capgemini.mrchecker.selenium.core.utils;

import com.capgemini.mrchecker.selenium.core.BasePage;
import com.capgemini.mrchecker.selenium.core.enums.ISubUrl;
import com.capgemini.mrchecker.test.core.exceptions.BFInputDataException;
import com.capgemini.mrchecker.test.core.logger.BFLogger;
import java.io.File;
import java.util.regex.Pattern;
import org.openqa.selenium.By;

public class TestUtils {
    public static boolean isOnPage(ISubUrl pageSubUrl) {
        return TestUtils.isCurrentUrlContains(pageSubUrl.subURL());
    }

    public static boolean isCurrentUrlContains(String url) {
        if (BasePage.getDriver().getCurrentUrl().contains(url)) {
            BFLogger.logDebug((String)("Current page as expected: " + BasePage.getDriver().getCurrentUrl()));
            return true;
        }
        BFLogger.logDebug((String)("Not on " + url + " page. Current page: " + BasePage.getDriver().getCurrentUrl()));
        return false;
    }

    public static boolean isCurrentUrlMatchesPattern(String toMatch) {
        Pattern pattern = Pattern.compile(toMatch);
        return pattern.matcher(BasePage.getDriver().getCurrentUrl()).matches();
    }

    public static boolean isCurrentUrlContains(String[] pageSubUrls) {
        for (String subUrl : pageSubUrls) {
            if (TestUtils.isCurrentUrlContains(subUrl)) continue;
            BFLogger.logDebug((String)("[isCurrentUrlContains()] subUrl: " + subUrl));
            return false;
        }
        return true;
    }

    public static boolean isCurrentPageTitle(String title) {
        if (BasePage.getDriver().getTitle().contains(title)) {
            BFLogger.logDebug((String)("Current page as expected: " + BasePage.getDriver().getTitle()));
            return true;
        }
        BFLogger.logDebug((String)("Not on " + title + " page. Current page: " + BasePage.getDriver().getTitle()));
        return false;
    }

    public void goToPage(String pageUrl) {
        BasePage.getDriver().get(pageUrl);
    }

    public String getCurrentPageURL() {
        return BasePage.getDriver().getCurrentUrl();
    }

    public boolean isTextOnPage(String text) {
        return BasePage.getDriver().findElement(By.cssSelector((String)"body")).getText().contains(text);
    }

    public static String getAbsolutePathFor(String path) {
        String absolutePath = "";
        try {
            String resourceFile = TestUtils.class.getClassLoader().getResource(path).getFile();
            absolutePath = new File(resourceFile).getAbsolutePath();
        }
        catch (NullPointerException e) {
            throw new BFInputDataException("Given path: (" + path + ") does not exists in src/test/resources");
        }
        return absolutePath;
    }
}

