/*
 * Decompiled with CFR 0.152.
 */
package com.capgemini.mrchecker.selenium.core.utils;

import com.capgemini.mrchecker.test.core.exceptions.BFInputDataException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openqa.selenium.WebElement;

public class StringUtils
extends org.apache.commons.lang3.StringUtils {
    private static final Pattern pattern = Pattern.compile(".*\\(([^)]+)\\).*");

    private StringUtils() {
    }

    public static boolean isTextMatchesRegex(String textToMatch, String regex) {
        Pattern pattern = Pattern.compile(regex);
        return pattern.matcher(textToMatch).find();
    }

    public static String findSubstring(String textToMatch, String regex) {
        return StringUtils.findSubstring(textToMatch, regex, 1);
    }

    public static String findSubstring(String textToMatch, String regex, int groupNumber) {
        Pattern pattern = Pattern.compile(regex);
        Matcher patternMatcher = pattern.matcher(textToMatch);
        if (patternMatcher.find()) {
            int groupCount = patternMatcher.groupCount();
            if (groupNumber > groupCount) {
                throw new BFInputDataException("Unable to return group number " + groupNumber + ". Only " + groupCount + " groups were found for regex \"" + regex + "\" in text \"" + textToMatch + "\".");
            }
            return patternMatcher.group(groupNumber);
        }
        return "";
    }

    public static List<String> findSubstrings(String textToMatch, String regex, int groupNumber) {
        Pattern pattern = Pattern.compile(regex);
        Matcher patternMatcher = pattern.matcher(textToMatch);
        ArrayList<String> toReturn = new ArrayList<String>();
        while (patternMatcher.find()) {
            int groupCount = patternMatcher.groupCount();
            if (groupNumber > groupCount) {
                throw new BFInputDataException("Unable to return group number " + groupNumber + ". Only " + groupCount + " groups were found for regex \"" + regex + "\" in text \"" + textToMatch + "\".");
            }
            toReturn.add(patternMatcher.group(groupNumber));
        }
        return toReturn;
    }

    public static boolean isFontBold(WebElement text) {
        return text.getCssValue("font-weight").contains("bold");
    }

    public static String removeTrailingTextInBracketIfPresent(String string) {
        if (string.matches(".*\\s*\\(.*\\)$")) {
            return string.replaceAll("\\s*\\(.*\\)$", "");
        }
        return string;
    }
}

