/*
 * Decompiled with CFR 0.152.
 */
package com.capgemini.mrchecker.selenium.core.utils;

import com.capgemini.mrchecker.selenium.core.BasePage;
import com.capgemini.mrchecker.test.core.logger.BFLogger;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.Keys;
import org.openqa.selenium.Point;
import org.openqa.selenium.WebElement;

public class ScrollUtils {
    private ScrollUtils() {
    }

    public static boolean isScrolledToTheBottomOfThePage() {
        JavascriptExecutor executor = (JavascriptExecutor)BasePage.getDriver();
        Long scrollPositionBefore = (Long)executor.executeScript("return window.scrollY;", new Object[0]);
        executor.executeScript("window.scrollBy(0,250);", new Object[0]);
        Long scrollPositionAfter = (Long)executor.executeScript("return window.scrollY;", new Object[0]);
        BFLogger.logDebug((String)(scrollPositionBefore + " " + scrollPositionAfter));
        return scrollPositionBefore.equals(scrollPositionAfter);
    }

    public static void scrollToBottom() {
        BasePage.getAction().sendKeys(new CharSequence[]{Keys.END}).perform();
    }

    public static void scrollToTop() {
        JavascriptExecutor js = (JavascriptExecutor)BasePage.getDriver();
        js.executeScript("window.scrollTo(0,0);", new Object[0]);
    }

    public static void scrollElementIntoView(WebElement element) {
        Point point = element.getLocation();
        int windowHeight = BasePage.getDriver().manage().window().getSize().getHeight();
        int center = windowHeight / 2;
        int toMove = point.getY();
        int toMoveCenter = toMove >= center || toMove <= BasePage.getDriver().findElement(By.tagName((String)"body")).getSize().getHeight() ? toMove - center : toMove;
        JavascriptExecutor jse = (JavascriptExecutor)BasePage.getDriver();
        jse.executeScript("window.scrollTo(0, arguments[0]);", new Object[]{toMoveCenter});
        BasePage.getDriver().waitForPageLoaded();
    }

    public static boolean isElementLocatedInTheMiddle(WebElement element) {
        JavascriptExecutor jse = (JavascriptExecutor)BasePage.getDriver();
        long verticalOffset = (Long)jse.executeScript("return window.scrollY;", new Object[0]);
        long elementTopPosition = element.getLocation().getY();
        long elementBottomPosition = elementTopPosition + (long)element.getSize().height;
        long windowHeight = BasePage.getDriver().manage().window().getSize().getHeight();
        long windowHeightCenter = windowHeight / 2L + verticalOffset;
        return elementTopPosition < windowHeightCenter && elementBottomPosition > windowHeightCenter;
    }

    public static void scrollPage(int xOffset, int yOffset) {
        JavascriptExecutor jse = (JavascriptExecutor)BasePage.getDriver();
        jse.executeScript("window.scrollBy(" + xOffset + "," + yOffset + ")", new Object[]{""});
    }
}

