/*
 * Decompiled with CFR 0.152.
 */
package com.capgemini.mrchecker.selenium.core.utils;

import com.capgemini.mrchecker.selenium.core.enums.ResolutionEnum;
import com.capgemini.mrchecker.selenium.core.newDrivers.INewWebDriver;
import com.capgemini.mrchecker.selenium.core.utils.WindowUtils;
import com.capgemini.mrchecker.test.core.logger.BFLogger;
import org.openqa.selenium.Dimension;

public class ResolutionUtils {
    public static void setResolution(INewWebDriver driver, int width) {
        Dimension resolution = new Dimension(width, 900);
        ResolutionUtils.setResolution(driver, resolution);
    }

    public static void setResolution(INewWebDriver driver, int width, int height) {
        Dimension resolution = new Dimension(width, height);
        ResolutionUtils.setResolution(driver, resolution);
    }

    public static void setResolution(INewWebDriver driver, ResolutionEnum resolutionEnum) {
        Dimension resolution = new Dimension(resolutionEnum.getWidth(), resolutionEnum.getHeight());
        ResolutionUtils.setResolution(driver, resolution);
    }

    public static void setResolution(INewWebDriver driver, Dimension resolution) {
        BFLogger.logInfo((String)("Trying to set requested resolution: " + resolution.width + "x" + resolution.height + "."));
        driver.manage().window().setSize(resolution);
        BFLogger.logInfo((String)("Resolution readed from device: " + ResolutionUtils.getResolution((INewWebDriver)driver).width + "x" + ResolutionUtils.getResolution((INewWebDriver)driver).height));
        Dimension dimensionWithOffset = new Dimension(ResolutionUtils.getOffsetWidth(driver), resolution.height);
        BFLogger.logInfo((String)("Trying to set increased resolution for 'View port': " + dimensionWithOffset.width + "x" + dimensionWithOffset.height + "."));
        driver.manage().window().setSize(dimensionWithOffset);
        BFLogger.logInfo((String)("Resolution readed from device: " + ResolutionUtils.getResolution((INewWebDriver)driver).width + "x" + ResolutionUtils.getResolution((INewWebDriver)driver).height));
    }

    private static Dimension getResolution(INewWebDriver driver) {
        int width = driver.manage().window().getSize().getWidth();
        int height = driver.manage().window().getSize().getHeight();
        return new Dimension(width, height);
    }

    private static int getOffsetWidth(INewWebDriver driver) {
        int widthScreen = WindowUtils.getScreenWidth(driver);
        int offset = driver.manage().window().getSize().getWidth() - widthScreen;
        return driver.manage().window().getSize().getWidth() + offset;
    }
}

