/*
 * Decompiled with CFR 0.152.
 */
package com.capgemini.mrchecker.selenium.core.newDrivers.elementType;

import com.capgemini.mrchecker.selenium.core.exceptions.BFElementNotFoundException;
import com.capgemini.mrchecker.selenium.core.newDrivers.elementType.BasicElement;
import com.capgemini.mrchecker.selenium.core.newDrivers.elementType.ElementType;
import com.capgemini.mrchecker.selenium.core.newDrivers.elementType.IBasicElement;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

public class RadioButtonElement
extends BasicElement
implements IBasicElement {
    private By inputChildsSelector;
    private List<WebElement> listElements;
    private List<String> listSelectedAttributes;

    public RadioButtonElement(By cssSelector) {
        this(cssSelector, By.cssSelector((String)"input"), Collections.singletonList("selected"));
    }

    public RadioButtonElement(By cssSelector, By inputChildsSelector) {
        this(ElementType.INPUT_TEXT, cssSelector, inputChildsSelector, Collections.singletonList("selected"));
    }

    public RadioButtonElement(By cssSelector, By inputChildsSelector, List<String> listSelectedAttributes) {
        this(ElementType.INPUT_TEXT, cssSelector, inputChildsSelector, listSelectedAttributes);
    }

    protected RadioButtonElement(ElementType elemType, By cssSelector, By inputChildsSelector, List<String> listSelectedAttributes) {
        super(elemType, cssSelector);
        this.setInputChildsSelector(inputChildsSelector);
        this.setSelectedAttributes(listSelectedAttributes);
    }

    public int getSelectedItemIndex() {
        this.setItems();
        return this.listElements.indexOf(this.getSelectedItem());
    }

    public String getSelectedItemText() {
        return this.getSelectedItem().getText();
    }

    public String getSelectedItemValue() {
        return this.getSelectedItem().getAttribute("value");
    }

    public List<String> getTextList() {
        return Arrays.asList(this.getTextArray());
    }

    public int getItemsCount() {
        this.setItems();
        return this.listElements.size();
    }

    public boolean isItemSelectedByText(String elementText) {
        return this.getSelectedItemText().equals(elementText);
    }

    public boolean isItemSelectedByIndex(int elementIndex) {
        return this.getSelectedItemIndex() == elementIndex;
    }

    public boolean isItemSelectedByValue(String elementValue) {
        return this.getSelectedItemValue().equals(elementValue);
    }

    public void selectItemByText(String elementText) {
        WebElement elementToClick = this.getItemByText(elementText);
        elementToClick.click();
        this.checkIsItemClicked(elementToClick);
    }

    public void selectItemByIndex(int elementIndex) {
        WebElement elementToClick = this.getItemByIndex(elementIndex);
        elementToClick.click();
        this.checkIsItemClicked(elementToClick);
    }

    public void selectItemByValue(String elementValue) {
        WebElement elementToClick = this.getItemByValue(elementValue);
        elementToClick.click();
        this.checkIsItemClicked(elementToClick);
    }

    private void checkIsItemClicked(WebElement element) {
        if (this.isItemSelected(element)) {
            System.out.println(this.getElementTypeName() + ": " + this.toString() + " isn't clicked.");
        }
    }

    private String[] getTextArray() {
        return this.getElement().getText().trim().split("\n");
    }

    private void setInputChildsSelector(By selector) {
        this.inputChildsSelector = selector;
    }

    private void setSelectedAttributes(List<String> listSelectedAttributes) {
        this.listSelectedAttributes = listSelectedAttributes;
    }

    private void setListItems(List<WebElement> listElements) {
        this.listElements = listElements;
    }

    private boolean isItemSelected(WebElement el) {
        return el.isSelected();
    }

    private void setItems() {
        this.setListItems(this.getElement().findElements(this.inputChildsSelector));
    }

    private WebElement getItemByIndex(int index) {
        this.setItems();
        if (this.listElements.isEmpty()) {
            throw new BFElementNotFoundException("Any " + this.getElementTypeName() + " element was found.");
        }
        return this.listElements.get(index);
    }

    private WebElement getItemByText(String visibleText) {
        for (int i = 0; i < this.getItemsCount(); ++i) {
            if (!this.listElements.get(i).getText().equals(visibleText)) continue;
            return this.listElements.get(i);
        }
        throw new BFElementNotFoundException(this.getElementTypeName() + " with text: " + visibleText + " wasn't found in " + Arrays.toString(this.getTextArray()));
    }

    private WebElement getItemByValue(String value) {
        this.setItems();
        for (int i = 0; i < this.getItemsCount(); ++i) {
            if (!this.listElements.get(i).getAttribute("value").equals(value)) continue;
            return this.listElements.get(i);
        }
        throw new BFElementNotFoundException(this.getElementTypeName() + " with value: " + value + " wasn't found in " + Arrays.toString(this.getTextArray()));
    }

    private boolean isClassContainSelectionAttributes(String classAttribute) {
        for (String listSelectedAttribute : this.listSelectedAttributes) {
            if (!classAttribute.contains(listSelectedAttribute)) continue;
            return true;
        }
        return false;
    }

    private WebElement getSelectedItem() {
        this.setItems();
        for (WebElement listElement : this.listElements) {
            if (!this.isItemSelected(listElement) && !this.isClassContainSelectionAttributes(listElement.getAttribute("class"))) continue;
            return listElement;
        }
        throw new BFElementNotFoundException("Any element is selected in " + Arrays.toString(this.getTextArray()));
    }
}

