/*
 * Decompiled with CFR 0.152.
 */
package com.capgemini.mrchecker.selenium.core.newDrivers.elementType;

import com.capgemini.mrchecker.selenium.core.exceptions.BFComponentStateException;
import com.capgemini.mrchecker.selenium.core.newDrivers.elementType.BasicElement;
import com.capgemini.mrchecker.selenium.core.newDrivers.elementType.ElementType;
import com.capgemini.mrchecker.selenium.core.newDrivers.elementType.IBasicElement;
import java.util.ArrayList;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.Select;

public class DropdownListElement
extends BasicElement
implements IBasicElement {
    public DropdownListElement(By cssSelector) {
        super(ElementType.DROPDOWN, cssSelector);
    }

    public void selectDropdownByIndex(int index) {
        this.getObject().selectByIndex(index);
        List list = this.getObject().getOptions();
        if (!((WebElement)list.get(index)).isSelected()) {
            throw new BFComponentStateException(ElementType.DROPDOWN.toString(), "select", "Option with index: " + index + " should be set from in " + this.getObject().toString());
        }
    }

    public boolean isDropdownElementSelectedByIndex(int index) {
        return this.getPossibleOptions().get(index).isSelected();
    }

    public void selectDropdownByValue(String value) {
        value = value.trim();
        this.getObject().selectByValue(value);
        if (!this.isDropdownElementSelectedByValue(value)) {
            throw new BFComponentStateException(ElementType.DROPDOWN.toString(), "select", "Option with value: " + value + " should be set from in " + this.getObject().toString());
        }
    }

    public void selectDropdownByVisibleText(String value) {
        boolean flag = false;
        this.getObject().selectByVisibleText(value);
        List<String> list = this.getAllSelectedOptionsText();
        for (String s : list) {
            if (!s.equals(value)) continue;
            flag = true;
            break;
        }
        if (!flag) {
            throw new RuntimeException("Option with text: " + value + " wasn't selected in " + this.getObject().toString());
        }
    }

    public List<String> getAllSelectedOptionsText() {
        List list = this.getObject().getAllSelectedOptions();
        return this.getValuesFromWebElements(list);
    }

    public String getFirstSelectedOptionText() {
        return this.getObject().getFirstSelectedOption().getText().trim();
    }

    public int getAmountOfPossibleValues() {
        List list = this.getObject().getOptions();
        return list.size();
    }

    public boolean isDropdownElementSelectedByValue(String value) {
        int index = this.getIndexDropdownElementByValue(value);
        return this.getPossibleOptions().get(index).isSelected();
    }

    private List<WebElement> getPossibleOptions() {
        return this.getObject().getOptions();
    }

    private List<String> getPossibleValuesText() {
        List list = this.getObject().getOptions();
        return this.getValuesFromWebElements(list);
    }

    private int getIndexDropdownElementByValue(String value) {
        return this.getPossibleValuesText().indexOf(value);
    }

    private Select getObject() {
        return new Select(this.getElement());
    }

    private List<String> getValuesFromWebElements(List<WebElement> list) {
        ArrayList<String> output = new ArrayList<String>();
        for (WebElement webElement : list) {
            output.add(webElement.getText().trim());
        }
        return output;
    }
}

