/*
 * Decompiled with CFR 0.152.
 */
package com.capgemini.mrchecker.selenium.core.newDrivers;

import com.capgemini.mrchecker.selenium.core.base.properties.PropertiesSelenium;
import com.capgemini.mrchecker.selenium.core.base.runtime.RuntimeParametersSelenium;
import com.capgemini.mrchecker.selenium.core.enums.ResolutionEnum;
import com.capgemini.mrchecker.selenium.core.newDrivers.INewWebDriver;
import com.capgemini.mrchecker.selenium.core.newDrivers.NewChromeDriver;
import com.capgemini.mrchecker.selenium.core.newDrivers.NewEdgeDriver;
import com.capgemini.mrchecker.selenium.core.newDrivers.NewFirefoxDriver;
import com.capgemini.mrchecker.selenium.core.newDrivers.NewInternetExplorerDriver;
import com.capgemini.mrchecker.selenium.core.newDrivers.NewRemoteWebDriver;
import com.capgemini.mrchecker.selenium.core.newDrivers.NewRemoteWebElement;
import com.capgemini.mrchecker.selenium.core.utils.OperationsOnFiles;
import com.capgemini.mrchecker.selenium.core.utils.ResolutionUtils;
import com.capgemini.mrchecker.test.core.logger.BFLogger;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import io.github.bonigarcia.wdm.WebDriverManager;
import io.github.bonigarcia.wdm.config.WebDriverManagerException;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Duration;
import java.util.HashMap;
import java.util.Objects;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.PageLoadStrategy;
import org.openqa.selenium.Platform;
import org.openqa.selenium.UnexpectedAlertBehaviour;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.edge.EdgeDriver;
import org.openqa.selenium.edge.EdgeOptions;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.ie.InternetExplorerOptions;
import org.openqa.selenium.remote.Browser;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.support.ui.WebDriverWait;

public class DriverManager {
    private static final ThreadLocal<INewWebDriver> DRIVERS = new ThreadLocal();
    private static final ThreadLocal<WebDriverWait> DRIVERS_WAIT = new ThreadLocal();
    private static final ResolutionEnum DEFAULT_RESOLUTION = ResolutionEnum.w1920;
    private static final Duration IMPLICITLY_WAIT = Duration.ofSeconds(2L);
    public static final Duration EXPLICIT_WAIT = Duration.ofSeconds(20L);
    private static final String DOWNLOAD_DIR = System.getProperty("java.io.tmpdir");
    private static boolean driverDownloadedChrome = false;
    private static boolean driverDownloadedFirefox = false;
    private static boolean driverDownloadedMicrosoftEdge = false;
    private static boolean driverDownloadedInternetExplorer = false;
    private static PropertiesSelenium propertiesSelenium;

    @Inject
    public DriverManager(@Named(value="properties") PropertiesSelenium propertiesSelenium) {
        if (Objects.isNull(DriverManager.propertiesSelenium)) {
            DriverManager.propertiesSelenium = propertiesSelenium;
        }
        this.start();
    }

    public void start() {
        DriverManager.getDriver();
    }

    public void stop() {
        try {
            DriverManager.closeDriver();
            BFLogger.logDebug((String)"Closing Driver in stop()");
            BFLogger.logInfo((String)String.format("All clicks took %.2fs", 1.0 * (double)NewRemoteWebElement.dropClickTimer() / 1000.0));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static INewWebDriver getDriver() {
        INewWebDriver driver = DRIVERS.get();
        if (Objects.isNull(driver)) {
            String browser = RuntimeParametersSelenium.BROWSER.getValue();
            if (Browser.CHROME.is(browser)) {
                return Driver.CHROME.getDriver();
            }
            if (Browser.EDGE.is(browser)) {
                return Driver.EDGE.getDriver();
            }
            if (Browser.FIREFOX.is(browser)) {
                return Driver.FIREFOX.getDriver();
            }
            if (Browser.IE.is(browser)) {
                return Driver.IE.getDriver();
            }
            throw new IllegalStateException("Unsupported browser: " + browser);
        }
        return driver;
    }

    public static WebDriverWait getDriverWait() {
        WebDriverWait webDriverWait = DRIVERS_WAIT.get();
        if (Objects.isNull(webDriverWait)) {
            webDriverWait = new WebDriverWait((WebDriver)DriverManager.getDriver(), EXPLICIT_WAIT);
            DRIVERS_WAIT.set(webDriverWait);
        }
        return webDriverWait;
    }

    public static boolean hasDriverCrushed() {
        if (DriverManager.wasDriverCreated()) {
            INewWebDriver driver = DRIVERS.get();
            try {
                return driver.toString().contains("(null)") || driver.getWindowHandles().isEmpty();
            }
            catch (Exception e) {
                return true;
            }
        }
        return false;
    }

    public static boolean wasDriverCreated() {
        return Objects.nonNull(DRIVERS.get());
    }

    public static void closeDriver() {
        INewWebDriver driver = DRIVERS.get();
        if (Objects.isNull(driver)) {
            BFLogger.logDebug((String)"closeDriver() was called but there was no driver for this thread.");
        } else {
            try {
                BFLogger.logDebug((String)("Closing WebDriver for this thread. " + RuntimeParametersSelenium.BROWSER.getValue()));
                driver.quit();
            }
            catch (WebDriverException e) {
                BFLogger.logDebug((String)"Ooops! Something went wrong while closing the driver: ");
                e.printStackTrace();
            }
            finally {
                DRIVERS.remove();
                DRIVERS_WAIT.remove();
            }
        }
    }

    private static boolean isEmpty(String seleniumGridParameter) {
        return seleniumGridParameter == null || seleniumGridParameter.trim().isEmpty();
    }

    private static <T extends RemoteWebDriver> void downloadNewestOrGivenVersionOfWebDriver(Class<T> webDriverType) {
        String proxy = propertiesSelenium.getProxy();
        String webDriversPath = propertiesSelenium.getWebDrivers();
        try {
            System.setProperty("wdm.targetPath", webDriversPath);
            System.setProperty("wdm.useBetaVersions", "false");
            WebDriverManager.getInstance(webDriverType).proxy(proxy).setup();
            BFLogger.logDebug((String)("Downloaded version of driver=" + WebDriverManager.getInstance(webDriverType).getDownloadedDriverVersion()));
        }
        catch (WebDriverManagerException e) {
            BFLogger.logInfo((String)"Unable to download driver automatically. Please try to set up the proxy in properties file. If you want to download them manually, go to the http://www.seleniumhq.org/projects/webdriver/ site.");
        }
    }

    public static ChromeOptions getChromeOptions() {
        HashMap<String, Object> chromePrefs = new HashMap<String, Object>();
        chromePrefs.put("download.default_directory", DOWNLOAD_DIR);
        chromePrefs.put("profile.content_settings.pattern_pairs.*.multiple-automatic-downloads", 1);
        chromePrefs.put("profile.default_content_setting_values.notifications", 2);
        RuntimeParametersSelenium.BROWSER_OPTIONS.getValues().forEach((key, value) -> {
            BFLogger.logInfo((String)("Add to Chrome prefs: " + key + " = " + value.toString()));
            chromePrefs.put((String)key, value.toString());
        });
        ChromeOptions options = new ChromeOptions();
        options.setUnhandledPromptBehaviour(UnexpectedAlertBehaviour.DISMISS);
        options.setPageLoadStrategy(PageLoadStrategy.NORMAL);
        options.setExperimentalOption("prefs", chromePrefs);
        options.setAcceptInsecureCerts(true);
        options.setCapability("acceptSslCerts", true);
        options.addArguments(new String[]{"--test-type"});
        options.addArguments(new String[]{"window-size=1920x1080"});
        options.addArguments(new String[]{"--ignore-certificate-errors"});
        options.addArguments(new String[]{"--allow-insecure-localhost"});
        options.addArguments(new String[]{"--allow-running-insecure-content"});
        options.addArguments(new String[]{"--disable-popup-blocking"});
        options.setHeadless(Boolean.parseBoolean(System.getProperty("headless", "false")));
        RuntimeParametersSelenium.BROWSER_OPTIONS.getValues().forEach((key, value) -> {
            BFLogger.logInfo((String)("Add to Chrome options: " + key + " = " + value.toString()));
            String item = value.toString().isEmpty() ? key : key + "=" + value;
            options.addArguments(new String[]{item});
            options.setCapability(key, value.toString());
        });
        return options;
    }

    public static EdgeOptions getEdgeOptions() {
        HashMap<String, Object> edgePrefs = new HashMap<String, Object>();
        edgePrefs.put("download.default_directory", DOWNLOAD_DIR);
        edgePrefs.put("profile.content_settings.pattern_pairs.*.multiple-automatic-downloads", 1);
        edgePrefs.put("profile.default_content_setting_values.notifications", 2);
        RuntimeParametersSelenium.BROWSER_OPTIONS.getValues().forEach((key, value) -> {
            BFLogger.logInfo((String)("Add to Edge prefs: " + key + " = " + value.toString()));
            edgePrefs.put((String)key, value.toString());
        });
        EdgeOptions options = new EdgeOptions();
        options.setUnhandledPromptBehaviour(UnexpectedAlertBehaviour.DISMISS);
        options.setPageLoadStrategy(PageLoadStrategy.NORMAL);
        options.setExperimentalOption("prefs", edgePrefs);
        options.setAcceptInsecureCerts(true);
        options.setCapability("acceptSslCerts", true);
        options.addArguments(new String[]{"--test-type"});
        options.addArguments(new String[]{"window-size=1920x1080"});
        options.addArguments(new String[]{"--ignore-certificate-errors"});
        options.addArguments(new String[]{"--allow-insecure-localhost"});
        options.addArguments(new String[]{"--allow-running-insecure-content"});
        options.addArguments(new String[]{"--disable-popup-blocking"});
        options.setHeadless(Boolean.parseBoolean(System.getProperty("headless", "false")));
        RuntimeParametersSelenium.BROWSER_OPTIONS.getValues().forEach((key, value) -> {
            BFLogger.logInfo((String)("Add to Edge options: " + key + " = " + value.toString()));
            String item = value.toString().isEmpty() ? key : key + "=" + value;
            options.addArguments(new String[]{item});
            options.setCapability(key, value.toString());
        });
        return options;
    }

    public static FirefoxOptions getFirefoxOptions() {
        FirefoxProfile profile = new FirefoxProfile();
        profile.setAcceptUntrustedCertificates(true);
        profile.setAssumeUntrustedCertificateIssuer(false);
        profile.setPreference("browser.download.folderList", (Object)2);
        profile.setPreference("browser.download.dir", (Object)DOWNLOAD_DIR);
        profile.setPreference("browser.download.useDownloadDir", (Object)true);
        profile.setPreference("security.ssl.enable_ocsp_stapling", (Object)false);
        profile.setPreference("dom.disable_beforeunload", (Object)true);
        profile.setPreference("dom.webnotifications.enabled", (Object)false);
        profile.setPreference("dom.push.enabled", (Object)false);
        profile.setPreference("browser.cache.disk.enable", (Object)false);
        profile.setPreference("browser.cache.memory.enable", (Object)false);
        profile.setPreference("browser.cache.offline.enable", (Object)false);
        profile.setPreference("browser.startup.homepage_override.mstone", (Object)"ignore");
        profile.setPreference("security.tls.version.min", (Object)1);
        profile.setPreference("intl.accept_languages", (Object)"en-us");
        profile.setPreference("browser.helperApps.neverAsk.saveToDisk", (Object)"text/comma-separated-values, application/vnd.ms-excel, application/msword, application/csv, application/ris, text/csv, image/png, application/pdf, text/html, text/plain, application/zip, application/x-zip, application/x-zip-compressed, application/download, application/octet-stream, application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        profile.setPreference("browser.download.manager.showWhenStarting", (Object)false);
        profile.setPreference("browser.helperApps.alwaysAsk.force", (Object)false);
        profile.setPreference("pdfjs.disabled", (Object)false);
        profile.setPreference("network.http.use-cache", (Object)false);
        RuntimeParametersSelenium.BROWSER_OPTIONS.getValues().forEach((key, value) -> {
            BFLogger.logInfo((String)("Add to Firefox profile: " + key + " = " + value.toString()));
            profile.setPreference(key, (Object)value.toString());
        });
        FirefoxOptions options = new FirefoxOptions().setProfile(profile);
        options.setCapability("security.ssl.enable_ocsp_stapling", false);
        options.setUnhandledPromptBehaviour(UnexpectedAlertBehaviour.DISMISS);
        options.setPageLoadStrategy(PageLoadStrategy.NORMAL);
        options.setAcceptInsecureCerts(true);
        options.setCapability("acceptSslCerts", true);
        options.setCapability("handleAlerts", true);
        options.setCapability("network.http.use-cache", false);
        options.setCapability("security.cert_pinning.enforcement_level", (Object)0);
        options.setCapability("security.enterprise_roots.enabled", true);
        options.setHeadless(Boolean.parseBoolean(System.getProperty("headless", "false")));
        RuntimeParametersSelenium.BROWSER_OPTIONS.getValues().forEach((key, value) -> {
            BFLogger.logInfo((String)("Add to Firefox options: " + key + " = " + value.toString()));
            String item = value.toString().isEmpty() ? key : key + "=" + value;
            options.addArguments(new String[]{item});
            options.setCapability(key, value.toString());
        });
        return options;
    }

    public static InternetExplorerOptions getInternetExplorerOptions() {
        InternetExplorerOptions options = new InternetExplorerOptions();
        options.setUnhandledPromptBehaviour(UnexpectedAlertBehaviour.DISMISS);
        options.setPageLoadStrategy(PageLoadStrategy.NORMAL);
        options.setAcceptInsecureCerts(true);
        options.setCapability("acceptSslCerts", true);
        RuntimeParametersSelenium.BROWSER_OPTIONS.getValues().forEach((key, value) -> {
            BFLogger.logInfo((String)("Add to Internet Explorer options: " + key + " = " + value.toString()));
            options.setCapability(key, value.toString());
        });
        return options;
    }

    public static INewWebDriver getDriver(MutableCapabilities options) {
        INewWebDriver driver = DRIVERS.get();
        if (Objects.isNull(driver)) {
            BFLogger.logDebug((String)("Creating new " + RuntimeParametersSelenium.BROWSER.getValue() + " WebDriver."));
            String seleniumGridParameter = RuntimeParametersSelenium.SELENIUM_GRID.getValue();
            if (!DriverManager.isEmpty(seleniumGridParameter)) {
                driver = DriverManager.getRemoteDriver(options);
            } else {
                String browser = RuntimeParametersSelenium.BROWSER.getValue();
                if (Browser.CHROME.is(browser)) {
                    driver = DriverManager.getChromeDriver((ChromeOptions)options);
                } else if (Browser.EDGE.is(browser)) {
                    driver = DriverManager.getEdgeDriver((EdgeOptions)options);
                } else if (Browser.FIREFOX.is(browser)) {
                    driver = DriverManager.getFirefoxDriver((FirefoxOptions)options);
                } else if (Browser.IE.is(browser)) {
                    driver = DriverManager.getInternetExplorerDriver((InternetExplorerOptions)options);
                } else {
                    throw new IllegalStateException("Unsupported browser: " + browser);
                }
            }
            DRIVERS.set(driver);
            BFLogger.logDebug((String)("Driver:" + driver));
            driver.manage().timeouts().implicitlyWait(IMPLICITLY_WAIT);
            ResolutionUtils.setResolution(driver, DEFAULT_RESOLUTION);
            NewRemoteWebElement.setClickTimer();
        }
        return driver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static INewWebDriver getChromeDriver(ChromeOptions chromeOptions) {
        INewWebDriver driver = DRIVERS.get();
        if (Objects.isNull(driver)) {
            String browserPath = propertiesSelenium.getSeleniumChrome();
            boolean isDriverAutoUpdateActivated = propertiesSelenium.getDriverAutoUpdateFlag();
            String string = DOWNLOAD_DIR;
            synchronized (string) {
                if (isDriverAutoUpdateActivated && !driverDownloadedChrome) {
                    if (!propertiesSelenium.getChromeDriverVersion().isEmpty()) {
                        System.setProperty("wdm.chromeDriverVersion", propertiesSelenium.getChromeDriverVersion());
                    }
                    DriverManager.downloadNewestOrGivenVersionOfWebDriver(ChromeDriver.class);
                    OperationsOnFiles.moveWithPruneEmptydirectories(WebDriverManager.getInstance(ChromeDriver.class).getDownloadedDriverPath(), browserPath);
                }
                driverDownloadedChrome = true;
            }
            System.setProperty("webdriver.chrome.driver", browserPath);
            return new NewChromeDriver(chromeOptions);
        }
        return driver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static INewWebDriver getEdgeDriver(EdgeOptions edgeOptions) {
        INewWebDriver driver = DRIVERS.get();
        if (Objects.isNull(driver)) {
            String browserPath = propertiesSelenium.getSeleniumEdge();
            boolean isDriverAutoUpdateActivated = propertiesSelenium.getDriverAutoUpdateFlag();
            String string = DOWNLOAD_DIR;
            synchronized (string) {
                if (isDriverAutoUpdateActivated && !driverDownloadedMicrosoftEdge) {
                    if (!propertiesSelenium.getEdgeDriverVersion().isEmpty()) {
                        System.setProperty("wdm.edgeVersion", propertiesSelenium.getEdgeDriverVersion());
                    }
                    DriverManager.downloadNewestOrGivenVersionOfWebDriver(EdgeDriver.class);
                    OperationsOnFiles.moveWithPruneEmptydirectories(WebDriverManager.getInstance(EdgeDriver.class).getDownloadedDriverPath(), browserPath);
                }
                driverDownloadedMicrosoftEdge = true;
            }
            System.setProperty("webdriver.edge.driver", browserPath);
            return new NewEdgeDriver(edgeOptions);
        }
        return driver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static INewWebDriver getFirefoxDriver(FirefoxOptions firefoxOptions) {
        INewWebDriver driver = DRIVERS.get();
        if (Objects.isNull(driver)) {
            String browserPath = propertiesSelenium.getSeleniumFirefox();
            boolean isDriverAutoUpdateActivated = propertiesSelenium.getDriverAutoUpdateFlag();
            String string = DOWNLOAD_DIR;
            synchronized (string) {
                if (isDriverAutoUpdateActivated && !driverDownloadedFirefox) {
                    if (!propertiesSelenium.getGeckoDriverVersion().isEmpty()) {
                        System.setProperty("wdm.geckoDriverVersion", propertiesSelenium.getGeckoDriverVersion());
                    }
                    DriverManager.downloadNewestOrGivenVersionOfWebDriver(FirefoxDriver.class);
                    OperationsOnFiles.moveWithPruneEmptydirectories(WebDriverManager.getInstance(FirefoxDriver.class).getDownloadedDriverPath(), browserPath);
                }
                driverDownloadedFirefox = true;
            }
            System.setProperty("webdriver.gecko.driver", browserPath);
            System.setProperty("webdriver.firefox.logfile", "logs\\firefox_logs.txt");
            return new NewFirefoxDriver(firefoxOptions);
        }
        return driver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static INewWebDriver getInternetExplorerDriver(InternetExplorerOptions internetExplorerOptions) {
        INewWebDriver driver = DRIVERS.get();
        if (Objects.isNull(driver)) {
            String browserPath = propertiesSelenium.getSeleniumIE();
            boolean isDriverAutoUpdateActivated = propertiesSelenium.getDriverAutoUpdateFlag();
            String string = DOWNLOAD_DIR;
            synchronized (string) {
                if (isDriverAutoUpdateActivated && !driverDownloadedInternetExplorer) {
                    if (!propertiesSelenium.getInternetExplorerDriverVersion().equals("")) {
                        System.setProperty("wdm.internetExplorerDriverVersion", propertiesSelenium.getInternetExplorerDriverVersion());
                    }
                    DriverManager.downloadNewestOrGivenVersionOfWebDriver(InternetExplorerDriver.class);
                    OperationsOnFiles.moveWithPruneEmptydirectories(WebDriverManager.getInstance(InternetExplorerDriver.class).getDownloadedDriverPath(), browserPath);
                }
                driverDownloadedInternetExplorer = true;
            }
            System.setProperty("webdriver.ie.driver", browserPath);
            return new NewInternetExplorerDriver(internetExplorerOptions);
        }
        return driver;
    }

    private static INewWebDriver getRemoteDriver(MutableCapabilities options) {
        String operatingSystem;
        String SELENIUM_GRID_URL = RuntimeParametersSelenium.SELENIUM_GRID.getValue();
        BFLogger.logDebug((String)("Connecting to the selenium grid: " + SELENIUM_GRID_URL));
        DesiredCapabilities capabilities = new DesiredCapabilities();
        switch (operatingSystem = RuntimeParametersSelenium.OS.getValue()) {
            case "windows": {
                capabilities.setPlatform(Platform.WINDOWS);
                break;
            }
            case "vista": {
                capabilities.setPlatform(Platform.VISTA);
                break;
            }
            case "mac": {
                capabilities.setPlatform(Platform.MAC);
                break;
            }
            default: {
                capabilities.setPlatform(Platform.LINUX);
            }
        }
        String browser = RuntimeParametersSelenium.BROWSER.getValue();
        if (Browser.CHROME.is(browser)) {
            capabilities.setCapability("goog:chromeOptions", (Object)options);
        } else if (Browser.EDGE.is(browser)) {
            capabilities.setCapability("ms:edgeOptions", (Object)options);
        } else if (Browser.FIREFOX.is(browser)) {
            capabilities.setCapability("moz:firefoxOptions", (Object)options);
        } else {
            throw new IllegalStateException("Unsupported browser: " + browser);
        }
        capabilities.setBrowserName(browser);
        if (Boolean.parseBoolean(System.getProperty("selenium3grid", "false"))) {
            capabilities.setCapability("version", RuntimeParametersSelenium.BROWSER_VERSION.getValue());
        } else {
            capabilities.setVersion(RuntimeParametersSelenium.BROWSER_VERSION.getValue());
        }
        RuntimeParametersSelenium.BROWSER_OPTIONS.getValues().forEach((key, value) -> {
            BFLogger.logInfo((String)("Browser option: " + key + " " + value.toString()));
            capabilities.setCapability(key, value.toString());
        });
        NewRemoteWebDriver newRemoteWebDriver = null;
        try {
            newRemoteWebDriver = new NewRemoteWebDriver(new URL(SELENIUM_GRID_URL), capabilities);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            System.out.println("Unable to find selenium grid URL: " + SELENIUM_GRID_URL);
        }
        return newRemoteWebDriver;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        try {
            DriverManager.closeDriver();
            BFLogger.logDebug((String)"Closing Driver in finalize()");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static enum Driver {
        CHROME{

            @Override
            public INewWebDriver getDriver() {
                return DriverManager.getDriver((MutableCapabilities)DriverManager.getChromeOptions());
            }
        }
        ,
        EDGE{

            @Override
            public INewWebDriver getDriver() {
                return DriverManager.getDriver((MutableCapabilities)DriverManager.getEdgeOptions());
            }
        }
        ,
        FIREFOX{

            @Override
            public INewWebDriver getDriver() {
                return DriverManager.getDriver((MutableCapabilities)DriverManager.getFirefoxOptions());
            }
        }
        ,
        IE{

            @Override
            public INewWebDriver getDriver() {
                return DriverManager.getDriver((MutableCapabilities)DriverManager.getInternetExplorerOptions());
            }
        };


        protected abstract INewWebDriver getDriver();
    }
}

