/*
 * Decompiled with CFR 0.152.
 */
package com.capgemini.mrchecker.selenium.core.exceptions;

import com.capgemini.mrchecker.test.core.logger.BFLogger;
import com.capgemini.mrchecker.test.core.utils.DurationUtils;
import java.time.Duration;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;

public class BFElementNotFoundException
extends NoSuchElementException {
    private static final long serialVersionUID = 6697212034783474583L;
    private static String messageText;

    public BFElementNotFoundException(By by) {
        this(by, "", false, Duration.ZERO);
    }

    public BFElementNotFoundException(By by, String message) {
        this(by, message, false, Duration.ZERO);
    }

    public BFElementNotFoundException(By by, boolean isTimeout) {
        this(by, "", isTimeout, Duration.ZERO);
    }

    public BFElementNotFoundException(By by, String message, boolean isTimeout) {
        this(by, message, isTimeout, Duration.ZERO);
    }

    public BFElementNotFoundException(By by, boolean isTimeout, Duration timeoutValue) {
        this(by, "", isTimeout, timeoutValue);
    }

    public BFElementNotFoundException(By by, String message, boolean isTimeout, Duration timeoutValue) {
        super(BFElementNotFoundException.generateMessage(by, message, isTimeout, timeoutValue));
        if (message.isEmpty()) {
            return;
        }
        BFLogger.logDebug((String)messageText);
    }

    public BFElementNotFoundException(String message) {
        super(message);
        BFLogger.logDebug((String)message);
    }

    private static String generateMessage(By by, String message, boolean isTimeout, Duration timeoutValue) {
        messageText = BFElementNotFoundException.addTimeoutMessasg(message, isTimeout, timeoutValue) + BFElementNotFoundException.generateStandardMessage(by);
        return messageText;
    }

    private static String generateStandardMessage(By by) {
        return BFElementNotFoundException.getExceutedMethodName() + "\nElement '" + by.toString() + "' was not found. Check printscreen.\n";
    }

    private static String getExceutedMethodName() {
        String executedMethodName = "\nExecuted method: ";
        try {
            String stackTraceElements = "";
            int i = 0;
            while (i++ < 16) {
                String stackTraceElement = Thread.currentThread().getStackTrace()[i].toString();
                if (!stackTraceElement.contains("com.example.webframe.pages") || stackTraceElement.contains("com.example.webframe.pages.exceptions.BFElementNotFoundException")) continue;
                stackTraceElements = stackTraceElements.concat("\n" + Thread.currentThread().getStackTrace()[i].toString());
            }
            executedMethodName = executedMethodName + stackTraceElements + "\n";
        }
        catch (ArrayIndexOutOfBoundsException e) {
            executedMethodName = "";
        }
        return executedMethodName;
    }

    private static String addTimeoutMessasg(String message, boolean isTimeout, Duration timeoutValue) {
        if (isTimeout) {
            String messageTimeout = " Due to TIMEOUT. ";
            if (!timeoutValue.isZero()) {
                messageTimeout = " Due to TIMEOUT= " + DurationUtils.getReadableDuration((Duration)timeoutValue);
            }
            message = message + messageTimeout;
        }
        return message;
    }
}

