/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayexport.util.policy;

import com.ca.apim.gateway.cagatewayconfig.beans.Bundle;
import com.ca.apim.gateway.cagatewayconfig.bundle.loader.BundleLoadException;
import com.ca.apim.gateway.cagatewayconfig.util.xml.DocumentParseException;
import com.ca.apim.gateway.cagatewayexport.util.policy.PolicyAssertionSimplifier;
import com.ca.apim.gateway.cagatewayexport.util.policy.PolicySimplifierContext;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Singleton
public class PolicyXMLSimplifier {
    private Map<String, PolicyAssertionSimplifier> simplifiersByTag = new HashMap<String, PolicyAssertionSimplifier>();

    @Inject
    public PolicyXMLSimplifier(Set<PolicyAssertionSimplifier> simplifiers) {
        simplifiers.forEach(s -> this.simplifiersByTag.put(s.getAssertionTagName(), (PolicyAssertionSimplifier)s));
        this.simplifiersByTag = Collections.unmodifiableMap(this.simplifiersByTag);
    }

    public void simplifyPolicyXML(Element policyElement, String policyName, Bundle bundle, Bundle resultantBundle) {
        PolicySimplifierContext context = new PolicySimplifierContext(policyName, bundle, resultantBundle);
        this.simplifiersByTag.forEach((tag, simplifier) -> PolicyXMLSimplifier.findAndSimplifyAssertion(policyElement, tag, simplifier, context));
    }

    private static void findAndSimplifyAssertion(Element policyElement, String assertionTagName, PolicyAssertionSimplifier simplifier, PolicySimplifierContext context) {
        NodeList includeReferences = policyElement.getElementsByTagName(assertionTagName);
        for (int i = 0; i < includeReferences.getLength(); ++i) {
            Node includeElement = includeReferences.item(i);
            if (!(includeElement instanceof Element)) {
                throw new BundleLoadException("Unexpected Assertion node type: " + includeElement.getNodeType());
            }
            try {
                simplifier.simplifyAssertionElement(context.withAssertionElement((Element)includeElement));
                continue;
            }
            catch (DocumentParseException e) {
                throw new BundleLoadException(e.getMessage(), (Throwable)e);
            }
        }
    }

    public Map<String, PolicyAssertionSimplifier> getSimplifiersByTag() {
        return this.simplifiersByTag;
    }
}

