/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayexport.util.policy;

import com.ca.apim.gateway.cagatewayconfig.util.xml.DocumentParseException;
import com.ca.apim.gateway.cagatewayconfig.util.xml.DocumentUtils;
import com.ca.apim.gateway.cagatewayexport.util.policy.PolicyAssertionSimplifier;
import com.ca.apim.gateway.cagatewayexport.util.policy.PolicySimplifierContext;
import com.ca.apim.gateway.cagatewayexport.util.policy.PolicySimplifierUtils;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Singleton;
import org.w3c.dom.Element;

@Singleton
public class HardcodedResponseAssertionSimplifier
implements PolicyAssertionSimplifier {
    private static final Logger LOGGER = Logger.getLogger(HardcodedResponseAssertionSimplifier.class.getName());

    @Override
    public void simplifyAssertionElement(PolicySimplifierContext context) {
        Element base64ResponseBodyElement;
        Element element = context.getAssertionElement();
        try {
            base64ResponseBodyElement = DocumentUtils.getSingleElement((Element)element, (String)"L7p:Base64ResponseBody");
        }
        catch (DocumentParseException e) {
            LOGGER.log(Level.FINE, "Base64ResponseBody missing from hardcoded assertion.");
            return;
        }
        String base64Expression = base64ResponseBodyElement.getAttribute("stringValue");
        byte[] decoded = PolicySimplifierUtils.base64Decode(base64Expression);
        Element expressionElement = element.getOwnerDocument().createElement("L7p:ResponseBody");
        expressionElement.appendChild(element.getOwnerDocument().createCDATASection(new String(decoded)));
        element.insertBefore(expressionElement, base64ResponseBodyElement);
        element.removeChild(base64ResponseBodyElement);
    }

    @Override
    public String getAssertionTagName() {
        return "L7p:HardcodedResponse";
    }
}

