/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayexport.util.policy;

import com.ca.apim.gateway.cagatewayconfig.beans.Bundle;
import com.ca.apim.gateway.cagatewayconfig.beans.IdentityProvider;
import com.ca.apim.gateway.cagatewayconfig.util.xml.DocumentParseException;
import com.ca.apim.gateway.cagatewayconfig.util.xml.DocumentUtils;
import com.ca.apim.gateway.cagatewayexport.util.policy.PolicyAssertionSimplifier;
import com.ca.apim.gateway.cagatewayexport.util.policy.PolicySimplifierContext;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Singleton;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Singleton
public class AuthenticationAssertionSimplifier
implements PolicyAssertionSimplifier {
    private static final Logger LOGGER = Logger.getLogger(AuthenticationAssertionSimplifier.class.getName());

    @Override
    public void simplifyAssertionElement(PolicySimplifierContext context) throws DocumentParseException {
        Element authenticationAssertionElement = context.getAssertionElement();
        Bundle bundle = context.getBundle();
        Element idProviderGoidElement = DocumentUtils.getSingleElement((Element)authenticationAssertionElement, (String)"L7p:IdentityProviderOid");
        String idProviderGoid = idProviderGoidElement.getAttribute("goidValue");
        Optional<IdentityProvider> idProv = bundle.getEntities(IdentityProvider.class).values().stream().filter(e -> e.getId().equals(idProviderGoid)).findAny();
        if (idProv.isPresent()) {
            AuthenticationAssertionSimplifier.updateAuthenticationAssertionElement(authenticationAssertionElement, idProviderGoidElement, idProv.get().getName());
        } else if ("0000000000000000fffffffffffffffe".equals(idProviderGoid)) {
            AuthenticationAssertionSimplifier.updateAuthenticationAssertionElement(authenticationAssertionElement, idProviderGoidElement, "Internal Identity Provider");
        } else {
            LOGGER.log(Level.WARNING, "Could not find referenced identity provider with id: {0}", idProviderGoid);
        }
    }

    private static void updateAuthenticationAssertionElement(Element authenticationAssertionElement, Element goidElementToRemove, String internalIdpName) {
        Node firstChild = authenticationAssertionElement.getFirstChild();
        Element idProviderNameElement = DocumentUtils.createElementWithAttribute((Document)authenticationAssertionElement.getOwnerDocument(), (String)"L7p:IdentityProviderName", (String)"stringValue", (String)internalIdpName);
        if (firstChild != null) {
            authenticationAssertionElement.insertBefore(idProviderNameElement, firstChild);
        } else {
            authenticationAssertionElement.appendChild(idProviderNameElement);
        }
        authenticationAssertionElement.removeChild(goidElementToRemove);
    }

    @Override
    public String getAssertionTagName() {
        return "L7p:Authentication";
    }
}

