/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayexport.tasks.explode.writer;

import com.ca.apim.gateway.cagatewayconfig.beans.Bundle;
import com.ca.apim.gateway.cagatewayconfig.beans.EntityUtils;
import com.ca.apim.gateway.cagatewayconfig.beans.GatewayEntity;
import com.ca.apim.gateway.cagatewayconfig.beans.PropertiesEntity;
import com.ca.apim.gateway.cagatewayconfig.config.spec.ConfigurationFile;
import com.ca.apim.gateway.cagatewayconfig.util.file.DocumentFileUtils;
import com.ca.apim.gateway.cagatewayconfig.util.json.JsonTools;
import com.ca.apim.gateway.cagatewayexport.tasks.explode.writer.WriteException;
import com.ca.apim.gateway.cagatewayexport.util.file.StripFirstLineStream;
import com.ca.apim.gateway.cagatewayexport.util.properties.PropertyFileUtils;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.type.MapType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;

class WriterHelper {
    private static final String CONFIG_DIRECTORY = "config";
    private static final String ERROR_WRITE = "Exception writing %s config file";

    private WriterHelper() {
    }

    static void write(Bundle bundle, File rootFolder, EntityUtils.GatewayEntityInfo info, DocumentFileUtils documentFileUtils, JsonTools jsonTools) {
        if (info.getFileType() == ConfigurationFile.FileType.JSON_YAML) {
            WriterHelper.writeFile(rootFolder, documentFileUtils, jsonTools, bundle.getEntities(info.getEntityClass()), info.getFileName(), info.getEntityClass());
        } else if (info.getFileType() == ConfigurationFile.FileType.PROPERTIES) {
            WriterHelper.writePropertiesFile(rootFolder, documentFileUtils, bundle.getEntities(info.getEntityClass()), info.getFileName());
        } else {
            throw new WriteException("Unsupported file type: " + info.getFileType());
        }
    }

    private static <B extends GatewayEntity> void writePropertiesFile(File rootFolder, DocumentFileUtils documentFileUtils, Map<String, B> beans, String fileName) {
        File configFolder = new File(rootFolder, CONFIG_DIRECTORY);
        documentFileUtils.createFolder(configFolder.toPath());
        Properties properties = new Properties();
        properties.putAll(beans.values().stream().map(b -> {
            b.preWrite(configFolder, documentFileUtils);
            return (PropertiesEntity)b;
        }).collect(Collectors.toMap(PropertiesEntity::getKey, PropertiesEntity::getValue)));
        WriterHelper.writePropertiesFile(rootFolder, documentFileUtils, properties, fileName);
    }

    static synchronized void writePropertiesFile(File rootFolder, DocumentFileUtils documentFileUtils, Properties properties, String fileName) {
        if (properties.isEmpty()) {
            return;
        }
        File configFolder = new File(rootFolder, CONFIG_DIRECTORY);
        documentFileUtils.createFolder(configFolder.toPath());
        File propertiesFile = new File(configFolder, fileName + ".properties");
        Properties currentProperties = PropertyFileUtils.loadExistingProperties(propertiesFile);
        if (!currentProperties.isEmpty()) {
            properties.entrySet().stream().filter(e -> e.getValue() != null).forEach(e -> currentProperties.put(e.getKey(), e.getValue()));
            properties = currentProperties;
        }
        try (StripFirstLineStream outputStream = new StripFirstLineStream(new FileOutputStream(propertiesFile));){
            properties.store(outputStream, null);
        }
        catch (IOException e2) {
            throw new WriteException("Could not create " + fileName + " properties file: " + e2.getMessage(), e2);
        }
    }

    static <B extends GatewayEntity> void writeFile(File rootFolder, DocumentFileUtils documentFileUtils, JsonTools jsonTools, Map<String, B> beans, String fileName, Class<B> beanClass) {
        if (beans.isEmpty()) {
            return;
        }
        File configFolder = new File(rootFolder, CONFIG_DIRECTORY);
        documentFileUtils.createFolder(configFolder.toPath());
        LinkedHashMap beansByName = new LinkedHashMap();
        beans.forEach((k, v) -> {
            v.preWrite(configFolder, documentFileUtils);
            beansByName.put(v.getMappingValue(), v);
        });
        beans = beansByName;
        ObjectWriter objectWriter = jsonTools.getObjectWriter();
        File configFile = new File(configFolder, fileName + jsonTools.getFileExtension());
        if (configFile.exists()) {
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            try {
                objectWriter.writeValue((OutputStream)byteStream, beans);
            }
            catch (IOException e) {
                throw new WriteException(String.format(ERROR_WRITE, fileName), e);
            }
            try {
                ObjectMapper objectMapper = jsonTools.getObjectMapper();
                MapType type = objectMapper.getTypeFactory().constructMapType(LinkedHashMap.class, String.class, beanClass);
                Map contents = (Map)objectMapper.readValue(configFile, (JavaType)type);
                beans = (Map)objectMapper.readerForUpdating((Object)contents).readValue((InputStream)new ByteArrayInputStream(byteStream.toByteArray()));
            }
            catch (IOException e) {
                throw new WriteException("Exception reading existing contents from " + fileName + " config file", e);
            }
        }
        try (OutputStream fileStream = Files.newOutputStream(configFile.toPath(), new OpenOption[0]);){
            objectWriter.writeValue(fileStream, beans);
        }
        catch (IOException e) {
            throw new WriteException(String.format(ERROR_WRITE, fileName), e);
        }
    }
}

