/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayexport.tasks.explode.writer;

import com.ca.apim.gateway.cagatewayconfig.beans.AuditPolicy;
import com.ca.apim.gateway.cagatewayconfig.beans.Bundle;
import com.ca.apim.gateway.cagatewayconfig.beans.Dependency;
import com.ca.apim.gateway.cagatewayconfig.beans.Encass;
import com.ca.apim.gateway.cagatewayconfig.beans.EntityTypeRegistry;
import com.ca.apim.gateway.cagatewayconfig.beans.Folder;
import com.ca.apim.gateway.cagatewayconfig.beans.Folderable;
import com.ca.apim.gateway.cagatewayconfig.beans.GlobalPolicy;
import com.ca.apim.gateway.cagatewayconfig.beans.Policy;
import com.ca.apim.gateway.cagatewayconfig.beans.PolicyMetadata;
import com.ca.apim.gateway.cagatewayconfig.beans.PolicyType;
import com.ca.apim.gateway.cagatewayconfig.beans.Service;
import com.ca.apim.gateway.cagatewayconfig.config.loader.policy.PolicyConverter;
import com.ca.apim.gateway.cagatewayconfig.config.loader.policy.PolicyConverterRegistry;
import com.ca.apim.gateway.cagatewayconfig.util.file.DocumentFileUtils;
import com.ca.apim.gateway.cagatewayconfig.util.file.JsonFileUtils;
import com.ca.apim.gateway.cagatewayconfig.util.paths.PathUtils;
import com.ca.apim.gateway.cagatewayexport.tasks.explode.linker.EntitiesLinker;
import com.ca.apim.gateway.cagatewayexport.tasks.explode.linker.EntityLinkerRegistry;
import com.ca.apim.gateway.cagatewayexport.tasks.explode.writer.EntityWriter;
import com.ca.apim.gateway.cagatewayexport.tasks.explode.writer.WriteException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.io.FileUtils;
import org.w3c.dom.Element;

@Singleton
public class PolicyWriter
implements EntityWriter {
    private final DocumentFileUtils documentFileUtils;
    private final JsonFileUtils jsonFileUtils;
    private PolicyConverterRegistry policyConverterRegistry;
    private final EntityLinkerRegistry entityLinkerRegistry;
    static final String ENCASS_NAME = "encassName";

    @Inject
    PolicyWriter(PolicyConverterRegistry policyConverterRegistry, DocumentFileUtils documentFileUtils, JsonFileUtils jsonFileUtils, EntityLinkerRegistry entityLinkerRegistry) {
        this.policyConverterRegistry = policyConverterRegistry;
        this.documentFileUtils = documentFileUtils;
        this.jsonFileUtils = jsonFileUtils;
        this.entityLinkerRegistry = entityLinkerRegistry;
    }

    @Override
    public void write(Bundle bundle, File rootFolder, Bundle rawBundle) {
        File policyFolder = new File(rootFolder, "policy");
        this.documentFileUtils.createFolder(policyFolder.toPath());
        bundle.getFolderTree().stream().forEach(folder -> {
            if (folder.getParentFolder() != null) {
                Path folderFile = policyFolder.toPath().resolve(bundle.getFolderTree().getPath(folder));
                this.documentFileUtils.createFolder(folderFile);
            }
        });
        HashMap<String, PolicyMetadata> policyMetadataMap = new HashMap<String, PolicyMetadata>();
        Map services = bundle.getEntities(Service.class);
        services.values().parallelStream().forEach(serviceEntity -> {
            this.writePolicy(bundle, policyFolder, (Folderable)serviceEntity, serviceEntity.getPolicyXML());
            PolicyMetadata policyMetadata = this.createPolicyMetadata(bundle, rawBundle, null, (Folderable)serviceEntity);
            policyMetadataMap.put(policyMetadata.getFullPath(), policyMetadata);
        });
        Stream[] streamArray = new Stream[3];
        streamArray[0] = bundle.getEntities(Policy.class).values().stream();
        streamArray[1] = bundle.getEntities(GlobalPolicy.class).values().stream().map(Policy.class::cast).collect(Collectors.toList()).stream();
        streamArray[2] = bundle.getEntities(AuditPolicy.class).values().stream().map(Policy.class::cast).collect(Collectors.toList()).stream();
        Stream.of(streamArray).flatMap(s -> s).forEach(policyEntity -> {
            this.writePolicy(bundle, policyFolder, (Folderable)policyEntity, policyEntity.getPolicyDocument());
            PolicyMetadata policyMetadata = this.createPolicyMetadata(bundle, rawBundle, (Policy)policyEntity, (Folderable)policyEntity);
            policyMetadataMap.put(policyMetadata.getFullPath(), policyMetadata);
        });
        this.writePolicyMetadata(policyMetadataMap, rootFolder);
    }

    private PolicyMetadata createPolicyMetadata(Bundle bundle, Bundle rawBundle, Policy policyEntity, Folderable folderableEntity) {
        PolicyMetadata policyMetadata = new PolicyMetadata();
        Folder folder = bundle.getFolderTree().getFolderById(folderableEntity.getParentFolderId());
        Path policyPath = bundle.getFolderTree().getPath(folder);
        String policyName = folderableEntity.getName();
        policyMetadata.setPath(PathUtils.unixPath((Path)policyPath));
        policyMetadata.setName(policyName);
        if (policyEntity != null) {
            PolicyType policyType = policyEntity.getPolicyType();
            if (policyType != null) {
                policyMetadata.setType(policyType.getType());
            }
            policyMetadata.setTag(policyEntity.getTag());
            policyMetadata.setSubtag(policyEntity.getSubtag());
            policyMetadata.setHasRouting(policyEntity.isHasRouting());
        } else if (folderableEntity instanceof Service) {
            policyMetadata.setHasRouting(((Service)folderableEntity).isHasRouting());
        }
        Set<Dependency> filteredDependencies = this.getFilteredPolicyDependencies(policyMetadata.getFullPath(), this.getPolicyDependencies(folderableEntity.getId(), rawBundle), rawBundle.getEncasses());
        Collection<EntitiesLinker> entityLinkers = this.entityLinkerRegistry.getEntityLinkers();
        entityLinkers.forEach(e -> {
            if (e != null) {
                e.link(filteredDependencies);
            }
        });
        policyMetadata.setUsedEntities(filteredDependencies);
        return policyMetadata;
    }

    private void writePolicyMetadata(Map<String, PolicyMetadata> policyMetadataMap, File rootDir) {
        if (!policyMetadataMap.isEmpty()) {
            this.jsonFileUtils.writePoliciesConfigFile(policyMetadataMap, rootDir);
        }
    }

    private Set<Dependency> getFilteredPolicyDependencies(String policyWithPath, Set<Dependency> policyDependencies, Map<String, Encass> encassMap) {
        return policyDependencies.stream().filter(dependency -> {
            Encass dependentEncass;
            return !"ENCAPSULATED_ASSERTION".equals(dependency.getType()) || (dependentEncass = (Encass)encassMap.get(dependency.getName())) == null || !policyWithPath.equals(dependentEncass.getPolicy());
        }).collect(Collectors.toSet());
    }

    private Set<Dependency> getPolicyDependencies(String id, Bundle rawBundle) {
        HashSet<Dependency> dependencyList = new HashSet<Dependency>();
        Map dependencyListMap = rawBundle.getDependencyMap();
        if (dependencyListMap != null) {
            this.populateDependencies(dependencyListMap, id, dependencyList);
        }
        return dependencyList;
    }

    private void populateDependencies(Map<Dependency, List<Dependency>> dependencyListMap, String id, Set<Dependency> dependencies) {
        Set<Map.Entry<Dependency, List<Dependency>>> entrySet = dependencyListMap.entrySet();
        for (Map.Entry<Dependency, List<Dependency>> entry : entrySet) {
            Dependency parent = entry.getKey();
            if (!parent.getId().equals(id)) continue;
            List<Dependency> dependencyList = entry.getValue();
            for (Dependency dependency : dependencyList) {
                if (!dependencies.add(dependency) || EntityTypeRegistry.NON_ENV_ENTITY_TYPES.contains(dependency.getType())) continue;
                this.populateDependencies(dependencyListMap, dependency.getId(), dependencies);
            }
        }
    }

    private void writePolicy(Bundle bundle, File policyFolder, Folderable folderableEntity, Element policy) {
        Folder folder = bundle.getFolderTree().getFolderById(folderableEntity.getParentFolderId());
        Path folderPath = policyFolder.toPath().resolve(bundle.getFolderTree().getPath(folder));
        this.documentFileUtils.createFolders(folderPath);
        PolicyConverter policyConverter = this.policyConverterRegistry.getFromPolicyElement(folderableEntity.getName(), policy);
        Path policyPath = folderPath.resolve(folderableEntity.getName() + policyConverter.getPolicyTypeExtension());
        try (InputStream policyStream = policyConverter.convertFromPolicyElement(policy);){
            FileUtils.copyInputStreamToFile((InputStream)policyStream, (File)policyPath.toFile());
        }
        catch (IOException e) {
            throw new WriteException("Unable to write assertion js policy", e);
        }
    }
}

