/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayexport.tasks.explode.linker;

import com.ca.apim.gateway.cagatewayconfig.beans.Bundle;
import com.ca.apim.gateway.cagatewayconfig.beans.Folder;
import com.ca.apim.gateway.cagatewayconfig.beans.Service;
import com.ca.apim.gateway.cagatewayconfig.beans.ServiceEnvironmentProperty;
import com.ca.apim.gateway.cagatewayconfig.util.paths.PathUtils;
import com.ca.apim.gateway.cagatewayconfig.util.xml.DocumentParseException;
import com.ca.apim.gateway.cagatewayconfig.util.xml.DocumentTools;
import com.ca.apim.gateway.cagatewayconfig.util.xml.DocumentUtils;
import com.ca.apim.gateway.cagatewayexport.tasks.explode.linker.EntityLinker;
import com.ca.apim.gateway.cagatewayexport.tasks.explode.writer.WriteException;
import com.ca.apim.gateway.cagatewayexport.util.policy.PolicyXMLSimplifier;
import java.nio.file.Path;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@Singleton
public class ServiceLinker
implements EntityLinker<Service> {
    private final DocumentTools documentTools;
    private final PolicyXMLSimplifier policyXMLSimplifier;

    @Inject
    ServiceLinker(DocumentTools documentTools, PolicyXMLSimplifier policyXMLSimplifier) {
        this.documentTools = documentTools;
        this.policyXMLSimplifier = policyXMLSimplifier;
    }

    @Override
    public Class<Service> getEntityClass() {
        return Service.class;
    }

    @Override
    public void link(Service service, Bundle bundle, Bundle targetBundle) {
        try {
            Element policyElement = DocumentUtils.stringToXML((DocumentTools)this.documentTools, (String)service.getPolicy());
            this.policyXMLSimplifier.simplifyPolicyXML(policyElement, service.getName(), bundle, targetBundle);
            service.setPolicyXML(policyElement);
        }
        catch (DocumentParseException e) {
            throw new WriteException("Exception linking and simplifying service: " + service.getName() + " Message: " + e.getMessage(), e);
        }
        service.setPath(ServiceLinker.getServicePath(bundle, service));
        Element servicePropertiesElement = DocumentUtils.getSingleChildElement((Element)service.getServiceDetailsElement(), (String)"l7:Properties");
        NodeList propertyNodes = servicePropertiesElement.getElementsByTagName("l7:Property");
        for (int i = 0; i < propertyNodes.getLength(); ++i) {
            if (!propertyNodes.item(i).getAttributes().getNamedItem("key").getTextContent().startsWith("property.ENV.")) continue;
            ServiceEnvironmentProperty serviceEnvironmentProperty = new ServiceEnvironmentProperty(service.getName() + "." + propertyNodes.item(i).getAttributes().getNamedItem("key").getTextContent().substring(13), DocumentUtils.getSingleChildElement((Element)((Element)propertyNodes.item(i)), (String)"l7:StringValue").getTextContent());
            targetBundle.getEntities(ServiceEnvironmentProperty.class).put(serviceEnvironmentProperty.getName(), serviceEnvironmentProperty);
        }
    }

    static String getServicePath(Bundle bundle, Service serviceEntity) {
        Folder folder = bundle.getFolderTree().getFolderById(serviceEntity.getParentFolder().getId());
        Path folderPath = bundle.getFolderTree().getPath(folder);
        return PathUtils.unixPath((String)folderPath.toString(), (String[])new String[]{serviceEntity.getName()});
    }
}

