/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayexport.tasks.explode.linker;

import com.ca.apim.gateway.cagatewayconfig.beans.AuditPolicy;
import com.ca.apim.gateway.cagatewayconfig.beans.Bundle;
import com.ca.apim.gateway.cagatewayconfig.beans.Folder;
import com.ca.apim.gateway.cagatewayconfig.beans.GatewayEntity;
import com.ca.apim.gateway.cagatewayconfig.beans.GlobalPolicy;
import com.ca.apim.gateway.cagatewayconfig.beans.Policy;
import com.ca.apim.gateway.cagatewayconfig.util.paths.PathUtils;
import com.ca.apim.gateway.cagatewayconfig.util.xml.DocumentParseException;
import com.ca.apim.gateway.cagatewayconfig.util.xml.DocumentTools;
import com.ca.apim.gateway.cagatewayconfig.util.xml.DocumentUtils;
import com.ca.apim.gateway.cagatewayexport.tasks.explode.linker.EntityLinker;
import com.ca.apim.gateway.cagatewayexport.tasks.explode.linker.LinkerException;
import com.ca.apim.gateway.cagatewayexport.tasks.explode.writer.WriteException;
import com.ca.apim.gateway.cagatewayexport.util.policy.PolicyXMLSimplifier;
import java.nio.file.Path;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.w3c.dom.Element;

@Singleton
public class PolicyLinker
implements EntityLinker<Policy> {
    private final DocumentTools documentTools;
    private final PolicyXMLSimplifier policyXMLSimplifier;

    @Inject
    PolicyLinker(DocumentTools documentTools, PolicyXMLSimplifier policyXMLSimplifier) {
        this.documentTools = documentTools;
        this.policyXMLSimplifier = policyXMLSimplifier;
    }

    @Override
    public Class<Policy> getEntityClass() {
        return Policy.class;
    }

    @Override
    public void link(Bundle filteredBundle, Bundle bundle) {
        Stream[] streamArray = new Stream[3];
        streamArray[0] = filteredBundle.getEntities(Policy.class).values().stream();
        streamArray[1] = bundle.getEntities(GlobalPolicy.class).values().stream().map(Policy.class::cast).collect(Collectors.toList()).stream();
        streamArray[2] = bundle.getEntities(AuditPolicy.class).values().stream().map(Policy.class::cast).collect(Collectors.toList()).stream();
        Stream.of(streamArray).flatMap(s -> s).forEach(p -> this.link((Policy)p, bundle, filteredBundle));
    }

    @Override
    public void link(Policy policy, Bundle bundle, Bundle targetBundle) {
        try {
            Element policyElement = DocumentUtils.stringToXML((DocumentTools)this.documentTools, (String)policy.getPolicyXML());
            this.policyXMLSimplifier.simplifyPolicyXML(policyElement, policy.getName(), bundle, targetBundle);
            policy.setPolicyDocument(policyElement);
        }
        catch (DocumentParseException e) {
            throw new WriteException("Exception linking and simplifying policy: " + policy.getName() + " Message: " + e.getMessage(), e);
        }
        policy.setPath(PolicyLinker.getPolicyPath(policy, bundle, policy));
    }

    static <E extends GatewayEntity> String getPolicyPath(Policy policy, Bundle bundle, E entity) {
        Folder folder = bundle.getFolderTree().getFolderById(policy.getParentFolder().getId());
        if (folder == null) {
            throw new LinkerException(String.format("Could not find folder for %s: %s. Policy Name:ID: %s:%s. Folder ID: %s", entity.getClass().getAnnotation(Named.class).value(), entity.getName(), policy.getName(), policy.getId(), policy.getParentFolder().getId()));
        }
        Path folderPath = bundle.getFolderTree().getPath(folder);
        return PathUtils.unixPath((String)folderPath.toString(), (String[])new String[]{policy.getName()});
    }
}

