/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayexport.tasks.explode.linker;

import com.ca.apim.gateway.cagatewayconfig.beans.Bundle;
import com.ca.apim.gateway.cagatewayconfig.beans.JmsDestination;
import com.ca.apim.gateway.cagatewayconfig.beans.PrivateKey;
import com.ca.apim.gateway.cagatewayconfig.beans.Service;
import com.ca.apim.gateway.cagatewayconfig.beans.StoredPassword;
import com.ca.apim.gateway.cagatewayconfig.util.gateway.VariableUtils;
import com.ca.apim.gateway.cagatewayexport.tasks.explode.linker.EntityLinker;
import com.ca.apim.gateway.cagatewayexport.tasks.explode.linker.LinkerConstants;
import com.ca.apim.gateway.cagatewayexport.tasks.explode.linker.LinkerException;
import com.ca.apim.gateway.cagatewayexport.tasks.explode.linker.ServiceLinker;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

@Singleton
public class JmsDestinationLinker
implements EntityLinker<JmsDestination> {
    @Override
    public Class<JmsDestination> getEntityClass() {
        return JmsDestination.class;
    }

    @Override
    public void link(JmsDestination entity, Bundle bundle, Bundle targetBundle) {
        this.linkJndiStoredPassword(entity, bundle);
        this.linkDestinationStoredPassword(entity, bundle);
        this.linkInboundAssociatedService(entity, bundle);
        this.verifyPrivateKeys(entity, bundle);
    }

    private void linkJndiStoredPassword(JmsDestination entity, Bundle bundle) {
        if (entity.getJndiPassword() != null) {
            if (entity.getJndiPassword().startsWith("$L7C2$")) {
                entity.setJndiPassword(null);
            } else {
                Matcher matcher;
                String storedPasswordReference = VariableUtils.extractVariableName((String)entity.getJndiPassword());
                if (!StringUtils.isEmpty((CharSequence)storedPasswordReference) && (matcher = LinkerConstants.STORED_PASSWORD_PATTERN.matcher(storedPasswordReference)).matches()) {
                    String storedPasswordName = matcher.group(1);
                    StoredPassword storedPassword = this.findStoredPasswordRef(entity, bundle, storedPasswordName);
                    entity.setJndiPasswordRef(storedPassword.getName());
                    entity.setJndiPassword(null);
                }
            }
        }
    }

    private void linkDestinationStoredPassword(JmsDestination entity, Bundle bundle) {
        if (entity.getDestinationPassword() != null) {
            if (entity.getDestinationPassword().startsWith("$L7C2$")) {
                entity.setDestinationPassword(null);
            } else {
                Matcher matcher;
                String storedPasswordReference = VariableUtils.extractVariableName((String)entity.getDestinationPassword());
                if (!StringUtils.isEmpty((CharSequence)storedPasswordReference) && (matcher = LinkerConstants.STORED_PASSWORD_PATTERN.matcher(storedPasswordReference)).matches()) {
                    String storedPasswordName = matcher.group(1);
                    StoredPassword storedPassword = this.findStoredPasswordRef(entity, bundle, storedPasswordName);
                    entity.setDestinationPasswordRef(storedPassword.getName());
                    entity.setDestinationPassword(null);
                }
            }
        }
    }

    private void linkInboundAssociatedService(JmsDestination entity, Bundle bundle) {
        if (entity.getInboundDetail() == null || entity.getInboundDetail().getServiceResolutionSettings() == null || StringUtils.isEmpty((CharSequence)entity.getInboundDetail().getServiceResolutionSettings().getServiceRef())) {
            return;
        }
        String serviceRef = entity.getInboundDetail().getServiceResolutionSettings().getServiceRef();
        Service service = bundle.getEntities(Service.class).values().stream().filter(e -> e.getId().equals(serviceRef)).findFirst().orElse(null);
        if (service == null) {
            throw new LinkerException("Could not find associated Service for inbound JMS Destination: " + entity.getName() + ". Service path: " + serviceRef);
        }
        entity.getInboundDetail().getServiceResolutionSettings().setServiceRef(ServiceLinker.getServicePath(bundle, service));
    }

    @NotNull
    private StoredPassword findStoredPasswordRef(JmsDestination entity, Bundle bundle, String storedPasswordName) {
        StoredPassword storedPassword = bundle.getEntities(StoredPassword.class).values().stream().filter(e -> e.getName().equals(storedPasswordName)).findFirst().orElse(null);
        if (storedPassword == null) {
            throw new LinkerException("Could not find Stored Password for JMS Destination: " + entity.getName() + ". Password name: " + storedPasswordName);
        }
        return storedPassword;
    }

    private void verifyPrivateKeys(JmsDestination entity, Bundle bundle) {
        Set aliases = Optional.ofNullable(entity.getAdditionalProperties()).orElseGet(HashMap::new).entrySet().stream().filter(map -> "com.l7tech.server.jms.prop.jndi.ssgKeyAlias".equals(map.getKey()) || "com.l7tech.server.jms.prop.queue.ssgKeyAlias".equals(map.getKey())).map(Map.Entry::getValue).collect(Collectors.toSet());
        if (aliases.isEmpty()) {
            return;
        }
        for (Object alias : aliases) {
            PrivateKey privateKey = bundle.getEntities(PrivateKey.class).values().stream().filter(e -> e.getName().equals(alias)).findFirst().orElse(null);
            if (null != privateKey) continue;
            throw new LinkerException("Could not find Private Key for JMS Destination: " + entity.getName() + ". Private Key alias: " + alias);
        }
    }
}

