/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayexport.tasks.explode.linker;

import com.ca.apim.gateway.cagatewayconfig.beans.Bundle;
import com.ca.apim.gateway.cagatewayconfig.beans.FederatedIdentityProviderDetail;
import com.ca.apim.gateway.cagatewayconfig.beans.GatewayEntity;
import com.ca.apim.gateway.cagatewayconfig.beans.IdentityProvider;
import com.ca.apim.gateway.cagatewayconfig.beans.IdentityProviderDetail;
import com.ca.apim.gateway.cagatewayconfig.beans.TrustedCert;
import com.ca.apim.gateway.cagatewayexport.tasks.explode.linker.EntityLinker;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Singleton;

@Singleton
public class IdentityProviderLinker
implements EntityLinker<IdentityProvider> {
    @Override
    public Class<IdentityProvider> getEntityClass() {
        return IdentityProvider.class;
    }

    @Override
    public void link(IdentityProvider entity, Bundle bundle, Bundle targetBundle) {
        if (entity.getType() != IdentityProvider.IdentityProviderType.FEDERATED) {
            return;
        }
        FederatedIdentityProviderDetail identityProviderDetail = (FederatedIdentityProviderDetail)entity.getIdentityProviderDetail();
        if (identityProviderDetail != null) {
            Set certIds = identityProviderDetail.getCertificateReferences();
            Set trustedCerts = bundle.getEntities(TrustedCert.class).values().stream().filter(e -> certIds.contains(e.getId())).collect(Collectors.toSet());
            if (!trustedCerts.isEmpty()) {
                entity.setIdentityProviderDetail((IdentityProviderDetail)new FederatedIdentityProviderDetail(trustedCerts.stream().map(GatewayEntity::getName).collect(Collectors.toSet())));
            }
        }
    }
}

