/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayexport.tasks.explode.linker;

import com.ca.apim.gateway.cagatewayexport.tasks.explode.linker.EncassLinker;
import com.ca.apim.gateway.cagatewayexport.tasks.explode.linker.EntitiesLinker;
import com.ca.apim.gateway.cagatewayexport.tasks.explode.linker.ServiceLinker;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class EntityLinkerRegistry {
    private final Collection<EntitiesLinker> entityLinkers;
    private static final Map<Class<?>, EntitiesLinker> LINKERS_ORDER = new LinkedHashMap();

    @Inject
    public EntityLinkerRegistry(Set<EntitiesLinker> linkers) {
        this.entityLinkers = Collections.unmodifiableCollection(this.sortLinkers(linkers));
    }

    public Collection<EntitiesLinker> getEntityLinkers() {
        return this.entityLinkers;
    }

    private Collection<EntitiesLinker> sortLinkers(Collection<EntitiesLinker> linkers) {
        LinkedHashSet<EntitiesLinker> orderedLinkers = new LinkedHashSet<EntitiesLinker>(linkers);
        orderedLinkers.removeIf(linker -> {
            if (LINKERS_ORDER.containsKey(linker.getClass())) {
                LINKERS_ORDER.put(linker.getClass(), (EntitiesLinker)linker);
                return true;
            }
            return false;
        });
        for (Map.Entry<Class<?>, EntitiesLinker> classEntitiesLinkerEntry : LINKERS_ORDER.entrySet()) {
            orderedLinkers.add(classEntitiesLinkerEntry.getValue());
        }
        return orderedLinkers;
    }

    static {
        LINKERS_ORDER.put(EncassLinker.class, null);
        LINKERS_ORDER.put(ServiceLinker.class, null);
    }
}

