/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayexport.tasks.explode.filter.entityfilters;

import com.ca.apim.gateway.cagatewayconfig.beans.Bundle;
import com.ca.apim.gateway.cagatewayconfig.beans.StoredPassword;
import com.ca.apim.gateway.cagatewayexport.tasks.explode.filter.EntityFilter;
import com.ca.apim.gateway.cagatewayexport.tasks.explode.filter.FilterConfiguration;
import com.ca.apim.gateway.cagatewayexport.tasks.explode.filter.entityfilters.CassandraConnectionFilter;
import com.ca.apim.gateway.cagatewayexport.tasks.explode.filter.entityfilters.GenericEntityFilter;
import com.ca.apim.gateway.cagatewayexport.tasks.explode.filter.entityfilters.JDBCConnectionFilter;
import com.ca.apim.gateway.cagatewayexport.tasks.explode.filter.entityfilters.PolicyFilter;
import com.ca.apim.gateway.cagatewayexport.tasks.explode.filter.entityfilters.ServiceFilter;
import com.ca.apim.gateway.cagatewayexport.tasks.explode.filter.entityfilters.SsgActiveConnectorFilter;
import com.ca.apim.gateway.cagatewayexport.tasks.explode.filter.entityfilters.UnsupportedEntityFilter;
import com.ca.apim.gateway.cagatewayexport.util.gateway.DependencyUtils;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Singleton;
import org.jetbrains.annotations.NotNull;

@Singleton
public class StoredPasswordFilter
implements EntityFilter<StoredPassword> {
    private static final Set<Class<? extends EntityFilter>> FILTER_DEPENDENCIES = Stream.of(PolicyFilter.class, ServiceFilter.class, JDBCConnectionFilter.class, CassandraConnectionFilter.class, SsgActiveConnectorFilter.class, UnsupportedEntityFilter.class, GenericEntityFilter.class).collect(Collectors.toSet());
    private static final String ENTITY_NAME = "passwords";

    @Override
    @NotNull
    public Collection<Class<? extends EntityFilter>> getDependencyEntityFilters() {
        return FILTER_DEPENDENCIES;
    }

    @Override
    public List<StoredPassword> filter(String folderPath, FilterConfiguration filterConfiguration, Bundle bundle, Bundle filteredBundle) {
        List<StoredPassword> passwords = DependencyUtils.filterDependencies(StoredPassword.class, bundle, filteredBundle, e -> filterConfiguration.getRequiredEntityNames(ENTITY_NAME).contains(e.getName())).stream().filter(e -> e.isType(StoredPassword.Type.PASSWORD)).collect(Collectors.toList());
        DependencyUtils.validateEntitiesInList(passwords, filterConfiguration.getRequiredEntityNames(ENTITY_NAME), "Password(s)");
        return passwords;
    }

    @Override
    public String getFilterableEntityName() {
        return ENTITY_NAME;
    }
}

