/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayexport.tasks.explode.filter.entityfilters;

import com.ca.apim.gateway.cagatewayconfig.beans.Bundle;
import com.ca.apim.gateway.cagatewayconfig.beans.PrivateKey;
import com.ca.apim.gateway.cagatewayexport.tasks.explode.filter.EntityFilter;
import com.ca.apim.gateway.cagatewayexport.tasks.explode.filter.FilterConfiguration;
import com.ca.apim.gateway.cagatewayexport.tasks.explode.filter.entityfilters.PolicyFilter;
import com.ca.apim.gateway.cagatewayexport.tasks.explode.filter.entityfilters.ServiceFilter;
import com.ca.apim.gateway.cagatewayexport.util.gateway.DependencyUtils;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Singleton;
import org.jetbrains.annotations.NotNull;

@Singleton
public class PrivateKeyFilter
implements EntityFilter<PrivateKey> {
    private static final Set<Class<? extends EntityFilter>> FILTER_DEPENDENCIES = Stream.of(PolicyFilter.class, ServiceFilter.class).collect(Collectors.toSet());
    private static final String ENTITY_NAME = "privateKeys";

    @Override
    @NotNull
    public Collection<Class<? extends EntityFilter>> getDependencyEntityFilters() {
        return FILTER_DEPENDENCIES;
    }

    @Override
    public List<PrivateKey> filter(String folderPath, FilterConfiguration filterConfiguration, Bundle bundle, Bundle filteredBundle) {
        Stream<Object> stream = DependencyUtils.filterDependencies(PrivateKey.class, bundle, filteredBundle, e -> filterConfiguration.getRequiredEntityNames(ENTITY_NAME).contains(e.getName())).stream();
        if (!filterConfiguration.getRequiredEntityNames(ENTITY_NAME).contains("SSL".toUpperCase())) {
            stream = stream.filter(p -> !p.getName().equals("SSL".toUpperCase()));
        }
        if (!filterConfiguration.getRequiredEntityNames(ENTITY_NAME).contains("SSL".toLowerCase())) {
            stream = stream.filter(p -> !p.getName().equals("SSL".toLowerCase()));
        }
        List<PrivateKey> privateKeys = stream.collect(Collectors.toList());
        DependencyUtils.validateEntitiesInList(privateKeys, filterConfiguration.getRequiredEntityNames(ENTITY_NAME), "Private Key(s)");
        return privateKeys;
    }

    @Override
    public String getFilterableEntityName() {
        return ENTITY_NAME;
    }
}

