/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayexport.tasks.explode.filter.entityfilters;

import com.ca.apim.gateway.cagatewayconfig.beans.Bundle;
import com.ca.apim.gateway.cagatewayconfig.beans.Folder;
import com.ca.apim.gateway.cagatewayexport.tasks.explode.filter.EntityFilter;
import com.ca.apim.gateway.cagatewayexport.tasks.explode.filter.FilterConfiguration;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Singleton;
import org.jetbrains.annotations.NotNull;

@Singleton
public class FolderFilter
implements EntityFilter<Folder> {
    @Override
    @NotNull
    public Collection<Class<? extends EntityFilter>> getDependencyEntityFilters() {
        return Collections.emptySet();
    }

    @Override
    public List<Folder> filter(String folderPath, FilterConfiguration filterConfiguration, Bundle bundle, Bundle filteredBundle) {
        return bundle.getFolderTree().stream().filter(f -> {
            String path = bundle.getFolderTree().getFormattedPath(f);
            return ("/" + path + "/").startsWith(folderPath + "/");
        }).collect(Collectors.toList());
    }

    public static List<Folder> parentFolders(String folderPath, Bundle bundle) {
        String folderPathWithSuffix = folderPath + "/";
        Stream<Folder> folderStream = bundle.getFolderTree().stream().filter(f -> {
            String path = bundle.getFolderTree().getFormattedPath(f);
            return folderPathWithSuffix.startsWith("/" + path + "/");
        });
        return Stream.concat(Stream.of(bundle.getFolderTree().getRootFolder()), folderStream).collect(Collectors.toList());
    }
}

