/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayexport.tasks.explode.filter;

import com.ca.apim.gateway.cagatewayconfig.beans.Bundle;
import com.ca.apim.gateway.cagatewayconfig.beans.FolderTree;
import com.ca.apim.gateway.cagatewayexport.tasks.explode.filter.EntityFilterRegistry;
import com.ca.apim.gateway.cagatewayexport.tasks.explode.filter.FilterConfiguration;
import com.ca.apim.gateway.cagatewayexport.tasks.explode.filter.entityfilters.FolderFilter;
import java.util.Map;
import javax.inject.Inject;

public class BundleFilter {
    private final EntityFilterRegistry filterRegistry;

    @Inject
    public BundleFilter(EntityFilterRegistry filterRegistry) {
        this.filterRegistry = filterRegistry;
    }

    public Bundle filter(String folderPath, FilterConfiguration filterConfiguration, Bundle bundle) {
        filterConfiguration.getEntityFilters().keySet().forEach(k -> {
            boolean noFilters = this.filterRegistry.getEntityFilters().stream().noneMatch(f -> k.equals(f.getFilterableEntityName()));
            if (noFilters) {
                throw new IllegalArgumentException("Unknown entity type: " + k);
            }
        });
        Bundle filteredBundle = new Bundle();
        this.filterRegistry.getEntityFilters().forEach(ef -> ef.filter(folderPath, filterConfiguration, bundle, filteredBundle).forEach(e -> {
            Map entities = filteredBundle.getEntities(e.getClass());
            entities.put(e.getId(), e);
        }));
        FolderFilter.parentFolders(folderPath, bundle).forEach(f -> filteredBundle.getFolders().put(f.getId(), f));
        FolderTree folderTree = new FolderTree(filteredBundle.getFolders().values());
        filteredBundle.setFolderTree(folderTree);
        return filteredBundle;
    }
}

