/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayexport.tasks.explode.bundle;

import com.ca.apim.gateway.cagatewayconfig.beans.Bundle;
import com.ca.apim.gateway.cagatewayconfig.beans.Dependency;
import com.ca.apim.gateway.cagatewayconfig.beans.EntityTypeRegistry;
import com.ca.apim.gateway.cagatewayconfig.beans.GatewayEntity;
import com.ca.apim.gateway.cagatewayconfig.beans.UnsupportedGatewayEntity;
import com.ca.apim.gateway.cagatewayconfig.bundle.loader.BundleEntityLoader;
import com.ca.apim.gateway.cagatewayconfig.bundle.loader.BundleEntityLoaderRegistry;
import com.ca.apim.gateway.cagatewayconfig.util.injection.InjectionRegistry;
import com.ca.apim.gateway.cagatewayconfig.util.xml.DocumentUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BundleBuilder {
    private static final Logger LOGGER = Logger.getLogger(BundleBuilder.class.getName());
    private final BundleEntityLoaderRegistry entityLoaderRegistry = (BundleEntityLoaderRegistry)InjectionRegistry.getInstance(BundleEntityLoaderRegistry.class);
    private final EntityTypeRegistry entityTypeRegistry = (EntityTypeRegistry)InjectionRegistry.getInstance(EntityTypeRegistry.class);

    public Bundle buildBundle(Element bundleElement) {
        Bundle bundle = new Bundle();
        NodeList nodeList = bundleElement.getElementsByTagName("l7:Item");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            this.handleItem((Element)node, bundle);
        }
        bundle.buildFolderTree();
        bundle.setDependencyMap(this.buildDependencies(DocumentUtils.getSingleChildElement((Element)DocumentUtils.getSingleChildElement((Element)bundleElement, (String)"l7:DependencyGraph"), (String)"l7:Dependencies")));
        return bundle;
    }

    private Map<Dependency, List<Dependency>> buildDependencies(Element dependenciesElement) {
        HashMap<Dependency, List<Dependency>> dependencyMap = new HashMap<Dependency, List<Dependency>>();
        NodeList bundleDependencies = dependenciesElement.getChildNodes();
        for (int i = 0; i < bundleDependencies.getLength(); ++i) {
            Dependency dependency;
            Node dependencyNode = bundleDependencies.item(i);
            if (dependencyNode.getNodeType() != 1 || (dependency = this.buildDependency((Element)dependencyNode)) == null) continue;
            List<Dependency> dependencyList = this.getDependenciesFromNode((Element)dependencyNode);
            dependencyMap.put(dependency, dependencyList);
        }
        return dependencyMap;
    }

    private List<Dependency> getDependenciesFromNode(Element dependencyNode) {
        ArrayList<Dependency> dependencyList = new ArrayList<Dependency>();
        NodeList dependencyDependenciesNodeList = dependencyNode.getElementsByTagName("l7:Dependencies");
        for (int k = 0; k < dependencyDependenciesNodeList.getLength(); ++k) {
            Node dependencyDependenciesNode = dependencyDependenciesNodeList.item(k);
            if (dependencyDependenciesNode.getNodeType() != 1) continue;
            NodeList dependencyDependencies = dependencyDependenciesNode.getChildNodes();
            for (int j = 0; j < dependencyDependencies.getLength(); ++j) {
                Dependency dependencyDependency;
                Node dependencyDependencyNode = dependencyDependencies.item(j);
                if (dependencyDependencyNode.getNodeType() != 1 || (dependencyDependency = this.buildDependency((Element)dependencyDependencyNode)) == null) continue;
                dependencyList.add(dependencyDependency);
            }
        }
        return dependencyList;
    }

    private Dependency buildDependency(Element dependencyElement) {
        String id = DocumentUtils.getSingleChildElement((Element)dependencyElement, (String)"l7:Id").getTextContent();
        String type = DocumentUtils.getSingleChildElement((Element)dependencyElement, (String)"l7:Type").getTextContent();
        String name = DocumentUtils.getSingleChildElement((Element)dependencyElement, (String)"l7:Name").getTextContent();
        Class typeClass = this.entityTypeRegistry.getEntityClass(type);
        if (typeClass != null) {
            return new Dependency(id, typeClass, name, type);
        }
        return new Dependency(id, UnsupportedGatewayEntity.class, name, type);
    }

    private void handleItem(Element element, Bundle bundle) {
        if (DocumentUtils.getSingleChildElement((Element)element, (String)"l7:Type", (boolean)true) == null) {
            return;
        }
        String type = DocumentUtils.getSingleChildElement((Element)element, (String)"l7:Type").getTextContent();
        BundleEntityLoader entityLoader = this.entityLoaderRegistry.getLoader(type);
        if (entityLoader != null) {
            entityLoader.load(bundle, element);
        } else {
            LOGGER.log(Level.INFO, "No entity loader found for entity type: {0}", type);
            this.loadUnsupportedEntity(element, bundle);
        }
    }

    private void loadUnsupportedEntity(Element element, Bundle bundle) {
        UnsupportedGatewayEntity entity = new UnsupportedGatewayEntity();
        entity.setType(DocumentUtils.getSingleChildElement((Element)element, (String)"l7:Type").getTextContent());
        entity.setId(DocumentUtils.getSingleChildElement((Element)element, (String)"l7:Id").getTextContent());
        entity.setName(DocumentUtils.getSingleChildElement((Element)element, (String)"l7:Name").getTextContent());
        entity.setElement(element);
        if ("SERVER_MODULE_FILE".equals(entity.getType())) {
            entity.setExcluded(true);
        }
        LOGGER.log(Level.INFO, "Recording the {0}/{1} with id: {2} as unsupported entity", new Object[]{entity.getType(), entity.getName(), entity.getId()});
        bundle.addEntity((GatewayEntity)entity);
    }
}

