/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayexport.tasks.explode;

import com.ca.apim.gateway.cagatewayconfig.beans.Bundle;
import com.ca.apim.gateway.cagatewayconfig.bundle.loader.BundleLoadException;
import com.ca.apim.gateway.cagatewayconfig.util.injection.InjectionRegistry;
import com.ca.apim.gateway.cagatewayconfig.util.paths.PathUtils;
import com.ca.apim.gateway.cagatewayconfig.util.string.CharacterBlacklistUtil;
import com.ca.apim.gateway.cagatewayconfig.util.xml.DocumentParseException;
import com.ca.apim.gateway.cagatewayconfig.util.xml.DocumentTools;
import com.ca.apim.gateway.cagatewayexport.tasks.explode.bundle.BundleBuilder;
import com.ca.apim.gateway.cagatewayexport.tasks.explode.filter.BundleFilter;
import com.ca.apim.gateway.cagatewayexport.tasks.explode.filter.FilterConfiguration;
import com.ca.apim.gateway.cagatewayexport.tasks.explode.linker.EntitiesLinker;
import com.ca.apim.gateway.cagatewayexport.tasks.explode.linker.EntityLinkerRegistry;
import com.ca.apim.gateway.cagatewayexport.tasks.explode.writer.EntityWriter;
import com.ca.apim.gateway.cagatewayexport.tasks.explode.writer.EntityWriterRegistry;
import java.io.File;
import java.util.Collection;
import javax.inject.Inject;
import org.w3c.dom.Document;

public class ExplodeBundle {
    private final DocumentTools documentTools;
    private final EntityWriterRegistry entityWriterRegistry;
    private final EntityLinkerRegistry entityLinkerRegistry;

    @Inject
    ExplodeBundle(DocumentTools documentTools, EntityWriterRegistry entityWriterRegistry, EntityLinkerRegistry entityLinkerRegistry) {
        this.documentTools = documentTools;
        this.entityWriterRegistry = entityWriterRegistry;
        this.entityLinkerRegistry = entityLinkerRegistry;
    }

    boolean bundleContainsFolderPath(Bundle bundle, String folderPath) {
        if (folderPath.equals("/")) {
            return true;
        }
        return bundle.getFolders().values().stream().anyMatch(folder -> ("/" + PathUtils.unixPath((String)folder.getPath(), (String[])new String[0])).equals(folderPath));
    }

    void explodeBundle(String folderPath, FilterConfiguration filterConfiguration, File bundleFile, File explodeDirectory) throws DocumentParseException {
        Document bundleDocument = this.documentTools.parse(bundleFile);
        this.documentTools.cleanup(bundleDocument);
        BundleBuilder bundleBuilder = (BundleBuilder)InjectionRegistry.getInstance(BundleBuilder.class);
        Bundle bundle = bundleBuilder.buildBundle(bundleDocument.getDocumentElement());
        String encodedFolderPath = folderPath;
        encodedFolderPath = CharacterBlacklistUtil.encodePath((String)folderPath);
        if (!this.bundleContainsFolderPath(bundle, encodedFolderPath)) {
            throw new BundleLoadException("Specified folder " + folderPath + " does not exist in the target gateway.");
        }
        BundleFilter bundleFilter = (BundleFilter)InjectionRegistry.getInstance(BundleFilter.class);
        Bundle filteredBundle = bundleFilter.filter(encodedFolderPath, filterConfiguration, bundle);
        Collection<EntitiesLinker> entityLinkers = this.entityLinkerRegistry.getEntityLinkers();
        entityLinkers.forEach(e -> e.link(filteredBundle, bundle, explodeDirectory));
        Collection<EntityWriter> entityBuilders = this.entityWriterRegistry.getEntityWriters();
        entityBuilders.parallelStream().forEach(e -> e.write(filteredBundle, explodeDirectory, bundle));
    }
}

