/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.util.xml;

import com.ca.apim.gateway.cagatewayconfig.bundle.loader.BundleLoadException;
import com.ca.apim.gateway.cagatewayconfig.util.xml.DocumentParseException;
import com.ca.apim.gateway.cagatewayconfig.util.xml.DocumentTools;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DocumentUtils {
    private DocumentUtils() {
    }

    public static Element getSingleElement(Element entityItemElement, String entityName) throws DocumentParseException {
        NodeList folderNodes = entityItemElement.getElementsByTagName(entityName);
        if (folderNodes.getLength() < 1) {
            throw new DocumentParseException(entityName + " element not found");
        }
        if (folderNodes.getLength() > 1) {
            throw new DocumentParseException("Multiple " + entityName + " elements found");
        }
        Node folderNode = folderNodes.item(0);
        if (folderNode.getNodeType() == 1) {
            return (Element)folderNode;
        }
        throw new DocumentParseException("Unexpected " + entityName + " node discovered: " + folderNode.toString());
    }

    public static Element getSingleChildElement(Element entityItemElement, String elementName) {
        return DocumentUtils.getSingleChildElement(entityItemElement, elementName, false);
    }

    public static Element getSingleChildElement(Element entityItemElement, String elementName, boolean optional) {
        NodeList childNodes = entityItemElement.getChildNodes();
        Node foundNode = null;
        for (int i = 0; i < childNodes.getLength(); ++i) {
            if (!elementName.equals(childNodes.item(i).getNodeName())) continue;
            if (foundNode == null) {
                foundNode = childNodes.item(i);
                continue;
            }
            throw new BundleLoadException("Multiple " + elementName + " elements found");
        }
        if (foundNode == null) {
            if (optional) {
                return null;
            }
            throw new BundleLoadException(elementName + " element not found");
        }
        if (foundNode.getNodeType() == 1) {
            return (Element)foundNode;
        }
        throw new BundleLoadException("Unexpected " + elementName + " node discovered: " + foundNode.toString());
    }

    public static String getSingleChildElementTextContent(Element entityItemElement, String elementName) {
        Element element = DocumentUtils.getSingleChildElement(entityItemElement, elementName, true);
        if (element == null) {
            return null;
        }
        return element.getTextContent();
    }

    public static Set<String> getChildElementsTextContents(Element entityItemElement, String elementName) {
        return DocumentUtils.getChildElements(entityItemElement, elementName).stream().map(Node::getTextContent).collect(Collectors.toSet());
    }

    public static List<String> getChildElementAttributeValues(Element entityItemElement, String elementName, String attribute) {
        return DocumentUtils.getChildElements(entityItemElement, elementName).stream().map(e -> e.getAttribute(attribute)).collect(Collectors.toList());
    }

    public static List<Element> getChildElements(Element entityItemElement, String elementName) {
        if (entityItemElement == null) {
            return Collections.emptyList();
        }
        ArrayList<Element> elements = new ArrayList<Element>();
        NodeList childNodes = entityItemElement.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node child = childNodes.item(i);
            if (!elementName.equals(child.getNodeName()) || child.getNodeType() != 1) continue;
            elements.add((Element)child);
        }
        return elements;
    }

    public static Element createElementWithTextContent(Document document, String elementName, Object textContent) {
        Element element = document.createElement(elementName);
        element.setTextContent(textContent != null ? textContent.toString() : "");
        return element;
    }

    public static Element createElementWithAttribute(Document document, String elementName, String attributeName, String attributeValue) {
        return DocumentUtils.createElementWithAttributes(document, elementName, (Map<String, String>)ImmutableMap.of((Object)attributeName, (Object)attributeValue));
    }

    public static Element createElementWithAttributes(Document document, String elementName, Map<String, String> attributes) {
        Element element = document.createElement(elementName);
        attributes.forEach(element::setAttribute);
        return element;
    }

    public static Element createElementWithChildren(Document document, String elementName, Element ... children) {
        Element element = document.createElement(elementName);
        Stream.of(children).forEach(element::appendChild);
        return element;
    }

    public static Element createElementWithAttributesAndChildren(Document document, String elementName, Map<String, String> attributes, Element ... children) {
        Element element = document.createElement(elementName);
        attributes.forEach(element::setAttribute);
        Stream.of(children).forEach(element::appendChild);
        return element;
    }

    public static Element createElementWithAttributesAndTextContent(Document document, String elementName, Map<String, String> attributes, Object textContent) {
        Element element = document.createElement(elementName);
        attributes.forEach(element::setAttribute);
        element.setTextContent(textContent != null ? textContent.toString() : "");
        return element;
    }

    public static String getSingleChildElementAttribute(Element entityItemElement, String elementName, String attributeName) {
        Element element = DocumentUtils.getSingleChildElement(entityItemElement, elementName, true);
        if (element == null) {
            return null;
        }
        String attribute = element.getAttribute(attributeName);
        return attribute == null || attribute.isEmpty() ? null : attribute;
    }

    public static Element stringToXML(DocumentTools documentTools, String string) throws DocumentParseException {
        Document document = DocumentUtils.stringToXMLDocument(documentTools, string);
        return document.getDocumentElement();
    }

    public static Document stringToXMLDocument(DocumentTools documentTools, String string) throws DocumentParseException {
        Document document = documentTools.parse(string);
        documentTools.cleanup(document);
        return document;
    }

    public static void copyNodes(Element from, String nodeName, Document destination, Element appendInto, @Nullable Predicate<Element> approvingFunction) {
        DocumentUtils.getChildElements(from, nodeName).forEach(child -> {
            if (approvingFunction == null || approvingFunction.test((Element)child)) {
                Node cloned = child.cloneNode(true);
                destination.adoptNode(cloned);
                appendInto.appendChild(cloned);
            }
        });
    }

    public static Iterable<Node> nodeList(final @NotNull NodeList nodeList) {
        return () -> new Iterator<Node>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < nodeList.getLength();
            }

            @Override
            public Node next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return nodeList.item(this.index++);
            }
        };
    }
}

