/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.util.string;

import com.ca.apim.gateway.cagatewayconfig.util.environment.CharacterBlacklist;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CharacterBlacklistUtil {
    private static final Logger LOGGER = Logger.getLogger(CharacterBlacklistUtil.class.getName());
    private static final char REPLACEMENT_CHAR = '-';

    public static String filterAndReplace(String string) {
        Set<Character> charBlacklist = CharacterBlacklist.getCharBlacklist();
        for (char c : string.toCharArray()) {
            if (!charBlacklist.contains(Character.valueOf(c))) continue;
            string = string.replace(c, '-');
        }
        return CharacterBlacklistUtil.compressString(string, '-');
    }

    private static String compressString(String string, char replacementChar) {
        StringBuilder processedString = new StringBuilder(string);
        int iterator = 0;
        while (iterator < processedString.length() - 1) {
            if (processedString.charAt(iterator) == replacementChar && processedString.charAt(iterator + 1) == replacementChar) {
                processedString.deleteCharAt(iterator);
                continue;
            }
            ++iterator;
        }
        return processedString.toString();
    }

    public static boolean containsInvalidCharacter(String name) {
        Set<Character> charBlacklist = CharacterBlacklist.getCharBlacklist();
        for (char c : name.toCharArray()) {
            if (!charBlacklist.contains(Character.valueOf(c))) continue;
            return true;
        }
        return false;
    }

    public static String encodeName(String name) {
        try {
            String encodedName = URLEncoder.encode(name, "UTF-8");
            return encodedName.replaceAll("\\*", "%2A");
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.log(Level.WARNING, "unable to encode folder name " + name);
            throw new RuntimeException("Unable to encode name " + name, e);
        }
    }

    public static String encodePath(String path) {
        if (path.equals("/")) {
            return path;
        }
        String[] folderNames = path.split("/");
        StringBuilder pathBuilder = new StringBuilder();
        for (String folderName : folderNames) {
            pathBuilder.append(CharacterBlacklistUtil.encodeName(folderName));
            pathBuilder.append("/");
        }
        if (!path.endsWith("/")) {
            pathBuilder.deleteCharAt(pathBuilder.length() - 1);
        }
        return pathBuilder.toString();
    }

    public static String decodePath(String path) {
        if (path.equals("/")) {
            return path;
        }
        String[] folderNames = path.split("/");
        StringBuilder pathBuilder = new StringBuilder();
        for (String folderName : folderNames) {
            pathBuilder.append(CharacterBlacklistUtil.decodeName(folderName));
            pathBuilder.append("/");
        }
        if (!path.endsWith("/")) {
            pathBuilder.deleteCharAt(pathBuilder.length() - 1);
        }
        return pathBuilder.toString();
    }

    public static String decodeName(String name) {
        try {
            return URLDecoder.decode(name, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.log(Level.WARNING, "unable to decode folder name " + name);
            throw new RuntimeException("Unable to decode name " + name, e);
        }
    }

    private CharacterBlacklistUtil() {
    }
}

