/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.util.keystore;

import com.ca.apim.gateway.cagatewayconfig.beans.PrivateKey;
import com.ca.apim.gateway.cagatewayconfig.util.keystore.KeyStoreCreationException;
import com.google.common.annotations.VisibleForTesting;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Base64;
import java.util.Collection;
import java.util.Random;
import javax.inject.Singleton;
import org.apache.commons.lang3.RandomStringUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.jetbrains.annotations.NotNull;

@Singleton
public class KeystoreHelper {
    private static final SecureRandom RANDOM = new SecureRandom();
    private final char[] keystorePassword;

    @VisibleForTesting
    public KeystoreHelper() {
        String password = RandomStringUtils.random((int)64, (int)0, (int)0, (boolean)true, (boolean)true, null, (Random)RANDOM);
        this.keystorePassword = Base64.getEncoder().encodeToString(password.getBytes(StandardCharsets.UTF_8)).toCharArray();
    }

    @VisibleForTesting
    public byte[] createKeyStore(Collection<PrivateKey> privateKeys) {
        if (privateKeys.isEmpty()) {
            return new byte[0];
        }
        KeyStore ks = this.createKeyStoreInstance(privateKeys);
        return this.toBytes(ks);
    }

    @VisibleForTesting
    byte[] toBytes(KeyStore ks) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            ks.store(stream, this.keystorePassword);
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new KeyStoreCreationException("Error saving Key Store", e);
        }
        return stream.toByteArray();
    }

    @VisibleForTesting
    KeyStore createKeyStoreInstance(Collection<PrivateKey> privateKeys) {
        KeyStore ks;
        Security.insertProviderAt((Provider)new BouncyCastleProvider(), 1);
        try {
            ks = this.loadKeyStore(null, this.keystorePassword);
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new KeyStoreCreationException("Error creating default key store", e);
        }
        privateKeys.forEach(pk -> this.storeKey(ks, (PrivateKey)pk));
        return ks;
    }

    @VisibleForTesting
    KeyStore loadKeyStore(InputStream stream, char[] password) throws CertificateException, NoSuchAlgorithmException, IOException, KeyStoreException {
        KeyStore ks = KeyStore.getInstance(this.getKeyStoreType());
        ks.load(stream, password);
        return ks;
    }

    @VisibleForTesting
    void storeKey(KeyStore ks, PrivateKey pk) {
        KeyStore privateKeyStore = this.loadKeyStore(pk);
        Key privateKey = this.getKeyFromKeyStore(pk, privateKeyStore);
        Certificate[] certificates = this.loadCertificatesForPrivateKey(pk, privateKeyStore);
        try {
            ks.setKeyEntry(pk.getAlias(), privateKey, this.keystorePassword, certificates);
        }
        catch (KeyStoreException e) {
            throw new KeyStoreCreationException("Error adding Private Key '" + pk.getAlias() + "' to Key Store", e);
        }
    }

    @NotNull
    private Key getKeyFromKeyStore(PrivateKey pk, KeyStore privateKeyStore) {
        Key privateKey;
        try {
            privateKey = privateKeyStore.getKey(pk.getAlias(), pk.getKeyPassword().toCharArray());
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            throw new KeyStoreCreationException("Error loading key " + pk.getAlias() + " from KeyStore p12 file", e);
        }
        if (privateKey == null) {
            throw new KeyStoreCreationException("Key with alias '" + pk.getAlias() + "' not found in the p12 file");
        }
        return privateKey;
    }

    public Certificate[] loadCertificatesForPrivateKey(PrivateKey pk, KeyStore privateKeyStore) {
        Certificate[] certificates;
        try {
            certificates = privateKeyStore.getCertificateChain(pk.getAlias());
        }
        catch (KeyStoreException e) {
            throw new KeyStoreCreationException("Error loading certificate chain for key " + pk.getAlias() + " from KeyStore p12 file", e);
        }
        return certificates;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public KeyStore loadKeyStore(PrivateKey pk) {
        try (InputStream stream = pk.getPrivateKeyFile().getWithIO();){
            KeyStore keyStore = this.loadKeyStore(stream, pk.getKeyPassword().toCharArray());
            return keyStore;
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new KeyStoreCreationException("Error loading Key file for '" + pk.getAlias() + "'", e);
        }
    }

    @NotNull
    public char[] getKeystorePassword() {
        return this.keystorePassword;
    }

    @NotNull
    public String getKeyStoreType() {
        return "PKCS12";
    }
}

