/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.util.json;

import com.ca.apim.gateway.cagatewayconfig.util.file.FileUtils;
import com.ca.apim.gateway.cagatewayconfig.util.file.JsonFileUtilsException;
import com.ca.apim.gateway.cagatewayconfig.util.json.JsonToolsException;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FilenameUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonTools {
    private static final Logger LOGGER = Logger.getLogger(JsonTools.class.getName());
    public static final JsonTools INSTANCE = new JsonTools(FileUtils.INSTANCE);
    public static final String JSON = "json";
    public static final String YAML = "yaml";
    public static final String JSON_EXTENSION = "json";
    public static final String YML_EXTENSION = "yml";
    public static final String YAML_EXTENSION = "yaml";
    private final Map<String, ObjectMapper> objectMapperMap = new HashMap<String, ObjectMapper>();
    private final FileUtils fileUtils;
    private String outputType;
    private String fileExtension;

    public JsonTools(FileUtils fileUtils) {
        this.fileUtils = fileUtils;
        this.objectMapperMap.put("json", JsonTools.buildObjectMapper(new JsonFactory()));
        this.objectMapperMap.put("yaml", JsonTools.buildObjectMapper((JsonFactory)new YAMLFactory().disable(YAMLGenerator.Feature.WRITE_DOC_START_MARKER).configure(YAMLGenerator.Feature.LITERAL_BLOCK_STYLE, true)));
        this.outputType = "yaml";
        this.fileExtension = ".yml";
    }

    public ObjectMapper getObjectMapper() {
        return this.getObjectMapper(this.outputType);
    }

    public ObjectWriter getObjectWriter() {
        return this.getObjectWriter(this.outputType);
    }

    public ObjectWriter getObjectWriter(String outputType) {
        return this.getObjectMapper(outputType).writer().withDefaultPrettyPrinter();
    }

    public ObjectMapper getObjectMapper(String type) {
        ObjectMapper objectMapper = this.objectMapperMap.get(type);
        if (objectMapper == null) {
            throw new IllegalArgumentException("Unknown object mapper for type: " + type);
        }
        return objectMapper;
    }

    public File getDocumentFile(File rootDir, String fileName) {
        return Optional.ofNullable(this.findFile(rootDir, fileName)).orElseGet(() -> this.findFile(new File(rootDir, "config"), fileName));
    }

    private File findFile(File directory, String fileName) {
        File jsonFile = new File(directory, fileName + "." + "json");
        File yamlFile = new File(directory, fileName + "." + "yaml");
        File ymlFile = new File(directory, fileName + "." + YML_EXTENSION);
        File fileToUse = null;
        if (jsonFile.exists() && yamlFile.exists() && ymlFile.exists()) {
            throw new JsonToolsException("Can have either a " + fileName + ".json or a " + fileName + ".yml not both.");
        }
        if (jsonFile.isFile()) {
            fileToUse = jsonFile;
        } else if (yamlFile.isFile()) {
            fileToUse = yamlFile;
        } else if (ymlFile.isFile()) {
            fileToUse = ymlFile;
        }
        if (fileToUse == null) {
            LOGGER.log(Level.FINE, "Did not find a {0} configuration file. Not loading any.", fileName);
        } else {
            LOGGER.log(Level.FINE, "Found file: {0}", fileToUse);
        }
        return fileToUse;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T readDocumentFile(File file, JavaType entityMapType) {
        String type = this.getTypeFromFile(file);
        try (InputStream stream = this.fileUtils.getInputStream(file);){
            T t = this.readStream(stream, type, entityMapType);
            return t;
        }
        catch (IOException e) {
            throw new JsonToolsException("Could not parse configuration file for type: " + entityMapType.getGenericSignature() + " Message:" + e.getMessage(), e);
        }
    }

    public <T> T readStream(InputStream stream, String type, JavaType entityMapType) {
        ObjectMapper objectMapper = this.getObjectMapper(type);
        try {
            return (T)objectMapper.readValue(stream, entityMapType);
        }
        catch (IOException e) {
            throw new JsonToolsException("Could not parse configuration file for type: " + entityMapType.getGenericSignature() + " Message:" + e.getMessage(), e);
        }
    }

    @NotNull
    public String getTypeFromFile(File file) {
        String type = this.getTypeFromExtension(FilenameUtils.getExtension((String)file.getName()));
        if (type == null) {
            throw new JsonToolsException("Invalid file: " + file.getName() + ". Expecting json or yaml file formats.");
        }
        return type;
    }

    @Nullable
    public String getTypeFromExtension(String extension) {
        switch (extension) {
            case "json": {
                return "json";
            }
            case "yml": 
            case "yaml": {
                return "yaml";
            }
        }
        return null;
    }

    public void setOutputType(String outputType) {
        if ("json".equalsIgnoreCase(outputType)) {
            this.outputType = "json";
            this.fileExtension = ".json";
        } else if ("yaml".equalsIgnoreCase(outputType)) {
            this.outputType = "yaml";
            this.fileExtension = ".yml";
        } else {
            LOGGER.log(Level.WARNING, "Output type specified is not YAML nor JSON. Using YAML as the default output type.");
            this.outputType = "yaml";
            this.fileExtension = ".yml";
        }
    }

    public String getFileExtension() {
        return this.fileExtension;
    }

    private static ObjectMapper buildObjectMapper(JsonFactory jf) {
        ObjectMapper objectMapper = new ObjectMapper(jf);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.FAIL_ON_MISSING_EXTERNAL_TYPE_ID_PROPERTY, false);
        if (jf instanceof YAMLFactory) {
            objectMapper.getSerializerProvider().setNullValueSerializer((JsonSerializer)new JsonSerializer<Object>(){

                public void serialize(Object value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
                    gen.writeNumber("");
                }
            });
        }
        return objectMapper;
    }

    public void writeObject(Object object, OutputStream outputStream) {
        ObjectWriter objectWriter = this.getObjectWriter();
        try (OutputStreamWriter writer = new OutputStreamWriter(outputStream, StandardCharsets.UTF_8);){
            objectWriter.writeValue((Writer)writer, object);
        }
        catch (IOException e) {
            throw new JsonFileUtilsException("Exception writing " + this.outputType + " to stream.", e);
        }
    }
}

