/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.util.gateway;

import com.ca.apim.gateway.cagatewayconfig.util.file.SupplierWithIO;
import com.ca.apim.gateway.cagatewayconfig.util.gateway.CertificateUtilsException;
import com.ca.apim.gateway.cagatewayconfig.util.xml.DocumentUtils;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Base64;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CertificateUtils {
    public static final String PEM_CERT_FILE_EXTENSION = ".pem";
    public static final String P12_CERT_FILE_EXTENSION = ".p12";
    static final String PEM_CERT_BEGIN_MARKER = "-----BEGIN CERTIFICATE-----";
    static final String PEM_CERT_END_MARKER = "-----END CERTIFICATE-----";
    static final String LINE_SEPARATOR = System.lineSeparator();

    private CertificateUtils() {
    }

    public static CertificateFactory createX509CertificateFactory() {
        try {
            return CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            throw new IllegalStateException("Unable to load X509 Certificate Factory", e);
        }
    }

    public static Element buildCertDataFromFile(SupplierWithIO<InputStream> certFileLocation, Document document, CertificateFactory certificateFactory) {
        X509Certificate cert = CertificateUtils.loadCertificateFromFile(certFileLocation, certificateFactory);
        return CertificateUtils.createCertDataElementFromCert(cert, document);
    }

    private static X509Certificate loadCertificateFromFile(SupplierWithIO<InputStream> certFileLocation, CertificateFactory certificateFactory) {
        X509Certificate cert;
        try (InputStream is = certFileLocation.getWithIO();){
            cert = (X509Certificate)certificateFactory.generateCertificate(is);
        }
        catch (IOException e) {
            throw new CertificateUtilsException("The certificate file location specified does not exist.");
        }
        catch (CertificateException e) {
            throw new CertificateUtilsException("Error generating certificate from file", e);
        }
        if (cert == null) {
            throw new CertificateUtilsException("Error generating certificate from file.");
        }
        return cert;
    }

    public static Element createCertDataElementFromCert(@NotNull X509Certificate cert, Document document) {
        try {
            return CertificateUtils.createCertDataElementFromCert(cert.getIssuerDN().getName(), cert.getSerialNumber(), cert.getSubjectDN().getName(), Base64.getEncoder().encodeToString(cert.getEncoded()), document);
        }
        catch (CertificateEncodingException e) {
            throw new CertificateUtilsException("Error generating certificate: ", e);
        }
    }

    public static Element createCertDataElementFromCert(String issuerName, BigInteger serialNumber, String subjectName, String encodedData, Document document) {
        return DocumentUtils.createElementWithChildren(document, "l7:CertificateData", DocumentUtils.createElementWithTextContent(document, "l7:IssuerName", issuerName), DocumentUtils.createElementWithTextContent(document, "l7:SerialNumber", serialNumber), DocumentUtils.createElementWithTextContent(document, "l7:SubjectName", subjectName), DocumentUtils.createElementWithTextContent(document, "l7:Encoded", encodedData));
    }

    @VisibleForTesting
    static byte[] prepareCertificateData(@NotNull String encodedData) {
        String formattedData = encodedData.replaceAll("(.{64})", "$1" + LINE_SEPARATOR);
        return (PEM_CERT_BEGIN_MARKER + LINE_SEPARATOR + formattedData + LINE_SEPARATOR + PEM_CERT_END_MARKER).getBytes(StandardCharsets.UTF_8);
    }

    @VisibleForTesting
    static String buildCertificateFileName(@NotNull String certName) {
        return certName + PEM_CERT_FILE_EXTENSION;
    }

    public static void writeCertificateData(@NotNull File certFolder, @NotNull String certName, @NotNull String certEncodedData) {
        String certFileName = CertificateUtils.buildCertificateFileName(certName);
        File certFile = new File(certFolder, certFileName);
        try (OutputStream fileStream = Files.newOutputStream(certFile.toPath(), new OpenOption[0]);){
            fileStream.write(CertificateUtils.prepareCertificateData(certEncodedData));
        }
        catch (IOException e) {
            throw new CertificateUtilsException("Exception writing " + certFileName, e);
        }
    }
}

