/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.util.file;

import com.ca.apim.gateway.cagatewayconfig.bundle.builder.BundleDefinedEntities;
import com.ca.apim.gateway.cagatewayconfig.util.file.DocumentFileUtils;
import com.ca.apim.gateway.cagatewayconfig.util.file.FileUtils;
import com.ca.apim.gateway.cagatewayconfig.util.file.JsonFileUtilsException;
import com.ca.apim.gateway.cagatewayconfig.util.json.JsonTools;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.MapType;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class JsonFileUtils {
    public static final String METADATA_FILE_NAME_SUFFIX = ".metadata" + JsonTools.INSTANCE.getFileExtension();
    private static final String CONFIG_DIR = "config";
    private static final String POLICIES_CONFIG_FILE = "policies" + JsonTools.INSTANCE.getFileExtension();
    public static final JsonFileUtils INSTANCE = new JsonFileUtils(JsonTools.INSTANCE);
    private final JsonTools jsonTools;

    private JsonFileUtils(JsonTools jsonTools) {
        this.jsonTools = jsonTools;
    }

    public void createFile(Object objectToWrite, Path path) {
        OutputStream fos = null;
        try {
            fos = Files.newOutputStream(path, new OpenOption[0]);
            this.jsonTools.writeObject(objectToWrite, fos);
        }
        catch (IOException e) {
            try {
                throw new JsonFileUtilsException("Error writing to file '" + path + "': " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                FileUtils.closeQuietly(fos);
                throw throwable;
            }
        }
        FileUtils.closeQuietly(fos);
    }

    public <T> Map<String, T> readPoliciesConfigFile(File rootDir, Class<T> tClass) {
        File file = this.getPoliciesConfigFile(rootDir);
        return file.exists() ? (Map)this.jsonTools.readDocumentFile(this.getPoliciesConfigFile(rootDir), (JavaType)this.jsonTools.getObjectMapper().getTypeFactory().constructMapType(HashMap.class, String.class, tClass)) : null;
    }

    public void writePoliciesConfigFile(Object object, File rootDir) {
        File configFolder = new File(rootDir, CONFIG_DIR);
        DocumentFileUtils documentFileUtils = DocumentFileUtils.INSTANCE;
        documentFileUtils.createFolder(configFolder.toPath());
        this.createFile(object, this.getPoliciesConfigFile(rootDir).toPath());
    }

    private File getPoliciesConfigFile(File rootDir) {
        return new File(new File(rootDir, CONFIG_DIR), POLICIES_CONFIG_FILE);
    }

    public void createBundleMetadataFile(Object objectToWrite, String fileName, File outputDir) {
        this.createFile(objectToWrite, new File(outputDir, fileName + METADATA_FILE_NAME_SUFFIX).toPath());
    }

    public BundleDefinedEntities readBundleMetadataFile(File metaDataFile) {
        return metaDataFile.exists() ? (BundleDefinedEntities)this.jsonTools.readDocumentFile(metaDataFile, this.jsonTools.getObjectMapper().getTypeFactory().constructType(BundleDefinedEntities.class)) : null;
    }

    public <T> T readBundleMetadataFile(File metaDataFile, Class<T> tClass) {
        try {
            return (T)this.jsonTools.getObjectMapper("yaml").configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).readValue(metaDataFile, tClass);
        }
        catch (IOException e) {
            throw new JsonFileUtilsException("Error reading the bundle metadata file " + metaDataFile.toString(), e);
        }
    }

    public Map<String, Object> readBundleMetadataFile(String bundleFolderPath, String fileName) {
        File metaDataFile = new File(bundleFolderPath, fileName + METADATA_FILE_NAME_SUFFIX);
        if (metaDataFile.exists()) {
            MapType type = this.jsonTools.getObjectMapper("yaml").getTypeFactory().constructMapType(LinkedHashMap.class, String.class, Object.class);
            return (Map)this.jsonTools.readDocumentFile(metaDataFile, (JavaType)type);
        }
        return null;
    }
}

