/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.util.file;

import com.ca.apim.gateway.cagatewayconfig.bundle.builder.EntityBuilderException;
import com.google.common.collect.Lists;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;

public class FileUtils {
    private static final Logger LOGGER = Logger.getLogger(FileUtils.class.getName());
    public static final boolean POSIX_ENABLED = FileSystems.getDefault().supportedFileAttributeViews().contains("posix");
    public static final FileUtils INSTANCE = new FileUtils();

    public InputStream getInputStream(File file) {
        InputStream stream;
        try {
            stream = Files.newInputStream(file.toPath(), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new EntityBuilderException("Could not read file " + file.getPath(), e);
        }
        return stream;
    }

    public OutputStream getOutputStream(File file) {
        OutputStream stream;
        try {
            stream = Files.newOutputStream(file.toPath(), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new EntityBuilderException("Could not write to file " + file.getPath(), e);
        }
        return stream;
    }

    public String getFileAsString(File file) {
        return new String(this.readFile(file));
    }

    private byte[] readFile(File file) {
        try {
            return Files.readAllBytes(file.toPath());
        }
        catch (IOException e) {
            throw new EntityBuilderException("Could not read file " + file.getPath(), e);
        }
    }

    public static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException ioe) {
                LOGGER.log(Level.INFO, "IO error when closing closeable '" + ioe.getMessage() + "'");
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Unexpected error when closing object", e);
            }
        }
    }

    public static List<File> collectFiles(String folder, String extension) {
        File templatizedFolder = new File(folder);
        Object[] templatizedBundles = Optional.ofNullable(templatizedFolder.listFiles((dir, name) -> name.endsWith(extension))).orElse(new File[0]);
        return Lists.newArrayList((Object[])templatizedBundles);
    }

    public static File findConfigFileOrDir(File baseDir, String fileOrDirName) {
        return Stream.of(new File(baseDir, fileOrDirName), new File(new File(baseDir, "config"), fileOrDirName)).filter(File::exists).findFirst().orElse(null);
    }
}

