/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.util.environment;

import com.ca.apim.gateway.cagatewayconfig.ProjectInfo;
import com.ca.apim.gateway.cagatewayconfig.beans.DependentBundle;
import com.ca.apim.gateway.cagatewayconfig.beans.EntityTypeRegistry;
import com.ca.apim.gateway.cagatewayconfig.beans.EntityUtils;
import com.ca.apim.gateway.cagatewayconfig.beans.EnvironmentBundleData;
import com.ca.apim.gateway.cagatewayconfig.beans.GatewayEntity;
import com.ca.apim.gateway.cagatewayconfig.beans.UnsupportedGatewayEntity;
import com.ca.apim.gateway.cagatewayconfig.config.loader.EntityLoader;
import com.ca.apim.gateway.cagatewayconfig.config.loader.EntityLoaderRegistry;
import com.ca.apim.gateway.cagatewayconfig.config.spec.ConfigurationFile;
import com.ca.apim.gateway.cagatewayconfig.config.spec.EnvironmentType;
import com.ca.apim.gateway.cagatewayconfig.environment.MissingEnvironmentException;
import com.ca.apim.gateway.cagatewayconfig.util.file.JsonFileUtils;
import com.ca.apim.gateway.cagatewayconfig.util.json.JsonTools;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

@Singleton
public class EnvironmentConfigurationUtils {
    private static final Logger LOGGER = Logger.getLogger(EnvironmentConfigurationUtils.class.getName());
    private final JsonTools jsonTools;
    private final EntityLoaderRegistry entityLoaderRegistry;
    private final JsonFileUtils jsonFileUtils;
    private final EntityTypeRegistry entityTypeRegistry;

    @Inject
    EnvironmentConfigurationUtils(JsonTools jsonTools, EntityLoaderRegistry entityLoaderRegistry, JsonFileUtils jsonFileUtils, EntityTypeRegistry entityTypeRegistry) {
        this.jsonTools = jsonTools;
        this.entityLoaderRegistry = entityLoaderRegistry;
        this.jsonFileUtils = jsonFileUtils;
        this.entityTypeRegistry = entityTypeRegistry;
    }

    public Map<String, String> parseEnvironmentValues(Map providedEnvironmentValues) {
        HashMap environmentValues = new HashMap();
        providedEnvironmentValues.entrySet().forEach(e -> {
            int index = e.getKey().toString().indexOf(46);
            if (index != -1) {
                environmentValues.put("ENV." + e.getKey().toString(), this.getEnvValue(e.getKey().toString(), e.getValue()));
            } else {
                String entityType = (String)e.getKey();
                Object object = e.getValue();
                if (!(object instanceof File)) {
                    throw new MissingEnvironmentException("Unable to load environment from specified property '" + e.getKey().toString() + "' due to unsupported value, it has to be a file");
                }
                Map<String, String> entities = this.loadConfigFromFile((File)object, entityType);
                entities.entrySet().forEach(entry -> {
                    String cfr_ignored_0 = (String)environmentValues.put("ENV." + entityType + "." + (String)entry.getKey(), entry.getValue());
                });
            }
        });
        return Collections.unmodifiableMap(environmentValues);
    }

    private String getEnvValue(String key, Object o) {
        if (o instanceof String) {
            return (String)o;
        }
        if (o instanceof File) {
            String entityType = key.substring(0, key.indexOf(46));
            String entityName = key.substring(key.indexOf(46) + 1);
            return this.loadConfigFromFile((File)o, entityType, entityName);
        }
        throw new MissingEnvironmentException("Unable to load environment from specified property '" + o.toString() + "' due to unsupported value, it has to be a text content or a file");
    }

    public Pair<String, Map<String, String>> parseBundleMetadata(File metaDataFile, File configFolder) {
        if (!metaDataFile.exists()) {
            throw new MissingEnvironmentException("Metadata file " + metaDataFile.toString() + " does not exist.");
        }
        EnvironmentBundleData environmentBundleData = this.jsonFileUtils.readBundleMetadataFile(metaDataFile, EnvironmentBundleData.class);
        if (environmentBundleData != null && environmentBundleData.getReferencedEntities() != null) {
            String bundleName = environmentBundleData.getName();
            String bundleVersion = environmentBundleData.getVersion();
            LinkedHashMap environmentValues = new LinkedHashMap();
            if (configFolder != null) {
                List<Map<String, String>> environmentEntities = environmentBundleData.getReferencedEntities();
                environmentEntities.forEach(environmentEntitiy -> {
                    Class<? extends GatewayEntity> entityClass;
                    String entityType = (String)environmentEntitiy.get("type");
                    String entityName = (String)environmentEntitiy.get("name");
                    entityName = EnvironmentConfigurationUtils.extractEntityName(entityName);
                    if ("CLUSTER_PROPERTY".equals(entityType)) {
                        entityName = "gateway." + (String)environmentEntitiy.get("name");
                        entityType = "ENVIRONMENT_PROPERTY";
                    }
                    entityClass = (entityClass = this.entityTypeRegistry.getEntityClass(entityType)) == null ? UnsupportedGatewayEntity.class : entityClass;
                    Pair<String, ConfigurationFile.FileType> configFileInfo = EntityUtils.getEntityConfigFileInfo(entityClass);
                    String environmentType = EntityUtils.getEntityEnvironmentType(entityClass);
                    if (configFileInfo == null || environmentType == null) {
                        throw new MissingEnvironmentException("Unexpected entity type " + entityType);
                    }
                    String configFileName = (String)configFileInfo.getLeft() + "." + (((ConfigurationFile.FileType)((Object)((Object)configFileInfo.getRight()))).equals((Object)ConfigurationFile.FileType.JSON_YAML) ? "yml" : ((ConfigurationFile.FileType)((Object)((Object)configFileInfo.getRight()))).name().toLowerCase());
                    File envConfigFile = new File(configFolder, configFileName);
                    if (envConfigFile.exists()) {
                        try {
                            File privateKeyFile;
                            File privateKeysFolder;
                            if (environmentType.equals(UnsupportedGatewayEntity.class.getAnnotation(EnvironmentType.class).value())) {
                                entityName = entityType + "/" + entityName;
                            }
                            environmentValues.put("ENV." + environmentType + "." + entityName, this.loadConfigFromFile(envConfigFile, environmentType, entityName));
                            if ("TRUSTED_CERT".equals(entityType)) {
                                File certDataFile = new File(configFolder + "/certificates", entityName + ".pem");
                                environmentValues.put("ENV.CERTIFICATE_FILE." + entityName + ".pem", this.loadConfigFromFile(certDataFile, "CERTIFICATE_FILE", entityName));
                            } else if ("SSG_KEY_ENTRY".equals(entityType) && (privateKeysFolder = new File(configFolder, "privateKeys")).exists() && (privateKeyFile = new File(privateKeysFolder, entityName + ".p12")).exists()) {
                                environmentValues.put("ENV.PRIVATE_KEY_FILE." + entityName + ".p12", this.loadConfigFromFile(privateKeyFile, "PRIVATE_KEY_FILE", entityName));
                            }
                        }
                        catch (MissingEnvironmentException ex) {
                            LOGGER.log(Level.INFO, "could not find dependent environment entity in the configured folder " + entityName);
                        }
                    }
                });
            }
            bundleName = StringUtils.isBlank((CharSequence)bundleVersion) ? bundleName : bundleName + "-" + bundleVersion;
            return ImmutablePair.of((Object)bundleName, environmentValues);
        }
        return null;
    }

    public Map<String, String> loadConfigFolder(File configFolder) {
        LinkedHashMap<String, String> environmentValues = new LinkedHashMap<String, String>();
        Map<String, EntityUtils.GatewayEntityInfo> entityInfoMap = this.entityTypeRegistry.getEnvironmentEntityTypes();
        entityInfoMap.entrySet().forEach(entityInfoEntry -> {
            String configFileName;
            File envConfigFile;
            String entityType = "CLUSTER_PROPERTY".equals(entityInfoEntry.getKey()) ? "ENVIRONMENT_PROPERTY" : (String)entityInfoEntry.getKey();
            Class<GatewayEntity> entityClass = ((EntityUtils.GatewayEntityInfo)entityInfoEntry.getValue()).getEntityClass();
            Pair<String, ConfigurationFile.FileType> configFileInfo = EntityUtils.getEntityConfigFileInfo(entityClass);
            String environmentType = EntityUtils.getEntityEnvironmentType(entityClass);
            if (configFileInfo != null && environmentType != null && (envConfigFile = new File(configFolder, configFileName = (String)configFileInfo.getLeft() + "." + (((ConfigurationFile.FileType)((Object)((Object)configFileInfo.getRight()))).equals((Object)ConfigurationFile.FileType.JSON_YAML) ? "yml" : ((ConfigurationFile.FileType)((Object)((Object)configFileInfo.getRight()))).name().toLowerCase()))).exists()) {
                Map<String, String> entities = this.loadConfigFromFile(envConfigFile, environmentType);
                entities.entrySet().forEach(entry -> {
                    File privateKeyFile;
                    File privateKeysFolder;
                    environmentValues.put("ENV." + environmentType + "." + (String)entry.getKey(), (String)entry.getValue());
                    if ("TRUSTED_CERT".equals(entityType)) {
                        File certDataFile = new File(configFolder + "/certificates", (String)entry.getKey() + ".pem");
                        environmentValues.put("ENV.CERTIFICATE_FILE." + (String)entry.getKey() + ".pem", this.loadConfigFromFile(certDataFile, "CERTIFICATE_FILE", (String)entry.getKey()));
                    } else if ("SSG_KEY_ENTRY".equals(entityType) && (privateKeysFolder = new File(configFolder, "privateKeys")).exists() && (privateKeyFile = new File(privateKeysFolder, (String)entry.getKey() + ".p12")).exists()) {
                        environmentValues.put("ENV.PRIVATE_KEY_FILE." + (String)entry.getKey() + ".p12", this.loadConfigFromFile(privateKeyFile, "PRIVATE_KEY_FILE", (String)entry.getKey()));
                    }
                });
            }
        });
        return environmentValues;
    }

    @NotNull
    public String loadConfigFromFile(File configFile, String entityType, String entityName) {
        if (!configFile.exists()) {
            throw new MissingEnvironmentException("Environment config file " + configFile.toString() + " does not exist.");
        }
        EntityLoader loader = this.entityLoaderRegistry.getLoader(entityType);
        Object entity = loader.loadSingle(entityName, configFile);
        if (entity == null) {
            throw new MissingEnvironmentException("Environment config file " + configFile.toString() + " does not have the configuration for entity " + entityName + ", type " + entityType + ".");
        }
        if (entity instanceof String) {
            return (String)entity;
        }
        try {
            return this.jsonTools.getObjectWriter("json").writeValueAsString(entity);
        }
        catch (JsonProcessingException e) {
            throw new MissingEnvironmentException("Unable to read environment for specified configuration " + entityName, e);
        }
    }

    @NotNull
    public Map<String, String> loadConfigFromFile(File configFile, String entityType) {
        if (!configFile.exists()) {
            throw new MissingEnvironmentException("Environment config file " + configFile.toString() + " does not exist.");
        }
        EntityLoader loader = this.entityLoaderRegistry.getLoader(entityType);
        Map<String, Object> entityMap = loader.load(configFile);
        HashMap<String, String> entities = new HashMap<String, String>();
        entityMap.entrySet().forEach(e -> {
            if (e.getValue() instanceof String) {
                entities.put((String)e.getKey(), (String)e.getValue());
            }
            try {
                entities.put((String)e.getKey(), this.jsonTools.getObjectWriter("json").writeValueAsString(e.getValue()));
            }
            catch (JsonProcessingException ex) {
                throw new MissingEnvironmentException("Unable to read environment for specified configuration " + (String)e.getKey(), ex);
            }
        });
        return entities;
    }

    public static String tryInferContentTypeFromValue(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return null;
        }
        char initial = value.trim().charAt(0);
        switch (initial) {
            case '[': 
            case '{': {
                return "json";
            }
            case '<': {
                throw new MissingEnvironmentException("XML Environment Values are not yet supported.");
            }
        }
        return "yaml";
    }

    public static DependentBundle generateDependentEnvBundleFromProject(ProjectInfo projectInfo) {
        DependentBundle envBundle = new DependentBundle();
        envBundle.setGroupName(projectInfo.getGroupName());
        envBundle.setName(projectInfo.getName() + "-" + "environment");
        String version = StringUtils.isNotBlank((CharSequence)projectInfo.getVersion()) ? projectInfo.getMajorVersion() + "." + projectInfo.getMinorVersion() : "";
        envBundle.setVersion(version);
        envBundle.setType("bundle");
        return envBundle;
    }

    public static String extractEntityName(String entityName) {
        String originalName = entityName;
        String[] originalNameArray = entityName.split("::");
        if (originalNameArray.length > 2) {
            originalName = originalNameArray[2];
        }
        return originalName;
    }
}

