/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.util;

import java.io.IOException;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class IdValidator {
    static final Pattern PAT_TRAILING_HEX = Pattern.compile("[0-9a-f]+$", 2);
    static final String[] ZEROS;
    static final String[] ONES;

    private IdValidator() {
    }

    static String decompressString(@NotNull String goidString) {
        if (goidString.length() > 32) {
            throw new IllegalArgumentException("Invalid GOID (too long)");
        }
        StringBuilder sb = new StringBuilder();
        String string = goidString;
        int segs = 0;
        while (string.length() > 0) {
            int neededNybbles;
            Matcher m = PAT_TRAILING_HEX.matcher(string);
            if (m.find()) {
                string = m.replaceFirst("");
                sb.insert(0, m.group(0));
            } else if (string.endsWith("n") || string.endsWith("N")) {
                ++segs;
                string = string.substring(0, string.length() - 1);
                neededNybbles = 16 - sb.length() % 16;
                sb.insert(0, ONES[neededNybbles]);
            } else if (string.endsWith("z") || string.endsWith("Z")) {
                ++segs;
                string = string.substring(0, string.length() - 1);
                neededNybbles = 16 - sb.length() % 16;
                sb.insert(0, ZEROS[neededNybbles]);
            } else {
                throw new IllegalArgumentException("Invalid Goid (unrecognized suffix)");
            }
            if (segs <= 2) continue;
            throw new IllegalArgumentException("Invalid Goid (too many segments)");
        }
        return sb.toString();
    }

    public static boolean isValidGoid(String goid) {
        if (StringUtils.isBlank((CharSequence)goid)) {
            return false;
        }
        try {
            byte[] goidFromString;
            String goidHex = goid.length() == 32 ? goid : IdValidator.decompressString(goid);
            try {
                goidFromString = IdValidator.unHexDump(goidHex);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Cannot create goid from this String. Invalid hex data: " + goid);
            }
            if (goidFromString.length != 16) {
                throw new IllegalArgumentException("Cannot create a goid from this String, it does not decode to a 16 byte array.");
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static boolean isValidGuid(String guid) {
        if (StringUtils.isBlank((CharSequence)guid)) {
            return false;
        }
        try {
            UUID.fromString(guid);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static byte[] unHexDump(String hexData) throws IOException {
        if (hexData.length() % 2 != 0) {
            throw new IOException("String must be of even length");
        }
        byte[] bytes = new byte[hexData.length() / 2];
        for (int i = 0; i < hexData.length(); i += 2) {
            byte b1 = IdValidator.nybble(hexData.charAt(i));
            byte b2 = IdValidator.nybble(hexData.charAt(i + 1));
            bytes[i / 2] = (byte)((b1 << 4) + b2);
        }
        return bytes;
    }

    private static byte nybble(char hex) throws IOException {
        if (hex <= '9' && hex >= '0') {
            return (byte)(hex - 48);
        }
        if (hex >= 'a' && hex <= 'f') {
            return (byte)(hex - 97 + 10);
        }
        if (hex >= 'A' && hex <= 'F') {
            return (byte)(hex - 65 + 10);
        }
        throw new IOException("Invalid hex digit " + hex);
    }

    static {
        StringBuilder sbz = new StringBuilder();
        StringBuilder sbf = new StringBuilder();
        String[] z = new String[17];
        String[] f = new String[17];
        for (int i = 0; i <= 16; ++i) {
            z[i] = sbz.toString();
            sbz.append("0");
            f[i] = sbf.toString();
            sbf.append("f");
        }
        ZEROS = z;
        ONES = f;
    }
}

