/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.environment;

import com.ca.apim.gateway.cagatewayconfig.environment.BundleDetemplatizeException;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collections;

interface TemplatizedBundle {
    public String getName();

    public String getContents();

    public void writeContents(String var1);

    public static class StringTemplatizedBundle
    implements TemplatizedBundle {
        private final String name;
        private String bundleContents;

        StringTemplatizedBundle(String name, String bundleContents) {
            this.name = name;
            this.bundleContents = bundleContents;
        }

        @Override
        public String getContents() {
            return this.bundleContents;
        }

        @Override
        public void writeContents(String content) {
            this.bundleContents = content;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }

    public static class FileTemplatizedBundle
    implements TemplatizedBundle {
        private final File newFile;
        private final File originalFile;

        FileTemplatizedBundle(File originalFile, File newFile) {
            this.newFile = newFile;
            this.originalFile = originalFile;
        }

        @Override
        public String getContents() {
            try {
                return new String(Files.readAllBytes(this.originalFile.toPath()), StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                throw new BundleDetemplatizeException("Could not read bundle file: " + this.originalFile.getName(), e);
            }
        }

        @Override
        public void writeContents(String content) {
            try {
                Files.write(this.newFile.toPath(), Collections.singleton(content), StandardCharsets.UTF_8, new OpenOption[0]);
            }
            catch (IOException e) {
                throw new BundleDetemplatizeException("Could not write detemplatized bundle to: " + this.newFile.getName(), e);
            }
        }

        @Override
        public String getName() {
            return this.originalFile.getName();
        }
    }
}

