/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.environment;

import com.ca.apim.gateway.cagatewayconfig.ProjectInfo;
import com.ca.apim.gateway.cagatewayconfig.beans.Bundle;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.BundleArtifacts;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.BundleEntityBuilder;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.EntityBuilder;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.EntityBuilderException;
import com.ca.apim.gateway.cagatewayconfig.environment.EnvironmentBundleBuilder;
import com.ca.apim.gateway.cagatewayconfig.environment.EnvironmentBundleCreationMode;
import com.ca.apim.gateway.cagatewayconfig.environment.EnvironmentBundleUtils;
import com.ca.apim.gateway.cagatewayconfig.environment.TemplatizedBundle;
import com.ca.apim.gateway.cagatewayconfig.util.bundle.DependencyBundlesProcessor;
import com.ca.apim.gateway.cagatewayconfig.util.file.DocumentFileUtils;
import com.ca.apim.gateway.cagatewayconfig.util.file.DocumentFileUtilsException;
import com.ca.apim.gateway.cagatewayconfig.util.file.FileUtils;
import com.ca.apim.gateway.cagatewayconfig.util.file.JsonFileUtils;
import com.ca.apim.gateway.cagatewayconfig.util.xml.DocumentParseException;
import com.ca.apim.gateway.cagatewayconfig.util.xml.DocumentTools;
import com.ca.apim.gateway.cagatewayconfig.util.xml.DocumentUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.xml.parsers.DocumentBuilder;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Singleton
public class FullBundleCreator {
    private static final Logger LOGGER = Logger.getLogger(FullBundleCreator.class.getName());
    private final DocumentTools documentTools;
    private final EnvironmentBundleBuilder environmentBundleBuilder;
    private final BundleEntityBuilder bundleEntityBuilder;
    private final FileUtils fileUtils;
    private final DependencyBundlesProcessor dependencyBundlesProcessor;
    private final DocumentFileUtils documentFileUtils;
    private final JsonFileUtils jsonFileUtils;

    @Inject
    FullBundleCreator(DocumentTools documentTools, EnvironmentBundleBuilder environmentBundleBuilder, BundleEntityBuilder bundleEntityBuilder, FileUtils fileUtils, DependencyBundlesProcessor dependencyBundlesProcessor, DocumentFileUtils documentFileUtils, JsonFileUtils jsonFileUtils) {
        this.documentTools = documentTools;
        this.environmentBundleBuilder = environmentBundleBuilder;
        this.bundleEntityBuilder = bundleEntityBuilder;
        this.fileUtils = fileUtils;
        this.dependencyBundlesProcessor = dependencyBundlesProcessor;
        this.documentFileUtils = documentFileUtils;
        this.jsonFileUtils = jsonFileUtils;
    }

    public void createFullBundle(Pair<String, Map<String, String>> bundleEnvironmentValues, List<File> dependentBundles, String bundleFolderPath, final ProjectInfo projectInfo, String fullInstallBundleFilename, String environmentConfigurationFolderPath, boolean detemplatizeDeploymentBundles) {
        Map<String, Object> bundleMetadata;
        BundleArtifacts fullBundleArtifacts = this.createFullAndDeleteBundles(bundleEnvironmentValues, dependentBundles, bundleFolderPath, environmentConfigurationFolderPath, detemplatizeDeploymentBundles, projectInfo, fullInstallBundleFilename);
        String bundle = this.documentTools.elementToString(fullBundleArtifacts.getInstallBundle().getElement());
        File fullBundleFile = new File(System.getProperty(SystemUtils.JAVA_IO_TMPDIR), fullInstallBundleFilename);
        try {
            org.apache.commons.io.FileUtils.writeStringToFile((File)fullBundleFile, (String)bundle, (Charset)Charset.defaultCharset());
        }
        catch (IOException e) {
            throw new DocumentFileUtilsException("Error writing to file '" + fullInstallBundleFilename + "': " + e.getMessage(), e);
        }
        this.dependencyBundlesProcessor.process(Collections.singletonList(fullBundleFile), bundleFolderPath);
        String fullDeleteBundleFilename = fullInstallBundleFilename.replace(".install.bundle", ".delete.bundle");
        this.documentFileUtils.createFile(fullBundleArtifacts.getDeleteBundle().getElement(), new File(bundleFolderPath, fullDeleteBundleFilename).toPath());
        boolean deleted = fullBundleFile.delete();
        if (!deleted) {
            LOGGER.log(Level.WARNING, () -> "Temporary bundle file was not deleted: " + fullBundleFile.toString());
        }
        if ((bundleMetadata = this.jsonFileUtils.readBundleMetadataFile(bundleFolderPath, (String)bundleEnvironmentValues.getLeft())) != null) {
            List dependencies = (List)bundleMetadata.get("dependencies");
            dependencies.removeIf(new Predicate<Map<String, String>>(){

                @Override
                public boolean test(Map<String, String> dependentBundleMap) {
                    String version = StringUtils.isNotBlank((CharSequence)projectInfo.getVersion()) ? projectInfo.getMajorVersion() + "." + projectInfo.getMinorVersion() : "";
                    return dependentBundleMap.get("name").equals(projectInfo.getName() + "-" + "environment") && dependentBundleMap.get("groupName").equals(projectInfo.getGroupName()) && (dependentBundleMap.get("version") == null || dependentBundleMap.get("version").equals(version));
                }
            });
            this.cleanIntermediateFiles(bundleFolderPath, (String)bundleEnvironmentValues.getLeft());
            String bundleMetaFileName = (String)bundleEnvironmentValues.getLeft();
            if (StringUtils.isNotBlank((CharSequence)projectInfo.getVersion())) {
                bundleMetadata.put("version", projectInfo.getVersion() + "-full");
                bundleMetaFileName = bundleMetaFileName + "-full";
            }
            this.jsonFileUtils.createBundleMetadataFile(bundleMetadata, bundleMetaFileName, new File(bundleFolderPath));
        }
        if (!fullBundleArtifacts.getPrivateKeyContexts().isEmpty()) {
            fullBundleArtifacts.getPrivateKeyContexts().forEach(privateKey -> this.documentFileUtils.createFile(privateKey.getElement(), new File(bundleFolderPath, privateKey.getFilename()).toPath()));
        }
    }

    private void cleanIntermediateFiles(String bundleFolderPath, String filenamePrefix) {
        File[] interimFiles;
        for (File interimFile : interimFiles = new File[]{new File(bundleFolderPath, filenamePrefix + JsonFileUtils.METADATA_FILE_NAME_SUFFIX), new File(bundleFolderPath, filenamePrefix + ".install.bundle"), new File(bundleFolderPath, filenamePrefix + ".delete.bundle")}) {
            boolean deleted = interimFile.delete();
            if (deleted) continue;
            LOGGER.log(Level.WARNING, () -> "Couldn't delete Intermediate file: " + interimFile.toString());
        }
    }

    private BundleArtifacts createFullAndDeleteBundles(Pair<String, Map<String, String>> bundleEnvironmentValues, List<File> dependentBundles, String bundleFolderPath, String environmentConfigurationFolderPath, boolean detemplatizeDeploymentBundles, ProjectInfo projectInfo, String fullInstallBundleFilename) {
        Map environmentProperties = (Map)bundleEnvironmentValues.getRight();
        List<File> deploymentBundles = FileUtils.collectFiles(bundleFolderPath, (String)bundleEnvironmentValues.getLeft() + ".install.bundle");
        List<File> deploymentDeleteBundle = FileUtils.collectFiles(bundleFolderPath, (String)bundleEnvironmentValues.getLeft() + ".delete.bundle");
        List bundleFiles = ListUtils.union(deploymentBundles, dependentBundles);
        List<TemplatizedBundle> templatizedBundles = bundleFiles.stream().map(f -> new TemplatizedBundle.StringTemplatizedBundle(f.getName(), this.fileUtils.getFileAsString((File)f))).collect(Collectors.toList());
        Bundle environmentBundle = new Bundle(projectInfo);
        this.environmentBundleBuilder.build(environmentBundle, environmentProperties, environmentConfigurationFolderPath, EnvironmentBundleCreationMode.PLUGIN);
        EnvironmentBundleUtils.processDeploymentBundles(environmentBundle, templatizedBundles, EnvironmentBundleCreationMode.PLUGIN, detemplatizeDeploymentBundles);
        DocumentBuilder documentBuilder = this.documentTools.getDocumentBuilder();
        Document document = documentBuilder.newDocument();
        Map<String, BundleArtifacts> bundleElements = this.bundleEntityBuilder.build(environmentBundle, EntityBuilder.BundleType.ENVIRONMENT, document, projectInfo);
        Element bundleElement = this.createFullBundleElement(bundleElements, templatizedBundles, document);
        Element deleteBundleElement = this.createDeleteBundleElement(bundleElements, deploymentDeleteBundle, dependentBundles, document);
        String fullDeleteBundleFilename = fullInstallBundleFilename.replace(".install.bundle", ".delete.bundle");
        BundleArtifacts fullBundleArtifacts = new BundleArtifacts(bundleElement, deleteBundleElement, null, fullInstallBundleFilename, fullDeleteBundleFilename);
        this.bundleEntityBuilder.addPrivateKeyContexts(environmentBundle, projectInfo, fullBundleArtifacts, document);
        return fullBundleArtifacts;
    }

    private Element createFullBundleElement(Map<String, BundleArtifacts> bundleElements, List<TemplatizedBundle> templatizedBundles, Document document) {
        Element bundleElement = null;
        for (Map.Entry<String, BundleArtifacts> entry : bundleElements.entrySet()) {
            bundleElement = entry.getValue().getInstallBundle().getElement();
            Element referencesElement = DocumentUtils.getSingleChildElement(bundleElement, "l7:References");
            Element mappingsElement = DocumentUtils.getSingleChildElement(bundleElement, "l7:Mappings");
            HashSet addedItems = new HashSet();
            HashSet addedMappings = new HashSet();
            templatizedBundles.forEach(tb -> {
                try {
                    Element detemplatizedBundleElement = this.documentTools.parse(tb.getContents()).getDocumentElement();
                    DocumentUtils.copyNodes(DocumentUtils.getSingleChildElement(detemplatizedBundleElement, "l7:References"), "l7:Item", document, referencesElement, item -> addedItems.add(EnvironmentBundleUtils.buildBundleItemKey(item)));
                    DocumentUtils.copyNodes(DocumentUtils.getSingleChildElement(detemplatizedBundleElement, "l7:Mappings"), "l7:Mapping", document, mappingsElement, mapping -> {
                        String key = EnvironmentBundleUtils.buildBundleMappingKey(mapping);
                        return addedItems.contains(key) && addedMappings.add(key);
                    });
                }
                catch (DocumentParseException e) {
                    throw new EntityBuilderException("Unable to read bundle " + tb.getName(), e);
                }
            });
        }
        return bundleElement;
    }

    private Element createDeleteBundleElement(Map<String, BundleArtifacts> bundleElements, List<File> deploymentDeleteBundles, List<File> dependentBundles, Document document) {
        Element bundleElement = null;
        for (Map.Entry<String, BundleArtifacts> entry : bundleElements.entrySet()) {
            bundleElement = entry.getValue().getDeleteBundle().getElement();
            Element referencesElement = DocumentUtils.getSingleChildElement(bundleElement, "l7:References");
            Element mappingsElement = DocumentUtils.getSingleChildElement(bundleElement, "l7:Mappings");
            HashSet addedItems = new HashSet();
            HashSet addedMappings = new HashSet();
            dependentBundles.forEach(file -> {
                try {
                    Element element = this.documentTools.parse(this.fileUtils.getFileAsString((File)file)).getDocumentElement();
                    DocumentUtils.copyNodes(DocumentUtils.getSingleChildElement(element, "l7:References"), "l7:Item", document, referencesElement, item -> addedItems.add(EnvironmentBundleUtils.buildBundleItemKey(item)));
                    FullBundleCreator.copyDeleteMappings(DocumentUtils.getSingleChildElement(element, "l7:Mappings"), "l7:Mapping", document, mappingsElement, mapping -> {
                        String key = EnvironmentBundleUtils.buildBundleMappingKey(mapping);
                        String type = mapping.getAttribute("type");
                        return !"FOLDER".equals(type) && addedItems.contains(key) && addedMappings.add(key);
                    });
                }
                catch (DocumentParseException e) {
                    throw new EntityBuilderException("Unable to read bundle " + file.getName(), e);
                }
            });
            this.addDeleteBundleNodes(deploymentDeleteBundles, referencesElement, mappingsElement, document);
        }
        return bundleElement;
    }

    private static void copyDeleteMappings(Element from, String nodeName, Document destination, Element appendInto, @Nullable Predicate<Element> approvingFunction) {
        List<Element> elementList = DocumentUtils.getChildElements(from, nodeName);
        for (int index = elementList.size() - 1; index >= 0; --index) {
            Element child = elementList.get(index);
            child.setAttribute("action", "Delete");
            if (approvingFunction != null && !approvingFunction.test(child)) continue;
            Node cloned = child.cloneNode(true);
            destination.adoptNode(cloned);
            appendInto.appendChild(cloned);
        }
    }

    private void addDeleteBundleNodes(List<File> deploymentDeleteBundles, Element referencesElement, Element mappingsElement, Document document) {
        deploymentDeleteBundles.forEach(file -> {
            try {
                Element element = this.documentTools.parse(this.fileUtils.getFileAsString((File)file)).getDocumentElement();
                DocumentUtils.copyNodes(DocumentUtils.getSingleChildElement(element, "l7:References"), "l7:Item", document, referencesElement, item -> true);
                DocumentUtils.copyNodes(DocumentUtils.getSingleChildElement(element, "l7:Mappings"), "l7:Mapping", document, mappingsElement, mapping -> true);
            }
            catch (DocumentParseException e) {
                throw new EntityBuilderException("Unable to read bundle " + file.getName(), e);
            }
        });
    }
}

