/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.environment;

import com.ca.apim.gateway.cagatewayconfig.beans.Bundle;
import com.ca.apim.gateway.cagatewayconfig.bundle.loader.BundleLoadException;
import com.ca.apim.gateway.cagatewayconfig.bundle.loader.BundleLoadingOperation;
import com.ca.apim.gateway.cagatewayconfig.bundle.loader.EntityBundleLoader;
import com.ca.apim.gateway.cagatewayconfig.environment.BundleCache;
import com.ca.apim.gateway.cagatewayconfig.environment.BundleDetemplatizer;
import com.ca.apim.gateway.cagatewayconfig.environment.BundleEnvironmentValidator;
import com.ca.apim.gateway.cagatewayconfig.environment.EnvironmentBundleCreationMode;
import com.ca.apim.gateway.cagatewayconfig.environment.TemplatizedBundle;
import com.ca.apim.gateway.cagatewayconfig.util.file.FileUtils;
import com.ca.apim.gateway.cagatewayconfig.util.injection.InjectionRegistry;
import com.ca.apim.gateway.cagatewayconfig.util.xml.DocumentUtils;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Element;

public class EnvironmentBundleUtils {
    private static final Logger logger = Logger.getLogger(EnvironmentBundleUtils.class.getName());
    private static String templatizedBundlesFolderPath;

    private EnvironmentBundleUtils() {
    }

    static void setTemplatizedBundlesFolderPath(String folderPath) {
        templatizedBundlesFolderPath = folderPath;
    }

    public static Bundle getDeploymentBundle() {
        if (templatizedBundlesFolderPath == null) {
            throw new BundleLoadException("Invalid deployment bundle path : " + templatizedBundlesFolderPath);
        }
        BundleCache cache = (BundleCache)InjectionRegistry.getInjector().getInstance(BundleCache.class);
        if (cache.contains(templatizedBundlesFolderPath)) {
            return cache.getBundle(templatizedBundlesFolderPath);
        }
        EntityBundleLoader loader = (EntityBundleLoader)InjectionRegistry.getInjector().getInstance(EntityBundleLoader.class);
        List<File> deploymentBundleFiles = FileUtils.collectFiles(templatizedBundlesFolderPath, ".install.bundle");
        cache.putBundle(templatizedBundlesFolderPath, loader.load(deploymentBundleFiles, BundleLoadingOperation.EXPORT, new String[0]));
        return loader.load(deploymentBundleFiles, BundleLoadingOperation.EXPORT, new String[0]);
    }

    static void processDeploymentBundles(Bundle environmentBundle, List<TemplatizedBundle> templatizedBundles, EnvironmentBundleCreationMode mode, boolean detemplatize) {
        if (!detemplatize) {
            return;
        }
        BundleEnvironmentValidator bundleEnvironmentValidator = new BundleEnvironmentValidator(environmentBundle);
        BundleDetemplatizer bundleDetemplatizer = new BundleDetemplatizer(environmentBundle);
        templatizedBundles.forEach(tb -> EnvironmentBundleUtils.processTemplatizedBundle(tb, bundleEnvironmentValidator, bundleDetemplatizer, mode));
    }

    private static void processTemplatizedBundle(TemplatizedBundle templatizedBundle, BundleEnvironmentValidator bundleEnvironmentValidator, BundleDetemplatizer bundleDetemplatizer, EnvironmentBundleCreationMode mode) {
        logger.log(Level.FINE, () -> "Processing deployment bundle: " + templatizedBundle.getName());
        String bundleString = templatizedBundle.getContents();
        bundleEnvironmentValidator.validateEnvironmentProvided(templatizedBundle.getName(), bundleString, mode);
        CharSequence detemplatizedBundle = bundleDetemplatizer.detemplatizeBundleString(bundleString);
        templatizedBundle.writeContents(detemplatizedBundle.toString());
    }

    @VisibleForTesting
    public static String buildBundleItemKey(Element item) {
        return DocumentUtils.getSingleChildElementTextContent(item, "l7:Id") + ":" + DocumentUtils.getSingleChildElementTextContent(item, "l7:Type");
    }

    @VisibleForTesting
    public static String buildBundleMappingKey(Element mapping) {
        return mapping.getAttribute("srcId") + ":" + mapping.getAttribute("type");
    }
}

