/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.environment;

import com.ca.apim.gateway.cagatewayconfig.ProjectInfo;
import com.ca.apim.gateway.cagatewayconfig.beans.Bundle;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.BundleArtifacts;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.BundleEntityBuilder;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.EntityBuilder;
import com.ca.apim.gateway.cagatewayconfig.environment.EnvironmentBundleBuilder;
import com.ca.apim.gateway.cagatewayconfig.environment.EnvironmentBundleCreationMode;
import com.ca.apim.gateway.cagatewayconfig.environment.EnvironmentBundleUtils;
import com.ca.apim.gateway.cagatewayconfig.environment.TemplatizedBundle;
import com.ca.apim.gateway.cagatewayconfig.util.file.DocumentFileUtils;
import com.ca.apim.gateway.cagatewayconfig.util.file.FileUtils;
import com.ca.apim.gateway.cagatewayconfig.util.file.JsonFileUtils;
import com.ca.apim.gateway.cagatewayconfig.util.xml.DocumentTools;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.xml.parsers.DocumentBuilder;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Document;

@Singleton
public class EnvironmentBundleCreator {
    private final DocumentTools documentTools;
    private final DocumentFileUtils documentFileUtils;
    private final EnvironmentBundleBuilder environmentBundleBuilder;
    private final BundleEntityBuilder bundleEntityBuilder;
    private final JsonFileUtils jsonFileUtils;

    @Inject
    EnvironmentBundleCreator(DocumentTools documentTools, DocumentFileUtils documentFileUtils, EnvironmentBundleBuilder environmentBundleBuilder, BundleEntityBuilder bundleEntityBuilder, JsonFileUtils jsonFileUtils) {
        this.documentTools = documentTools;
        this.documentFileUtils = documentFileUtils;
        this.environmentBundleBuilder = environmentBundleBuilder;
        this.bundleEntityBuilder = bundleEntityBuilder;
        this.jsonFileUtils = jsonFileUtils;
    }

    public Bundle createEnvironmentBundle(Map<String, String> environmentProperties, String bundleFolderPath, String templatizedBundleFolderPath, String environmentConfigurationFolderPath, EnvironmentBundleCreationMode mode, String envInstallBundleFilename, ProjectInfo projectInfo) {
        Bundle environmentBundle = new Bundle(projectInfo);
        this.environmentBundleBuilder.build(environmentBundle, environmentProperties, environmentConfigurationFolderPath, mode);
        EnvironmentBundleUtils.setTemplatizedBundlesFolderPath(templatizedBundleFolderPath);
        EnvironmentBundleUtils.processDeploymentBundles(environmentBundle, this.collectTemplatizedBundleFiles(templatizedBundleFolderPath, mode, bundleFolderPath), mode, true);
        DocumentBuilder documentBuilder = this.documentTools.getDocumentBuilder();
        Document document = documentBuilder.newDocument();
        Map<String, BundleArtifacts> bundleElements = this.bundleEntityBuilder.build(environmentBundle, EntityBuilder.BundleType.ENVIRONMENT, document, projectInfo, true);
        for (BundleArtifacts bundleArtifacts : bundleElements.values()) {
            this.documentFileUtils.createFile(bundleArtifacts.getInstallBundle().getElement(), new File(bundleFolderPath, envInstallBundleFilename).toPath());
            this.documentFileUtils.createFile(bundleArtifacts.getDeleteBundle().getElement(), new File(bundleFolderPath, envInstallBundleFilename.replace(".install.bundle", ".delete.bundle")).toPath());
            this.jsonFileUtils.createBundleMetadataFile(bundleArtifacts.getBundleMetadata(), envInstallBundleFilename.replace(".install.bundle", ""), new File(bundleFolderPath));
            if (bundleArtifacts.getPrivateKeyContexts().isEmpty()) continue;
            bundleArtifacts.getPrivateKeyContexts().forEach(privateKey -> this.documentFileUtils.createFile(privateKey.getElement(), new File(bundleFolderPath, privateKey.getFilename()).toPath()));
        }
        return environmentBundle;
    }

    private List<TemplatizedBundle> collectTemplatizedBundleFiles(String templatizedBundleFolderPath, EnvironmentBundleCreationMode mode, String bundleFolderPath) {
        String extension = mode != EnvironmentBundleCreationMode.PLUGIN ? ".bundle" : "-policy.install.bundle";
        return FileUtils.collectFiles(templatizedBundleFolderPath, extension).stream().filter(file -> !StringUtils.endsWithIgnoreCase((CharSequence)file.getName(), (CharSequence)".delete.bundle")).map(f -> new TemplatizedBundle.FileTemplatizedBundle((File)f, new File(bundleFolderPath, f.getName()))).collect(Collectors.toList());
    }
}

