/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.config.loader.policy;

import com.ca.apim.gateway.cagatewayconfig.beans.Policy;
import com.ca.apim.gateway.cagatewayconfig.config.loader.policy.PolicyConverter;
import com.ca.apim.gateway.cagatewayconfig.config.loader.policy.PolicyConverterException;
import com.ca.apim.gateway.cagatewayconfig.util.xml.DocumentTools;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.w3c.dom.Element;

@Singleton
public class XMLPolicyConverter
implements PolicyConverter {
    public static final String EXTENSION = ".xml";
    private final DocumentTools documentTools;

    @Inject
    public XMLPolicyConverter(DocumentTools documentTools) {
        this.documentTools = documentTools;
    }

    @Override
    public String getPolicyTypeExtension() {
        return EXTENSION;
    }

    @Override
    public String getPolicyXML(Policy policy, String policyString) {
        return policyString;
    }

    @Override
    public boolean canConvert(String name, Element policy) {
        return false;
    }

    @Override
    public InputStream convertFromPolicyElement(Element policy) {
        PipedOutputStream out = new PipedOutputStream();
        new Thread(() -> this.documentTools.printXML(policy, out, false)).start();
        try {
            return new PipedInputStream(out);
        }
        catch (IOException e) {
            throw new PolicyConverterException("Unable to create stream for converting policy xml.", e);
        }
    }
}

